/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.viewbuilders;

import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.gaap.servicelayer.GeocodeManager;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import gr.cite.geoanalytics.common.ViewBuilder;
import gr.cite.geoanalytics.context.Configuration;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.gos.client.ShapeManagement;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Configurable
public abstract class AbstractViewBuilder
implements ViewBuilder {
    private static Logger log = LoggerFactory.getLogger(AbstractViewBuilder.class);
    @PersistenceContext
    protected EntityManager entityManager;
    protected ShapeManagement shapeManagement;
    protected Configuration context;
    protected GeocodeManager taxonomyManager;
    protected ConfigurationManager configurationManager;
    protected String identity = null;
    protected Shape shape = null;
    protected String viewStatement = null;
    protected Map<String, ShapeAttributeDataType> attrs = new LinkedHashMap<String, ShapeAttributeDataType>();

    public AbstractViewBuilder(GeocodeManager taxonomyManager, ConfigurationManager configurationManager) {
        this.taxonomyManager = taxonomyManager;
        this.configurationManager = configurationManager;
    }

    @Inject
    public void setShapeManagement(ShapeManagement shapeManagement) {
        this.shapeManagement = shapeManagement;
    }

    @Inject
    public void setContext(Configuration context) {
        this.context = context;
    }

    private ShapeAttributeDataType parseDataType(String dataType, String data) {
        if (dataType.equalsIgnoreCase("short")) {
            return ShapeAttributeDataType.SHORT;
        }
        if (dataType.equalsIgnoreCase("int")) {
            return ShapeAttributeDataType.INTEGER;
        }
        if (dataType.equalsIgnoreCase("decimal") || dataType.equalsIgnoreCase("integer") || dataType.equalsIgnoreCase("long")) {
            return ShapeAttributeDataType.LONG;
        }
        if (dataType.equalsIgnoreCase("float")) {
            return ShapeAttributeDataType.FLOAT;
        }
        if (dataType.equalsIgnoreCase("double")) {
            return ShapeAttributeDataType.DOUBLE;
        }
        if (dataType.equalsIgnoreCase("date")) {
            return ShapeAttributeDataType.DATE;
        }
        if (data.length() < 250) {
            return ShapeAttributeDataType.STRING;
        }
        return ShapeAttributeDataType.LONGSTRING;
    }

    public ViewBuilder createViewStatement() throws Exception {
        this.viewStatement = this.generateViewStatement(this.identity, this.attrs);
        return this;
    }

    public ViewBuilder removeViewStatement() throws Exception {
        this.viewStatement = this.removeViewIfExists();
        return this;
    }

    public String getViewStatement() throws Exception {
        if (this.viewStatement == null) {
            this.createViewStatement();
        }
        return this.viewStatement;
    }

    public ViewBuilder withAttribute(String key, ShapeAttributeDataType value) {
        this.attrs.put(key, value);
        return this;
    }

    private void mergeInfoForShape() throws Exception {
        String extraData = this.shape.getExtraData();
        if (extraData == null) {
            extraData = "";
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document data = db.parse(new InputSource(new ByteArrayInputStream(extraData.getBytes("UTF-8"))));
        int len = data.getDocumentElement().getChildNodes().getLength();
        for (int i = 0; i < len; ++i) {
            Node n = data.getDocumentElement().getChildNodes().item(i);
            String value = "";
            if (n.getFirstChild() != null) {
                value = n.getFirstChild().getNodeValue();
            }
            String attrName = n.getNodeName();
            this.attrs.put(attrName, this.parseDataType(((Element)n).getAttribute("type"), value));
        }
    }

    public ViewBuilder forShape(Shape shape) throws Exception {
        this.shape = shape;
        if (this.attrs == null) {
            this.attrs = new HashMap<String, ShapeAttributeDataType>();
        }
        if (shape == null) {
            throw new IllegalArgumentException("No shape provided");
        }
        if (shape.getGeography() == null) {
            throw new IllegalArgumentException("Shape geography not present");
        }
        if (shape.getName() == null) {
            throw new IllegalArgumentException("Shape name not assigned");
        }
        this.mergeInfoForShape();
        return this;
    }

    public ViewBuilder forShapes(List<Shape> shapes) throws Exception {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, ShapeAttributeDataType>();
        }
        Iterator<Shape> iterator = shapes.iterator();
        while (iterator.hasNext()) {
            Shape s;
            this.shape = s = iterator.next();
            this.mergeInfoForShape();
        }
        return this;
    }

    public ViewBuilder forIdentity(String identity) throws Exception {
        this.identity = identity;
        if (this.attrs == null) {
            this.attrs = new HashMap<String, ShapeAttributeDataType>();
        }
        return this;
    }

    protected abstract String generateViewStatement(String var1, Map<String, ShapeAttributeDataType> var2) throws Exception;

    public boolean execute(String gosEndpoint) throws Exception {
        return this.shapeManagement.applyOnView(gosEndpoint, this.getViewStatement());
    }

    public abstract String removeViewIfExists() throws Exception;
}

