/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.viewbuilders;

import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.gaap.servicelayer.GeocodeManager;
import gr.cite.gaap.viewbuilders.PostGISViewBuilder;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import gr.cite.geoanalytics.context.Configuration;
import gr.cite.geoanalytics.dataaccess.entities.geocode.Geocode;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.AttributeMappingConfig;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PostGISRegularViewBuilder
extends PostGISViewBuilder {
    private static Logger log = LoggerFactory.getLogger(PostGISRegularViewBuilder.class);
    private Configuration configuration = null;

    @Inject
    public PostGISRegularViewBuilder(GeocodeManager taxonomyManager, ConfigurationManager configurationManager) {
        super(taxonomyManager, configurationManager);
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected String generateViewStatement(String identity, Map<String, ShapeAttributeDataType> attrs) throws Exception {
        StringBuilder sql = new StringBuilder();
        String funcName = "delete_table_or_view";
        sql.append(this.createDropFunction(funcName));
        sql.append("SELECT " + funcName + "('" + identity + "');");
        sql.append("CREATE OR REPLACE VIEW \"" + identity + "\" (");
        sql.append(this.configuration.getDataLayerConfig().getShapeGeographyColumnName());
        sql.append(",");
        sql.append(this.configuration.getDataLayerConfig().getShapeIdColumnName());
        for (Map.Entry<String, ShapeAttributeDataType> attr : attrs.entrySet()) {
            List mcfgs = this.configurationManager.getMappingConfigsForLayer(attr.getKey(), identity);
            AttributeMappingConfig taxonomyMapping = null;
            boolean presentable = true;
            if (mcfgs != null) {
                for (AttributeMappingConfig mcfg : mcfgs) {
                    if (mcfg.getAttributeValue() != null && !mcfg.getAttributeValue().equals("")) continue;
                    if (!mcfg.isPresentable().booleanValue()) {
                        presentable = false;
                        break;
                    }
                    if (mcfg.getTermId() == null) continue;
                    taxonomyMapping = mcfg;
                    break;
                }
            }
            if (!presentable) continue;
            sql.append(", ");
            if (taxonomyMapping != null) {
                GeocodeSystem t = this.taxonomyManager.findGeocodeSystemById(taxonomyMapping.getTermId(), false);
                if (t == null) {
                    log.error("Taxonomy " + taxonomyMapping.getTermId() + " defined in mappings of attribute " + taxonomyMapping.getAttributeName() + " not found");
                    throw new Exception("Taxonomy " + taxonomyMapping.getTermId() + " defined in mappings of attribute " + taxonomyMapping.getAttributeName() + " not found");
                }
                sql.append(t.getName());
                continue;
            }
            sql.append(attr.getKey());
        }
        sql.append(")\n");
        sql.append("AS ");
        sql.append("SELECT ");
        sql.append(this.configuration.getDataLayerConfig().getShapeGeographyColumnName() + "::geometry");
        sql.append(",");
        sql.append(this.configuration.getDataLayerConfig().getShapeIdColumnName());
        for (Map.Entry<String, ShapeAttributeDataType> attr : attrs.entrySet()) {
            String attrExpression = "(xpath('//extraData/" + attr.getKey() + "/text()', s." + this.configuration.getDataLayerConfig().getShapeDataColumnName() + "))[1]::text";
            List mcfgs = this.configurationManager.getMappingConfigsForLayer(attr.getKey(), identity);
            boolean valueMapping = false;
            Boolean mapValue = false;
            boolean presentable = true;
            if (mcfgs != null && !mcfgs.isEmpty()) {
                for (AttributeMappingConfig mcfg : mcfgs) {
                    if (mcfg.getAttributeValue() != null && !mcfg.getAttributeValue().equals("")) {
                        valueMapping = true;
                        mapValue = mcfg.isMapValue();
                        continue;
                    }
                    if (mcfg.getAttributeValue() != null && !mcfg.getAttributeValue().equals("") || mcfg.isPresentable().booleanValue()) continue;
                    presentable = false;
                    break;
                }
            }
            if (!presentable) continue;
            sql.append(", ");
            if (valueMapping && mapValue.booleanValue()) {
                sql.append("\n");
                sql.append("CASE ");
                sql.append(attrExpression);
                sql.append(attr.getValue() != ShapeAttributeDataType.LONGSTRING ? "::" + this.getSQLDataType(attr.getValue()) : "");
                for (AttributeMappingConfig mcfg : mcfgs) {
                    if (mcfg.getAttributeValue() == null || mcfg.getAttributeValue().equals("")) continue;
                    Geocode tt = this.taxonomyManager.findTermById(mcfg.getTermId(), false);
                    if (tt == null) {
                        log.error("Taxonomy term " + mcfg.getTermId() + " defined in mappings of attribute " + mcfg.getAttributeName() + " not found");
                        throw new Exception("Taxonomy term " + mcfg.getTermId() + " defined in mappings of attribute " + mcfg.getAttributeName() + " not found");
                    }
                    String dt = this.getSQLDataType(attr.getValue());
                    sql.append("\n");
                    sql.append(" WHEN ");
                    sql.append(this.quoteTextual(mcfg.getAttributeValue(), attr.getValue()));
                    sql.append(" THEN ");
                    sql.append(this.quoteTextual(tt.getName(), attr.getValue()));
                }
                sql.append("\n");
                sql.append("ELSE ");
                sql.append(attrExpression);
                sql.append(attr.getValue() != ShapeAttributeDataType.LONGSTRING ? "::" + this.getSQLDataType(attr.getValue()) : "");
                sql.append(" END");
                continue;
            }
            sql.append(attrExpression);
            sql.append(attr.getValue() != ShapeAttributeDataType.LONGSTRING ? "::" + this.getSQLDataType(attr.getValue()) : "");
        }
        sql.append("\n");
        sql.append("FROM " + this.configuration.getDataLayerConfig().getShapeTableName() + " s\n");
        if (identity != null) {
            sql.append("WHERE s." + this.configuration.getDataLayerConfig().getShapeLayerLayerColumnName() + "='" + identity + "';");
        } else {
            sql.append("WHERE " + this.configuration.getDataLayerConfig().getShapeIdColumnName() + "='" + this.shape.getId() + "'");
        }
        sql.append(";");
        System.out.println("SQL = " + sql.toString());
        return sql.toString();
    }

    @Override
    public String removeViewIfExists() throws Exception {
        StringBuilder sql = new StringBuilder();
        try {
            String statement = "DROP VIEW IF EXISTS \"" + this.identity + "\" ;";
            sql.append(statement);
            this.entityManager.createNativeQuery(statement);
            log.debug("Drop view if exists" + this.identity);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return sql.toString();
    }
}

