/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.elements;

import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Layer;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.elements.Contact;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils.BuildWmsUrl;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils.Parsers;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils.ReadMetadataProperties;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.annotation.XmlTransient;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.TopologyLevel;
import org.opengis.util.InternationalString;

public class MetaDataForm {
    private String user;
    private String title;
    private Date date;
    private String abstractField;
    private String purpose;
    private PresentationForm presentationForm;
    private List<String> credits;
    private List<String> keywords;
    private List<TopicCategory> topicCategory;
    private ExtentImpl extent;
    private GeometricObjectType geometricObjectType;
    private TopologyLevel topologyLevel;
    private int geometrycount;
    private double resolution;
    private String graphicOverview;
    private String projectName;
    private Contact provider;
    private Contact distributor;
    private String fileIdentifier;
    private String userLimitation;
    private Language language;

    public MetaDataForm(String user, String title, Date date) {
        Properties properties = ReadMetadataProperties.getInstance().getProperties();
        this.provider = new Contact();
        this.distributor = new Contact();
        this.provider.setRole(Contact.Role.RESOURCE_PROVIDER);
        this.distributor.setRole(Contact.Role.DISTRIBUTOR);
        this.user = user;
        this.title = title;
        this.date = date;
        this.abstractField = properties.getProperty("abstract");
        this.purpose = properties.getProperty("purpose");
        this.presentationForm = PresentationForm.valueOf((String)properties.getProperty("presentationForm"));
        this.credits = Parsers.parseList(properties.getProperty("credits"));
        this.keywords = Parsers.parseList(properties.getProperty("keywords"));
        this.topicCategory = Parsers.parseTopicCategoryList(properties.getProperty("topicCategory"));
        this.extent = Parsers.parseExtentList(properties.getProperty("extent"));
        this.geometricObjectType = GeometricObjectType.valueOf((String)properties.getProperty("geometricObjectType"));
        this.topologyLevel = TopologyLevel.valueOf((String)properties.getProperty("topologyLevel"));
        this.geometrycount = Integer.parseInt(properties.getProperty("geometryCount"));
        this.resolution = Double.parseDouble(properties.getProperty("resolution"));
        this.graphicOverview = properties.getProperty("graphicOverview");
        this.projectName = properties.getProperty("projectName");
        this.language = Language.ENGLISH;
    }

    public MetaDataForm() {
        this.provider = new Contact();
        this.distributor = new Contact();
    }

    public String getFileIdentifier() {
        return this.fileIdentifier;
    }

    public void setFileIdentifier(String fileIdentifier) {
        this.fileIdentifier = fileIdentifier;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getAbstractField() {
        return this.abstractField;
    }

    public void setAbstractField(String abstractField) {
        this.abstractField = abstractField;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public PresentationForm getPresentationForm() {
        return this.presentationForm;
    }

    public void setPresentationForm(PresentationForm presentationForm) {
        this.presentationForm = presentationForm;
    }

    public List<String> getCredits() {
        return this.credits;
    }

    public void setCredits(List<String> credits) {
        this.credits = credits;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public List<TopicCategory> getTopicCategory() {
        return this.topicCategory;
    }

    public void setTopicCategory(List<TopicCategory> topicCategory) {
        this.topicCategory = topicCategory;
    }

    public String getExtentDescription() {
        return this.extent.getDescription().toString();
    }

    @XmlTransient
    public ExtentImpl getExtent() {
        return this.extent;
    }

    public void setExtent(ExtentImpl extent) {
        this.extent = extent;
    }

    public void setExtent(double west, double east, double south, double north) {
        ExtentImpl extent = new ExtentImpl();
        extent.setGeographicElements(Collections.singleton(new GeographicBoundingBoxImpl(west, east, south, north)));
        extent.setDescription((InternationalString)new SimpleInternationalString("Bounding box"));
        this.extent = extent;
    }

    public GeometricObjectType getGeometricObjectType() {
        return this.geometricObjectType;
    }

    public void setGeometricObjectType(GeometricObjectType geometricObjectType) {
        this.geometricObjectType = geometricObjectType;
    }

    public TopologyLevel getTopologyLevel() {
        return this.topologyLevel;
    }

    public void setTopologyLevel(TopologyLevel topologyLevel) {
        this.topologyLevel = topologyLevel;
    }

    public int getGeometrycount() {
        return this.geometrycount;
    }

    public void setGeometrycount(int geometrycount) {
        this.geometrycount = geometrycount;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public String getGraphicOverview() {
        return this.graphicOverview;
    }

    public void setGraphicOverviewExternal(String graphicOverview) {
        this.graphicOverview = graphicOverview;
    }

    public void setGraphicOverviewFromLayer(Layer layer, FeatureType featureType, String geoserverUrl) {
        Bounds bBox = featureType.getLatLonBoundingBox();
        String bBoxString = bBox.getMinx() + "," + bBox.getMiny() + "," + bBox.getMaxx() + "," + bBox.getMaxy();
        BuildWmsUrl wmsUrl = new BuildWmsUrl(geoserverUrl, layer.getWorkspace(), layer.getName(), "400", "600", bBoxString, featureType.getSrs());
        this.graphicOverview = wmsUrl.getFinalWmsUrl();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Contact getProvider() {
        return this.provider;
    }

    public void setProviderIndividualName(String name) {
        this.provider.setIndividualName(name);
    }

    public void setProviderOrganisationName(String organisationName) {
        this.provider.setOrganisationName(organisationName);
    }

    public void setProviderSite(String site) {
        this.provider.setSite(site);
    }

    public Contact getDistributor() {
        return this.distributor;
    }

    public void setDistributorIndividualName(String name) {
        this.distributor.setIndividualName(name);
    }

    public void setDistributorOrganisationName(String organisationName) {
        this.distributor.setOrganisationName(organisationName);
    }

    public void setDistributorSite(String site) {
        this.distributor.setSite(site);
    }

    public String getUserLimitation() {
        return this.userLimitation;
    }

    public void setUserLimitation(String userLimitation) {
        this.userLimitation = userLimitation;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String toString() {
        return "MetaDataForm [user=" + this.user + ", title=" + this.title + ", date=" + this.date + ", abstractField=" + this.abstractField + ", purpose=" + this.purpose + ", presentationForm=" + this.presentationForm + ", credits=" + this.credits + ", keywords=" + this.keywords + ", topicCategory=" + this.topicCategory + ", extent=" + this.extent + ", geometricObjectType=" + this.geometricObjectType + ", topologyLevel=" + this.topologyLevel + ", geometrycount=" + this.geometrycount + ", resolution=" + this.resolution + ", graphicOverview=" + this.graphicOverview + ", projectName=" + this.projectName + ", provider=" + this.provider + ", distributor=" + this.distributor + ", fileIdentifier=" + this.fileIdentifier + ", userLimitation=" + this.userLimitation + ", language=" + (Object)((Object)this.language) + "]";
    }

    public static enum Language {
        ENGLISH,
        FRENCH,
        GERMAN,
        ITALIAN,
        JAPANESE,
        KOREAN,
        CHINESE,
        SIMPLIFIED_CHINESE,
        TRADITIONAL_CHINESE;

    }
}

