/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers;

import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers.GeonetworkAdministration;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPriv;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.ConfigurationManager;
import org.gcube.spatial.data.geonetwork.configuration.ScopeConfigurationUtils;
import org.gcube.spatial.data.geonetwork.configuration.XMLAdapter;
import org.gcube.spatial.data.geonetwork.extension.GNClientExtension;
import org.gcube.spatial.data.geonetwork.extension.ServerAccess;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.Group;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.geonetwork.model.User;
import org.gcube.spatial.data.geonetwork.model.faults.AuthorizationException;
import org.gcube.spatial.data.geonetwork.model.faults.GeoNetworkException;
import org.gcube.spatial.data.geonetwork.model.faults.InvalidInsertConfigurationException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingServiceEndpointException;
import org.gcube.spatial.data.geonetwork.utils.GroupUtils;
import org.gcube.spatial.data.geonetwork.utils.RuntimeParameters;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.opengis.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Geonetwork
implements GeonetworkAdministration {
    private static final Logger log = LoggerFactory.getLogger(Geonetwork.class);
    private static XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
    private Configuration config;
    private GNClientExtension theClient = null;
    private ServerAccess currentAccess = null;
    private List<XMLAdapter> registeredXMLAdapters = new ArrayList<XMLAdapter>();

    public static GeonetworkAdministration get() throws Exception {
        return new Geonetwork(ConfigurationManager.get());
    }

    public static GeonetworkAdministration get(Configuration config) throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        return new Geonetwork(config);
    }

    private Geonetwork(Configuration config) throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        this.config = config;
        try {
            ScopeConfiguration scopeConfiguration = config.getScopeConfiguration();
        }
        catch (MissingConfigurationException e) {
            this.acquireConfiguration();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void login(LoginLevel lvl) throws AuthorizationException, MissingServiceEndpointException, MissingConfigurationException {
        String user = null;
        String password = null;
        switch (lvl) {
            case ADMIN: {
                user = this.config.getAdminAccount().getUser();
                password = this.config.getAdminAccount().getPassword();
                break;
            }
            case CKAN: {
                ScopeConfiguration scopeConfiguration = this.config.getScopeConfiguration();
                Account account = (Account)scopeConfiguration.getAccounts().get(Account.Type.CKAN);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
            default: {
                ScopeConfiguration scopeConfiguration = this.config.getScopeConfiguration();
                Account account = (Account)scopeConfiguration.getAccounts().get(Account.Type.SCOPE);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
        }
        this.setAccess(new ServerAccess(this.config.getGeoNetworkEndpoint(), this.config.getGeoNetworkVersion(), true, password, user, lvl));
        this.getClient();
    }

    private ServerAccess getAccess(ScopeConfiguration scopeConfig, LoginLevel lvl) throws MissingServiceEndpointException {
        String user = null;
        String password = null;
        switch (lvl) {
            case ADMIN: {
                user = this.config.getAdminAccount().getUser();
                password = this.config.getAdminAccount().getPassword();
                break;
            }
            case CKAN: {
                ScopeConfiguration scopeConfiguration = scopeConfig;
                Account account = (Account)scopeConfiguration.getAccounts().get(Account.Type.CKAN);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
            default: {
                ScopeConfiguration scopeConfiguration = scopeConfig;
                Account account = (Account)scopeConfiguration.getAccounts().get(Account.Type.SCOPE);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
        }
        return new ServerAccess(this.config.getGeoNetworkEndpoint(), this.config.getGeoNetworkVersion(), true, password, user, lvl);
    }

    @Override
    public void logout() throws MissingServiceEndpointException {
        this.setAccess(new ServerAccess(this.config.getGeoNetworkEndpoint(), this.config.getGeoNetworkVersion()));
    }

    @Override
    public GNSearchResponse query(GNSearchRequest request) throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().search(request);
    }

    @Override
    public GNSearchResponse query(File fileRequest) throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().search(fileRequest);
    }

    @Override
    public MetaData getById(long id) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        return null;
    }

    @Override
    public MetaData getById(String UUID2) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        return null;
    }

    @Override
    public String getById2(long id) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        String xml = out.outputString(this.getClient().get(Long.valueOf(id)));
        return xml;
    }

    @Override
    public String getByIdAsRawString(String UUID2) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        return out.outputString(this.getClient().get(UUID2));
    }

    @Override
    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.setPrivileges(metadataId, cfg);
    }

    private void setPrivileges(long metadataId, ScopeConfiguration toUseConfig, LoginLevel toUseLevel) throws MissingConfigurationException, MissingServiceEndpointException, GNLibException, GNServerException {
        GNPrivConfiguration cfg = null;
        switch (toUseLevel) {
            case ADMIN: {
                break;
            }
            case CKAN: {
                break;
            }
            case DEFAULT: {
                cfg = new GNPrivConfiguration();
                cfg.addPrivileges(toUseConfig.getDefaultGroup(), EnumSet.of(GNPriv.VIEW, GNPriv.FEATURED));
                break;
            }
            case PRIVATE: {
                cfg = new GNPrivConfiguration();
                cfg.addPrivileges(toUseConfig.getPrivateGroup(), EnumSet.of(GNPriv.VIEW, GNPriv.FEATURED));
                break;
            }
            case SCOPE: {
                cfg = new GNPrivConfiguration();
                cfg.addPrivileges(toUseConfig.getPublicGroup(), EnumSet.of(GNPriv.VIEW, GNPriv.FEATURED));
            }
        }
        if (cfg != null) {
            this.setPrivileges(metadataId, cfg);
        }
    }

    @Override
    public long insertMetadata(GNInsertConfiguration configuration, File metadataFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        this.checkPublishingConfiguration(configuration, this.config.getScopeConfiguration());
        GNClientExtension client = this.getClient();
        long toReturn = client.insertMetadata(configuration, metadataFile);
        this.setPrivileges(toReturn, this.config.getScopeConfiguration(), this.getCurrentLoginLevel());
        return toReturn;
    }

    @Override
    public long insertMetadata(GNInsertConfiguration configuration, MetaData meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        return 0L;
    }

    @Override
    public long insertMetadata(File requestFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException {
        GNClientExtension client = this.getClient();
        long toReturn = client.insertRequest(requestFile);
        this.setPrivileges(toReturn, this.config.getScopeConfiguration(), this.getCurrentLoginLevel());
        return toReturn;
    }

    @Override
    public long insertMetadata(MetaData meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException {
        return this.insertMetadata(Geonetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public long insertAndPromoteMetadata(File requestFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException {
        LoginLevel currentLevel = this.getCurrentLoginLevel();
        ScopeConfiguration parentConfig = this.getParentConfiguration();
        ServerAccess parentAccess = this.getAccess(parentConfig, LoginLevel.DEFAULT);
        this.setAccess(parentAccess);
        GNClientExtension client = this.getClient();
        long toReturn = client.insertRequest(requestFile);
        this.setPrivileges(toReturn, parentConfig, LoginLevel.DEFAULT);
        try {
            this.login(currentLevel);
        }
        catch (AuthorizationException e) {
            throw new GNLibException("Unabel to restore level. This should not happen.", (Throwable)e);
        }
        return toReturn;
    }

    @Override
    public long insertAndPromoteMetadata(GNInsertConfiguration configuration, File metadataFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        LoginLevel currentLevel = this.getCurrentLoginLevel();
        ScopeConfiguration parentConfig = this.getParentConfiguration();
        ServerAccess parentAccess = this.getAccess(parentConfig, LoginLevel.DEFAULT);
        this.setAccess(parentAccess);
        GNInsertConfiguration toUseConfig = null;
        try {
            toUseConfig = this.getUserConfiguration(configuration.getCategory(), configuration.getStyleSheet(), parentConfig, LoginLevel.DEFAULT);
        }
        catch (GeoNetworkException e) {
            throw new GNLibException("Unabel to get publish configuration ", (Throwable)e);
        }
        this.checkPublishingConfiguration(toUseConfig, parentConfig);
        GNClientExtension client = this.getClient();
        long toReturn = client.insertMetadata(toUseConfig, metadataFile);
        this.setPrivileges(toReturn, parentConfig, LoginLevel.DEFAULT);
        try {
            this.login(currentLevel);
        }
        catch (AuthorizationException e) {
            throw new GNLibException("Unabel to restore level. This should not happen.", (Throwable)e);
        }
        return toReturn;
    }

    @Override
    public long insertAndPromoteMetadata(GNInsertConfiguration configuration, MetaData meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        return this.insertAndPromoteMetadata(configuration, Geonetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public long insertAndPromoteMetadata(MetaData meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException {
        return this.insertAndPromoteMetadata(Geonetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    private ScopeConfiguration getParentConfiguration() throws MissingConfigurationException, MissingServiceEndpointException {
        ArrayList parent = ScopeUtils.getParentScopes();
        return ScopeConfigurationUtils.getByScope((Set)this.config.getExistingConfigurations(), (String)((String)parent.get(parent.size() - 1)));
    }

    @Override
    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.updateMetadata(id, metadataFile);
    }

    @Override
    public void updateMetadata(long id, MetaData meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException {
        this.updateMetadata(id, Geonetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    public void createGroup(String name, String description, String mail) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
    }

    @Override
    public void deleteMetadata(long id) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.deleteMetadata(id);
    }

    @Override
    public GNInsertConfiguration getCurrentUserConfiguration(String category, String styleSheet) throws AuthorizationException, GeoNetworkException {
        if (this.getCurrentLoginLevel() == null) {
            throw new AuthorizationException("Client is not authenticated, please use Login before publishing");
        }
        return this.getUserConfiguration(category, styleSheet, this.config.getScopeConfiguration(), this.getCurrentLoginLevel());
    }

    public GNInsertConfiguration getUserConfiguration(String category, String styleSheet, ScopeConfiguration configuration, LoginLevel lvl) throws AuthorizationException, GeoNetworkException {
        Integer configuredGroup = null;
        switch (this.getCurrentLoginLevel()) {
            case CKAN: {
                throw new AuthorizationException("Current logged level " + this.getCurrentLoginLevel() + "is read-only");
            }
            case ADMIN: {
                throw new GeoNetworkException("Current logged level is Admin, unable to determine publihing configuration");
            }
            case DEFAULT: {
                configuredGroup = configuration.getDefaultGroup();
                break;
            }
            case PRIVATE: {
                configuredGroup = configuration.getPrivateGroup();
                break;
            }
            case SCOPE: {
                configuredGroup = configuration.getPublicGroup();
            }
        }
        return new GNInsertConfiguration(configuredGroup + "", category, styleSheet, Boolean.valueOf(true));
    }

    @Override
    public Group createGroup(String name, String description, String mail, Integer id) throws GNLibException, GNServerException, MissingServiceEndpointException {
        return null;
    }

    @Override
    public Set<Group> getGroups() throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().getGroups();
    }

    @Override
    public String getAvailableOwnershipTransfer(Integer userId) throws GNServerException, MissingServiceEndpointException, GNLibException {
        return this.getClient().getPossibleOwnershipTransfer(userId);
    }

    @Override
    public String getMetadataOwners() throws GNServerException, MissingServiceEndpointException, GNLibException {
        return this.getClient().getMetadataOwners();
    }

    private ScopeConfiguration acquireConfiguration() throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        ScopeConfiguration acquired = null;
        try {
            acquired = this.config.acquireConfiguration();
        }
        catch (MissingConfigurationException e) {
            acquired = this.createCurrentScopeConfiguration();
            this.config.createScopeConfiguration(acquired);
        }
        this.updateRightsOnAcquiredConfiguration(acquired);
        return acquired;
    }

    @Override
    public Set<User> getUsers() throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().getUsers();
    }

    @Override
    public User createUsers(String username, String password, User.Profile profile, Collection<Integer> groups) throws GNLibException, GNServerException, MissingServiceEndpointException {
        this.getClient().createUser(username, password, profile, groups);
        long submitTime = System.currentTimeMillis();
        long timeout = 500L;
        long wait = 100L;
        User created = null;
        do {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((created = UserUtils.getByName((Set)this.getClient().getUsers(), (String)username)) == null && System.currentTimeMillis() - submitTime <= timeout);
        if (created == null) {
            throw new GNServerException("Reached timeout while creating user " + username);
        }
        return created;
    }

    @Override
    public void assignOwnership(List<Long> toTransferIds, Integer targetUserId, Integer targetGroupId) throws AuthorizationException, GNServerException, MissingServiceEndpointException, GNLibException {
        if (this.getCurrentLoginLevel() == null || !this.getCurrentLoginLevel().equals((Object)LoginLevel.ADMIN)) {
            throw new AuthorizationException("You need to login as Admin to massively transfer ownership");
        }
        this.getClient().assignOwnership(toTransferIds, targetUserId, targetGroupId);
    }

    @Override
    public void transferOwnership(Integer sourceUserId, Integer sourceGroupId, Integer targetUserId, Integer targetGroupId) throws GNServerException, MissingServiceEndpointException, GNLibException {
        this.getClient().transferOwnership(sourceUserId, sourceGroupId, targetUserId, targetGroupId);
    }

    private ScopeConfiguration createCurrentScopeConfiguration() throws GNLibException, GNServerException, MissingServiceEndpointException {
        try {
            String currentScopeName = ScopeUtils.getCurrentScopeName();
            this.login(LoginLevel.ADMIN);
            RuntimeParameters props = new RuntimeParameters();
            Integer nameLength = Integer.parseInt(props.getProps().getProperty("GNUniqueNameLength"));
            Integer passwordLength = Integer.parseInt(props.getProps().getProperty("GNPasswordLength"));
            Group privateGroup = GroupUtils.generateRandomGroup(this.getGroups(), (Integer)nameLength);
            this.createGroup(privateGroup.getName(), "Private group for scope " + currentScopeName, "none", privateGroup.getId());
            Group publicGroup = GroupUtils.generateRandomGroup(this.getGroups(), (Integer)nameLength);
            this.createGroup(publicGroup.getName(), "Public group for scope " + currentScopeName, "none", publicGroup.getId());
            Set<Group> existingGroups = this.getGroups();
            privateGroup = GroupUtils.getByName(existingGroups, (String)privateGroup.getName());
            publicGroup = GroupUtils.getByName(existingGroups, (String)publicGroup.getName());
            User ckanUser = UserUtils.generateRandomUser(this.getUsers(), (Integer)nameLength, (Integer)passwordLength);
            HashSet<Integer> scopeAccessibleGroups = new HashSet<Integer>();
            scopeAccessibleGroups.add(publicGroup.getId());
            scopeAccessibleGroups.add(privateGroup.getId());
            this.createUsers(ckanUser.getUsername(), ckanUser.getPassword(), User.Profile.Reviewer, scopeAccessibleGroups);
            User scopeUser = UserUtils.generateRandomUser(this.getUsers(), (Integer)nameLength, (Integer)passwordLength);
            this.createUsers(scopeUser.getUsername(), scopeUser.getPassword(), User.Profile.Reviewer, scopeAccessibleGroups);
            this.logout();
            HashMap<Account.Type, Account> accounts = new HashMap<Account.Type, Account>();
            accounts.put(Account.Type.CKAN, new Account(ckanUser.getUsername(), ckanUser.getPassword(), Account.Type.CKAN));
            accounts.put(Account.Type.SCOPE, new Account(scopeUser.getUsername(), scopeUser.getPassword(), Account.Type.SCOPE));
            return new ScopeConfiguration(currentScopeName, publicGroup.getId(), privateGroup.getId(), accounts, publicGroup.getId());
        }
        catch (Exception e) {
            throw new GNLibException("Unable to create scope configuration", (Throwable)e);
        }
    }

    private void updateRightsOnAcquiredConfiguration(ScopeConfiguration scopeConfig) throws MissingServiceEndpointException, AuthorizationException, GNLibException, GNServerException, MissingConfigurationException {
        Set parentConfigurations = this.config.getParentScopesConfiguration();
        this.login(LoginLevel.ADMIN);
        GNClientExtension client = this.getClient();
        HashSet<Integer> parentVisibleGroups = new HashSet<Integer>();
        for (ScopeConfiguration conf : parentConfigurations) {
            parentVisibleGroups.add(conf.getPrivateGroup());
            parentVisibleGroups.add(conf.getPublicGroup());
        }
        Set<User> existingUsers = this.getUsers();
        User scopeUser = UserUtils.getByName(existingUsers, (String)((Account)scopeConfig.getAccounts().get(Account.Type.SCOPE)).getUser());
        client.editUser(scopeUser, parentVisibleGroups);
        for (ScopeConfiguration conf : parentConfigurations) {
            User toUpdateUser = UserUtils.getByName(existingUsers, (String)((Account)conf.getAccounts().get(Account.Type.SCOPE)).getUser());
            client.editUser(toUpdateUser, Collections.singleton(scopeConfig.getPublicGroup()));
        }
        this.logout();
    }

    @Override
    public void registerXMLAdapter(XMLAdapter adapter) {
        this.registeredXMLAdapters.add(adapter);
    }

    private void setAccess(ServerAccess access) {
        this.currentAccess = access;
        this.theClient = null;
    }

    private ServerAccess getCurrentAccess() throws MissingServiceEndpointException {
        if (this.currentAccess == null) {
            this.currentAccess = new ServerAccess(this.config.getGeoNetworkEndpoint(), this.config.getGeoNetworkVersion());
        }
        return this.currentAccess;
    }

    private LoginLevel getCurrentLoginLevel() throws MissingServiceEndpointException {
        return this.getCurrentAccess().getLoggedLevel();
    }

    private synchronized GNClientExtension getClient() throws MissingServiceEndpointException {
        if (this.theClient == null) {
            this.theClient = new GNClientExtension(this.getCurrentAccess());
        }
        return this.theClient;
    }

    private void checkPublishingConfiguration(GNInsertConfiguration configuration, ScopeConfiguration toUseConfig) throws AuthorizationException, InvalidInsertConfigurationException, MissingConfigurationException, MissingServiceEndpointException {
        if (this.getCurrentLoginLevel() == null) {
            throw new AuthorizationException("Client is not authenticated, please use Login before publishing");
        }
        if (!configuration.getValidate().booleanValue()) {
            throw new InvalidInsertConfigurationException("Validate option is mandatory");
        }
        Integer targetGroup = Integer.parseInt(configuration.getGroup());
        Integer configuredGroup = null;
        switch (this.getCurrentLoginLevel()) {
            case CKAN: {
                throw new AuthorizationException("Current logged level " + this.getCurrentLoginLevel() + "is read-only");
            }
            case ADMIN: {
                break;
            }
            case DEFAULT: {
                configuredGroup = toUseConfig.getDefaultGroup();
                break;
            }
            case PRIVATE: {
                configuredGroup = toUseConfig.getPrivateGroup();
                break;
            }
            case SCOPE: {
                configuredGroup = toUseConfig.getPublicGroup();
            }
        }
        if (configuredGroup != null && !targetGroup.equals(configuredGroup)) {
            throw new InvalidInsertConfigurationException(String.format("Invalid logged level %s and specified group %d, expected %d", this.getCurrentLoginLevel(), targetGroup, configuredGroup));
        }
    }

    private static File meta2File(MetaData meta, List<XMLAdapter> adapters) throws IOException, JAXBException {
        File temp = File.createTempFile("meta", ".xml");
        return temp;
    }
}

