/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.elements;

import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerBounds;
import java.io.Serializable;

public class Bounds
implements Serializable {
    private static final long serialVersionUID = -7772829081416226435L;
    private double minx = 0.0;
    private double maxx = 0.0;
    private double miny = 0.0;
    private double maxy = 0.0;
    private String crs = "";

    public Bounds() {
    }

    public Bounds(LayerBounds bounds) {
        this.minx = bounds.getMinX();
        this.miny = bounds.getMinY();
        this.maxx = bounds.getMaxX();
        this.maxy = bounds.getMaxY();
        this.crs = "EPSG:4326";
    }

    public Bounds(double minx, double miny, double maxx, double maxy, String crs) {
        this.minx = minx;
        this.miny = miny;
        this.maxx = maxx;
        this.maxy = maxy;
        this.crs = crs;
    }

    public double getMinx() {
        return this.minx;
    }

    public void setMinx(double minx) {
        this.minx = minx;
    }

    public double getMaxx() {
        return this.maxx;
    }

    public void setMaxx(double maxx) {
        this.maxx = maxx;
    }

    public double getMiny() {
        return this.miny;
    }

    public void setMiny(double miny) {
        this.miny = miny;
    }

    public double getMaxy() {
        return this.maxy;
    }

    public void setMaxy(double maxy) {
        this.maxy = maxy;
    }

    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public LayerBounds createLayerBounds() {
        LayerBounds layerBounds = new LayerBounds();
        layerBounds.setMinX(this.minx);
        layerBounds.setMinY(this.miny);
        layerBounds.setMaxX(this.maxx);
        layerBounds.setMaxY(this.maxy);
        return layerBounds;
    }

    public String toString() {
        return "Bounds [minx=" + this.minx + ", maxx=" + this.maxx + ", miny=" + this.miny + ", maxy=" + this.maxy + ", crs=" + this.crs + "]";
    }

    public double[] boundsAsArray() {
        return new double[]{this.minx, this.miny, this.maxy, this.maxy};
    }
}

