/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildWmsUrl {
    public static final String VECTOR = "VECTOR";
    public static final String RASTER = "RASTER";
    public static final String UNKNOWN = "UNKNOWN";
    private static Logger log = LoggerFactory.getLogger(BuildWmsUrl.class);
    private String baseUrl;
    private String workspace;
    private String layerName;
    private String height;
    private String width;
    private String bBox;
    private String srs;
    private Map<String, String> layerTypeToGetLayerInfoUrl = null;
    private Map<String, String> layerTypeDescribeLayerUrl = null;
    private Map<String, String> layerTypeGetCapabilitiesUrl = null;

    public BuildWmsUrl(String baseUrl, String workspace, String layerName, String height, String width, String bBox, String srs) {
        log.debug("Initialize BuildWmsUrl...");
        this.baseUrl = baseUrl;
        this.workspace = workspace;
        this.layerName = layerName;
        this.height = height;
        this.width = width;
        this.bBox = bBox;
        this.srs = srs;
        this.layerTypeToGetLayerInfoUrl = new HashMap<String, String>();
        this.layerTypeToGetLayerInfoUrl.put(VECTOR, this.getFinalWfsGetFeatureUrl());
        this.layerTypeToGetLayerInfoUrl.put(RASTER, this.getFinalWcsGetCoverageUrl());
        this.layerTypeToGetLayerInfoUrl.put(UNKNOWN, "");
        this.layerTypeDescribeLayerUrl = new HashMap<String, String>();
        this.layerTypeDescribeLayerUrl.put(VECTOR, this.getFinalWfsDescribeDescribeFeatureTypeURL());
        this.layerTypeDescribeLayerUrl.put(RASTER, this.getFinalWcsDescribeCoverageURL());
        this.layerTypeDescribeLayerUrl.put(UNKNOWN, "");
        this.layerTypeGetCapabilitiesUrl = new HashMap<String, String>();
        this.layerTypeGetCapabilitiesUrl.put(VECTOR, this.getWfsGetCapabilitiesUrl());
        this.layerTypeGetCapabilitiesUrl.put(RASTER, this.getWCsGetCapabilitiesUrl());
        this.layerTypeGetCapabilitiesUrl.put(UNKNOWN, "");
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        log.trace("Setting base url: " + baseUrl);
        this.baseUrl = baseUrl;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        log.trace("Setting workspace: " + workspace);
        this.workspace = workspace;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        log.trace("Setting layer name: " + layerName);
        this.layerName = layerName;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        log.trace("Setting height: " + height);
        this.height = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        log.trace("Setting width: " + width);
        this.width = width;
    }

    public String getbBox() {
        return this.bBox;
    }

    public void setbBox(String bBox) {
        log.trace("Setting bounding box: " + bBox);
        this.bBox = bBox;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        log.trace("Setting bounding box: " + this.bBox);
        this.srs = srs;
    }

    public String getWmsGetMapUrl() {
        return this.baseUrl + "/" + this.workspace + "/wms?SERVICE=WMS&LAYERS=" + this.layerName + "&FORMAT=image%2Fpng&HEIGHT=" + this.height + "&TRANSPARENT=TRUE&REQUEST=GetMap&BBOX=" + this.bBox + "&WIDTH=" + this.width + "&STYLES=&SRS=" + this.srs + "&VERSION=1.0.0&layername=" + this.layerName;
    }

    public String getWmsGetFeatureInfoUrl() {
        return this.baseUrl + "/" + this.workspace + "/wms?SERVICE=WMS&LAYERS=" + this.workspace + ":" + this.layerName + "&query_layers=" + this.workspace + ":" + this.layerName + "&X=1&Y=10&FORMAT=image%2Fpng&HEIGHT=" + this.height + "&TRANSPARENT=TRUE&REQUEST=GetFeatureInfo&BBOX=" + this.bBox + "&WIDTH=" + this.width + "&STYLES=&SRS=" + this.srs + "&VERSION=1.0.0&info_format=text%2Fhtml&layername=" + this.layerName;
    }

    public String getWmsGetCapabilitiesUrl() {
        return this.baseUrl + "/" + this.workspace + "/wms?SERVICE=WMS&REQUEST=GetMap&VERSION=1.0.0&layername=" + this.workspace + ":" + this.layerName;
    }

    private String getFinalWcsGetCoverageUrl() {
        return this.baseUrl + "/" + this.workspace + "/wcs?SERVICE=WCS&REQUEST=GetCoverage&crs=epsg:4326&VERSION=1.0.0&FORMAT=GEOTIFF&HEIGHT=" + this.height + "&WIDTH=" + this.width + "&coverage=" + this.layerName + "&layername=" + this.layerName + "&BBOX=" + this.bBox;
    }

    private String getFinalWcsDescribeCoverageURL() {
        return this.baseUrl + "/" + this.workspace + "/wcs?SERVICE=WCS&VERSION=1.0.0&REQUEST=DescribeCoverage&coverageid=" + this.layerName + "&layername=" + this.layerName;
    }

    private String getWCsGetCapabilitiesUrl() {
        return this.baseUrl + "/" + this.workspace + "/wCs?SERVICE=WCS&REQUEST=GetCapabilities&VERSION=1.0.0&layername=" + this.layerName;
    }

    private String getFinalWfsDescribeDescribeFeatureTypeURL() {
        return this.baseUrl + "/" + this.workspace + "/wfs?SERVICE=WFS&VERSION=1.0.0&REQUEST=DescribeFeatureType&TypeNames=" + this.layerName + "&layername=" + this.layerName;
    }

    private String getWfsGetCapabilitiesUrl() {
        return this.baseUrl + "/" + this.workspace + "/wfs?SERVICE=WFS&REQUEST=GetCapabilities&VERSION=1.0.0&layername=" + this.layerName;
    }

    private String getFinalWfsGetFeatureUrl() {
        return this.baseUrl + "/" + this.workspace + "/wfs?SERVICE=WFS&REQUEST=GetFeature&VERSION=1.0.0&layername=" + this.layerName + "&typeName=" + this.layerName + "&HEIGHT=" + this.height + "&WIDTH=" + this.width + "&OUTPUTFORMAT=application/json&BBOX=" + this.bBox;
    }

    public String getDataAtPointUrlByLayerType(String layerType) {
        layerType = layerType == null || !this.layerTypeToGetLayerInfoUrl.containsKey(layerType) ? UNKNOWN : layerType;
        return this.layerTypeToGetLayerInfoUrl.get(layerType);
    }

    public String getDescribeLayerURL(String layerType) {
        layerType = layerType == null || !this.layerTypeDescribeLayerUrl.containsKey(layerType) ? UNKNOWN : layerType;
        return this.layerTypeDescribeLayerUrl.get(layerType);
    }

    public String getCapabilitiesURL(String layerType) {
        layerType = layerType == null || !this.layerTypeGetCapabilitiesUrl.containsKey(layerType) ? UNKNOWN : layerType;
        return this.layerTypeGetCapabilitiesUrl.get(layerType);
    }

    public static void main(String[] args) {
        String baseUrl = "http://localhost:8082/geoanalytics";
        String workspace = "geoanalytics";
        String layerName = "1b113a15-e01c-43b7-8148-11188715d9e6";
        String height = "400";
        String width = "600";
        String bBox = "22.0880126953125%2C36.32080078125%2C23.1976318359375%2C37.430419921875";
        String srs = "EPSG%3A4326";
        BuildWmsUrl wmsUrl = new BuildWmsUrl(baseUrl, workspace, layerName, height, width, bBox, srs);
        log.info("WMS getMap: " + wmsUrl.getWmsGetMapUrl());
        log.info("WMS getWmsGetFeatureInfoUrl: " + wmsUrl.getWmsGetFeatureInfoUrl());
        log.info("WMS getWmsGetCapabilitiesUrl: " + wmsUrl.getWmsGetCapabilitiesUrl());
        log.info("WFS getCapabilitiesURL: " + wmsUrl.getCapabilitiesURL(VECTOR));
        log.info("WFS getDataAtPointUrlByLayerType: " + wmsUrl.getDataAtPointUrlByLayerType(VECTOR));
        log.info("WFS getDescribeLayerURL: " + wmsUrl.getDescribeLayerURL(VECTOR));
        log.info("WFS getCapabilitiesURL: " + wmsUrl.getCapabilitiesURL(RASTER));
        log.info("WFS getDataAtPointUrlByLayerType: " + wmsUrl.getDataAtPointUrlByLayerType(RASTER));
        log.info("WFS getDescribeLayerURL: " + wmsUrl.getDescribeLayerURL(RASTER));
    }
}

