/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.geoservermanager;

import gr.cite.geoanalytics.context.GeoServerBridgeConfig;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.GeoServerBridge;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.DataStore;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Layer;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.exception.GeoServerBridgeException;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.util.ScaledStyleCreator;
import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.decoder.RESTDataStore;
import it.geosolutions.geoserver.rest.decoder.RESTDataStoreList;
import it.geosolutions.geoserver.rest.decoder.RESTFeatureType;
import it.geosolutions.geoserver.rest.decoder.RESTLayer;
import it.geosolutions.geoserver.rest.decoder.RESTStyle;
import it.geosolutions.geoserver.rest.encoder.GSAbstractStoreEncoder;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import it.geosolutions.geoserver.rest.encoder.datastore.GSPostGISDatastoreEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import it.geosolutions.geoserver.rest.encoder.metadata.GSFeatureDimensionInfoEncoder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStoreManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GSManagerGeoServerBridge
implements GeoServerBridge {
    private static Logger logger = LoggerFactory.getLogger(GSManagerGeoServerBridge.class);
    private GeoServerRESTReader reader = null;
    private GeoServerRESTPublisher publisher = null;
    private GeoServerBridgeConfig configuration = null;
    private GeoServerRESTStoreManager storeManager = null;

    @Inject
    public void setConfiguration(GeoServerBridgeConfig configuration) {
        this.configuration = configuration;
    }

    @PostConstruct
    private void initialize() throws MalformedURLException {
        this.reader = new GeoServerRESTReader(this.configuration.getGeoServerBridgeUrl(), this.configuration.getGeoServerBridgeUser(), this.configuration.getGeoServerBridgePassword());
        this.publisher = new GeoServerRESTPublisher(this.configuration.getGeoServerBridgeUrl(), this.configuration.getGeoServerBridgeUser(), this.configuration.getGeoServerBridgePassword());
        this.storeManager = new GeoServerRESTStoreManager(new URL(this.configuration.getGeoServerBridgeUrl()), this.configuration.getGeoServerBridgeUser(), this.configuration.getGeoServerBridgePassword());
    }

    public List<String> listDataStores() throws GeoServerBridgeException {
        try {
            RESTDataStoreList datastores = this.reader.getDatastores(this.configuration.getGeoServerBridgeWorkspace());
            if (datastores == null) {
                return null;
            }
            return datastores.getNames();
        }
        catch (Exception e) {
            logger.error("Erorr while listing data stores", (Throwable)e);
            throw new GeoServerBridgeException("Error while listing data stores", (Throwable)e);
        }
    }

    public DataStore getDataStore(String name) throws GeoServerBridgeException {
        RESTDataStore dsr = null;
        try {
            dsr = this.reader.getDatastore(this.configuration.getGeoServerBridgeWorkspace(), name);
        }
        catch (Exception e) {
            logger.error("Error while retrieving data store info", (Throwable)e);
            throw new GeoServerBridgeException("Error while retrieving data store info", (Throwable)e);
        }
        if (dsr == null) {
            return null;
        }
        DataStore ds = new DataStore();
        ds.setDataStoreName(dsr.getName());
        ds.setWorkspace(ds.getWorkspace());
        ds.setDbType(dsr.getType().toString());
        return ds;
    }

    public Boolean dataStoreExists(String workspaceName, String dataStoreName) throws GeoServerBridgeException {
        Boolean exists = false;
        try {
            exists = this.reader.getDatastore(workspaceName, dataStoreName) != null;
        }
        catch (Exception e) {
            logger.debug("Error while retrieveing data store", (Throwable)e);
            throw new GeoServerBridgeException("Error while retrieveing data store", (Throwable)e);
        }
        return exists;
    }

    public List<String> listLayers() throws GeoServerBridgeException {
        List<Layer> all = this.getLayers();
        ArrayList<String> ls = new ArrayList<String>();
        for (Layer l : all) {
            ls.add(l.getName());
        }
        return ls;
    }

    private List<String> listLayersOfDataStores(List<String> datastores) throws GeoServerBridgeException {
        List<Layer> all = this.getLayers();
        ArrayList<String> res = new ArrayList<String>();
        block0: for (Layer l : all) {
            for (String ds : datastores) {
                if (!l.getDatastore().equals(ds)) continue;
                res.add(l.getName());
                continue block0;
            }
        }
        return res;
    }

    public List<String> listLayersOfDataStore(String datastore) throws GeoServerBridgeException {
        ArrayList<String> ds = new ArrayList<String>();
        ds.add(datastore);
        return this.listLayersOfDataStores(ds);
    }

    public Layer getLayer(String name) throws GeoServerBridgeException {
        Layer l = null;
        try {
            RESTLayer layer = this.reader.getLayer(this.configuration.getGeoServerBridgeWorkspace(), name);
            if (layer == null) {
                return null;
            }
            RESTFeatureType ft = this.reader.getFeatureType(layer);
            if (ft == null) {
                return null;
            }
            l = new Layer();
            l.setDatastore(ft.getStoreName());
            l.setEnabled(true);
            l.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
            l.setName(layer.getName());
            l.setDefaultStyle(layer.getDefaultStyle());
            l.setFeatureTypeLink(layer.getResourceUrl());
            l.setType(layer.getType().toString());
            l.setTitle(layer.getTitle());
        }
        catch (Exception e) {
            logger.error("Error while retrieving layer", (Throwable)e);
            throw new GeoServerBridgeException("Error while retrieving layer", (Throwable)e);
        }
        return l;
    }

    public List<Layer> getLayers() throws GeoServerBridgeException {
        return this.getLayersOfDataStores(this.listDataStores());
    }

    private List<Layer> getLayersOfDataStores(List<String> datastores) throws GeoServerBridgeException {
        datastores = datastores.stream().map(x -> this.configuration.getGeoServerBridgeWorkspace() + ":" + x).collect(Collectors.toList());
        ArrayList<Layer> ls = new ArrayList<Layer>();
        try {
            List all = this.reader.getLayers().getNames();
            for (String lname : all) {
                RESTLayer layer = this.reader.getLayer(this.configuration.getGeoServerBridgeWorkspace(), lname);
                RESTFeatureType ft = null;
                if (layer != null) {
                    ft = this.reader.getFeatureType(layer);
                }
                if (layer == null || ft == null) {
                    logger.warn("Skipping layer with no returned data: " + lname);
                    continue;
                }
                if (!datastores.contains(ft.getStoreName())) continue;
                Layer l = new Layer();
                l.setDatastore(ft.getStoreName());
                l.setEnabled(true);
                l.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
                l.setName(layer.getName());
                l.setDefaultStyle(layer.getDefaultStyle());
                l.setFeatureTypeLink(layer.getResourceUrl());
                l.setType(layer.getType().toString());
                l.setTitle(layer.getTitle());
                ls.add(l);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving layer info", (Throwable)e);
            throw new GeoServerBridgeException("Error while retrieving layer info", (Throwable)e);
        }
        return ls;
    }

    public List<Layer> getLayersOfDataStore(String datastore) throws GeoServerBridgeException {
        ArrayList<String> datastores = new ArrayList<String>();
        datastores.add(datastore);
        return this.getLayersOfDataStores(datastores);
    }

    public void addWorkspace(String name, String uri) throws GeoServerBridgeException {
        if (!name.isEmpty() && !uri.isEmpty()) {
            try {
                URI u = URI.create(uri);
                this.publisher.createWorkspace(name, u);
                logger.debug("Worksapce created succesfully");
            }
            catch (Exception e) {
                logger.debug("Error while creating workspace");
                throw new GeoServerBridgeException("Error while creating workspace", (Throwable)e);
            }
        } else {
            logger.debug("Empty String for workspace name or empty uri");
        }
    }

    public void addWorkspace(String name, URI uri) throws GeoServerBridgeException {
        if (!name.isEmpty() && uri != null) {
            try {
                this.publisher.createWorkspace(name, uri);
                logger.debug("Worksapce created succesfully");
            }
            catch (Exception e) {
                logger.debug("Error while creating workspace");
                throw new GeoServerBridgeException("Error while creating workspace", (Throwable)e);
            }
        } else {
            logger.debug("Empty String for workspace name or null URI");
        }
    }

    public void addWorkspace(String name) throws GeoServerBridgeException {
        if (!name.isEmpty()) {
            try {
                this.publisher.createWorkspace(name);
                logger.debug("Worksapce created succesfully");
            }
            catch (Exception e) {
                logger.debug("Error while creating workspace");
                throw new GeoServerBridgeException("Error while creating workspace", (Throwable)e);
            }
        } else {
            logger.debug("Empty String for workspace name");
        }
    }

    public void addDataStore(DataStore dataStore) throws GeoServerBridgeException {
        try {
            GSPostGISDatastoreEncoder dataStoreEncoder = new GSPostGISDatastoreEncoder(dataStore.getDataStoreName());
            dataStoreEncoder.setDescription(dataStore.getDescription());
            dataStoreEncoder.setEnabled(dataStore.isEnabled());
            dataStoreEncoder.setUser(dataStore.getUser());
            dataStoreEncoder.setPassword(dataStore.getPassword());
            dataStoreEncoder.setDatabase(dataStore.getDatabase());
            dataStoreEncoder.setPort(dataStore.getPort());
            dataStoreEncoder.setHost(dataStore.getHost());
            this.storeManager.create(dataStore.getWorkspace(), (GSAbstractStoreEncoder)dataStoreEncoder);
            logger.debug("Data store, created successfully");
        }
        catch (Exception e) {
            logger.debug("Error while creating datastore", (Throwable)e);
            throw new GeoServerBridgeException("Error while creating data store", (Throwable)e);
        }
    }

    public Boolean workspaceExists(String workSpaceName) throws GeoServerBridgeException {
        List workSpacesNames = new ArrayList();
        Boolean exists = false;
        try {
            workSpacesNames = this.reader.getWorkspaceNames();
            logger.debug("WorkSpace name retrieved successfully");
        }
        catch (Exception e) {
            logger.debug("Error while retrieving workspace names", (Throwable)e);
            throw new GeoServerBridgeException("Error while retrieving workspace names", (Throwable)e);
        }
        if (workSpacesNames.contains(workSpaceName)) {
            exists = true;
        }
        return exists;
    }

    public void addLayer(Layer layer, FeatureType ft, Map<String, String> slds, Integer minScale, Integer maxScale) throws GeoServerBridgeException {
        if (minScale != null && minScale < 0 || maxScale != null && maxScale < 0) {
            throw new GeoServerBridgeException("Illegal minScale/maxScale");
        }
        if (minScale != null && minScale != 0 && maxScale != null && maxScale != 0 && minScale > maxScale) {
            throw new GeoServerBridgeException("minScale should be less than maxScale");
        }
        GSFeatureTypeEncoder fte = new GSFeatureTypeEncoder();
        fte.setEnabled(true);
        if (ft.getName() != null) {
            fte.setName(ft.getName());
        } else {
            ft.setName(layer.getName());
        }
        if (ft.getSrs() != null) {
            fte.setSRS(ft.getSrs());
        }
        if (ft.getTitle() != null) {
            fte.setTitle(ft.getTitle());
        }
        GSResourceEncoder.ProjectionPolicy pp = null;
        switch (ft.getProjectionPolicy()) {
            case FORCE_DECLARED: {
                pp = GSResourceEncoder.ProjectionPolicy.FORCE_DECLARED;
                break;
            }
            case REPROJECT_TO_DECLARED: {
                pp = GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED;
                break;
            }
            case NONE: {
                pp = GSResourceEncoder.ProjectionPolicy.NONE;
            }
        }
        fte.setProjectionPolicy(pp);
        Bounds bb = ft.getLatLonBoundingBox();
        if (bb != null) {
            fte.setLatLonBoundingBox(bb.getMinx(), bb.getMiny(), bb.getMaxx(), bb.getMaxy(), bb.getCrs());
        }
        if ((bb = ft.getNativeBoundingBox()) != null) {
            fte.setLatLonBoundingBox(bb.getMinx(), bb.getMiny(), bb.getMaxx(), bb.getMaxy(), bb.getCrs());
        }
        if (ft.getMetadata() != null) {
            for (Map.Entry m : ft.getMetadata().entrySet()) {
                GSFeatureDimensionInfoEncoder fdie = new GSFeatureDimensionInfoEncoder((String)m.getKey());
                fdie.setEnabled(true);
            }
        }
        GSLayerEncoder le = new GSLayerEncoder();
        ArrayList<String> styles = new ArrayList<String>();
        ArrayList<String> scaledStyles = new ArrayList<String>();
        if (layer.getStyles() != null) {
            styles.addAll(layer.getStyles());
        }
        if (layer.getDefaultStyle() != null) {
            styles.add(layer.getDefaultStyle());
        } else {
            layer.setDefaultStyle("default");
            styles.add("default");
        }
        for (String style : styles) {
            if (minScale != null || maxScale != null) {
                String scaledName = ScaledStyleCreator.getScaledName((String)style, (Integer)minScale, (Integer)maxScale);
                if (this.getStyle(scaledName) == null) {
                    this.addStyle(scaledName, ScaledStyleCreator.createScaled((String)slds.get(style), (Integer)minScale, (Integer)maxScale));
                }
                if (style.equals(layer.getDefaultStyle())) continue;
                scaledStyles.add(scaledName);
                continue;
            }
            scaledStyles.add(style);
        }
        if (layer.getDefaultStyle() != null) {
            if (minScale != null || maxScale != null) {
                le.setDefaultStyle(ScaledStyleCreator.getScaledName((String)layer.getDefaultStyle(), (Integer)minScale, (Integer)maxScale));
            } else {
                le.setDefaultStyle(layer.getDefaultStyle());
            }
        } else if (minScale != null || maxScale != null) {
            le.setDefaultStyle(ScaledStyleCreator.getScaledName((String)"default", (Integer)minScale, (Integer)maxScale));
        } else {
            le.setDefaultStyle("default");
        }
        for (String st : scaledStyles) {
            le.addStyle(st);
        }
        le.setEnabled(true);
        boolean status = false;
        try {
            status = this.publisher.publishDBLayer(this.configuration.getGeoServerBridgeWorkspace(), this.configuration.getDataStoreConfig().getDataStoreName(), fte, le);
        }
        catch (Exception e) {
            logger.error("Error while adding layer", (Throwable)e);
            throw new GeoServerBridgeException("Error while adding layer", (Throwable)e);
        }
        if (!status) {
            throw new GeoServerBridgeException("An error originating from the underlying bridge provider occurred while adding a new layer");
        }
    }

    public void addLayer(Layer layer, FeatureType ft, Map<String, String> slds) throws GeoServerBridgeException {
        this.addLayer(layer, ft, slds, null, null);
    }

    public void deleteLayer(String name) throws GeoServerBridgeException {
        boolean removed;
        try {
            removed = this.publisher.unpublishFeatureType(this.configuration.getGeoServerBridgeWorkspace(), this.configuration.getDataStoreConfig().getDataStoreName(), URLEncoder.encode(name, "UTF-8"));
            if (removed) {
                this.publisher.removeLayer(this.configuration.getGeoServerBridgeWorkspace(), URLEncoder.encode(name, "UTF-8"));
            }
        }
        catch (Exception e) {
            logger.error("Error while removing layer", (Throwable)e);
            throw new GeoServerBridgeException("Error while removing layer", (Throwable)e);
        }
        if (!removed) {
            logger.error("An error originating from the underlying bridge provider occurred while deleting layer " + name);
            throw new GeoServerBridgeException("An error originating from the underlying bridge provider occurred while deleting layer " + name);
        }
    }

    public FeatureType getFeatureType(String name) throws GeoServerBridgeException {
        try {
            RESTLayer layer = this.reader.getLayer(this.configuration.getGeoServerBridgeWorkspace(), name);
            if (layer == null) {
                return null;
            }
            RESTFeatureType ftr = this.reader.getFeatureType(layer);
            if (ftr == null) {
                throw new GeoServerBridgeException("A layer for feature type " + name + " was found, but the corresponding feature type could not be retrieved");
            }
            FeatureType featureType = new FeatureType();
            featureType.setDatastore(ftr.getStoreName());
            featureType.setEnabled(true);
            featureType.setName(ftr.getName());
            featureType.setNativeCRS(ftr.getCRS());
            featureType.setNativeName(ftr.getNativeName());
            featureType.setTitle(ftr.getTitle());
            featureType.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
            Bounds b = new Bounds();
            b.setMaxx(ftr.getMaxX());
            b.setMaxy(ftr.getMaxY());
            b.setMinx(ftr.getMinX());
            b.setMiny(ftr.getMinY());
            featureType.setLatLonBoundingBox(b);
            return featureType;
        }
        catch (Exception e) {
            logger.error("Error while retrieving feature type", (Throwable)e);
            throw new GeoServerBridgeException("Error while retrieving feature type", (Throwable)e);
        }
    }

    public String getStyle(String name) throws GeoServerBridgeException {
        return this.reader.getSLD(name);
    }

    public void addStyle(String name, String sld) throws GeoServerBridgeException {
        RESTStyle s = this.reader.getStyle(name);
        if (s != null) {
            throw new GeoServerBridgeException("Style " + name + " already exists");
        }
        boolean published = this.publisher.publishStyle(sld, name);
        if (!published) {
            throw new GeoServerBridgeException("An error has occurred during publication of style " + name);
        }
    }

    public void addStyle(String name, String sld, Integer minScale, Integer maxScale) throws GeoServerBridgeException {
        String s = this.reader.getSLD(ScaledStyleCreator.getScaledName((String)name, (Integer)minScale, (Integer)maxScale));
        if (s != null) {
            throw new GeoServerBridgeException("Style " + name + " already exists");
        }
        boolean published = this.publisher.publishStyle(ScaledStyleCreator.createScaled((String)sld, (Integer)minScale, (Integer)maxScale), ScaledStyleCreator.getScaledName((String)name, (Integer)minScale, (Integer)maxScale));
        if (!published) {
            throw new GeoServerBridgeException("An error has occurred during publication of style " + name);
        }
    }

    public void removeStyle(String name, Integer minScale, Integer maxScale) throws GeoServerBridgeException {
        String sn = minScale == null && maxScale == null ? name : ScaledStyleCreator.getScaledName((String)name, (Integer)minScale, (Integer)maxScale);
        String s = this.reader.getSLD(sn);
        if (s == null) {
            return;
        }
        boolean removed = this.publisher.removeStyle(sn);
        if (!removed) {
            throw new GeoServerBridgeException("An error has occured during removal of style " + sn);
        }
    }

    public void removeStyle(String name) throws GeoServerBridgeException {
        this.removeStyle(name, null, null);
    }

    public void setDefaultLayerStyle(String layerName, String styleName, String sld, Integer minScale, Integer maxScale) throws GeoServerBridgeException {
        String scaledName = styleName;
        if (minScale != null || maxScale != null) {
            scaledName = ScaledStyleCreator.getScaledName((String)styleName, (Integer)minScale, (Integer)maxScale);
        }
        if (this.getStyle(scaledName) == null) {
            this.addStyle(scaledName, ScaledStyleCreator.createScaled((String)sld, (Integer)minScale, (Integer)maxScale));
        }
        GSLayerEncoder le = new GSLayerEncoder();
        le.setDefaultStyle(scaledName);
        boolean res = this.publisher.configureLayer(this.configuration.getGeoServerBridgeWorkspace(), layerName, le);
        if (!res) {
            logger.error("An error has occurred while configuring layer " + layerName + " with style " + scaledName);
            throw new GeoServerBridgeException("An error has occurred while configuring layer " + layerName + " with style " + scaledName);
        }
    }

    public void setDefaultLayerStyle(String layerName, String styleName, String sld) throws GeoServerBridgeException {
        this.setDefaultLayerStyle(layerName, styleName, sld, null, null);
    }

    public void addLayerStyle(String layerName, String styleName, String sld, Integer minScale, Integer maxScale) throws GeoServerBridgeException {
        String scaledName = styleName;
        if (minScale != null || maxScale != null) {
            scaledName = ScaledStyleCreator.getScaledName((String)styleName, (Integer)minScale, (Integer)maxScale);
        }
        if (this.getStyle(scaledName) == null) {
            this.addStyle(scaledName, ScaledStyleCreator.createScaled((String)sld, (Integer)minScale, (Integer)maxScale));
        }
        GSLayerEncoder le = new GSLayerEncoder();
        le.addStyle(scaledName);
        boolean res = this.publisher.configureLayer(this.configuration.getGeoServerBridgeWorkspace(), layerName, le);
        if (!res) {
            logger.error("An error has occurred while adding style " + styleName + " to layer " + layerName);
            throw new GeoServerBridgeException("An error has occurred while adding style " + styleName + " to layer " + layerName);
        }
    }

    public void addLayerStyle(String layerName, String styleName, String sld) throws GeoServerBridgeException {
        this.addLayerStyle(layerName, styleName, sld, null, null);
    }

    public void removeLayerStyle(String layerName, String styleName, Integer minScale, Integer maxScale) throws GeoServerBridgeException {
        String scaledName = styleName;
        if (minScale != null || maxScale != null) {
            scaledName = ScaledStyleCreator.getScaledName((String)styleName, (Integer)minScale, (Integer)maxScale);
        }
        GSLayerEncoder le = new GSLayerEncoder();
        le.delStyle(scaledName);
        boolean res = this.publisher.configureLayer(this.configuration.getGeoServerBridgeWorkspace(), layerName, le);
        if (!res) {
            logger.error("An error has occurred while removing style " + styleName + " from layer " + layerName);
            throw new GeoServerBridgeException("An error has occurred while removing style " + styleName + " from layer " + layerName);
        }
    }

    public void removeLayerStyle(String layerName, String styleName) throws GeoServerBridgeException {
        this.removeLayerStyle(layerName, styleName, null, null);
    }
}

