/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.geoservermanager.CustomPublishers;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.decoder.RESTCoverage;
import it.geosolutions.geoserver.rest.decoder.RESTCoverageStore;
import it.geosolutions.geoserver.rest.decoder.RESTStyleList;
import it.geosolutions.geoserver.rest.decoder.utils.NameLinkElem;
import it.geosolutions.geoserver.rest.encoder.GSBackupEncoder;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.GSLayerGroupEncoder;
import it.geosolutions.geoserver.rest.encoder.GSNamespaceEncoder;
import it.geosolutions.geoserver.rest.encoder.GSPostGISDatastoreEncoder;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import it.geosolutions.geoserver.rest.encoder.GSWorkspaceEncoder;
import it.geosolutions.geoserver.rest.encoder.coverage.GSCoverageEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStructuredGridCoverageReaderManager;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStyleManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.zip.ZipFile;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetCDFPublisher {
    public static final String DEFAULT_CRS = "EPSG:4326";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoServerRESTPublisher.class);
    private final String restURL;
    private final String gsuser;
    private final String gspass;
    private final GeoServerRESTStyleManager styleManager;

    public NetCDFPublisher(String restURL, String username, String password) {
        this.restURL = HTTPUtils.decurtSlash((String)restURL);
        this.gsuser = username;
        this.gspass = password;
        URL url = null;
        try {
            url = new URL(restURL);
        }
        catch (MalformedURLException var6) {
            LOGGER.error("Bad URL: Calls to GeoServer are going to fail", (Throwable)var6);
        }
        this.styleManager = new GeoServerRESTStyleManager(url, username, password);
    }

    public String backup(String backupDir) throws IllegalArgumentException {
        return this.backup(backupDir, false, false, false);
    }

    public String backup(String backupDir, boolean includedata, boolean includegwc, boolean includelog) throws IllegalArgumentException {
        if (backupDir != null && !backupDir.isEmpty()) {
            StringBuilder bkpUrl = new StringBuilder(this.restURL);
            bkpUrl.append("/rest/bkprst/backup");
            GSBackupEncoder bkpenc = new GSBackupEncoder(backupDir);
            bkpenc.setIncludeData(Boolean.valueOf(includedata));
            bkpenc.setIncludeGwc(Boolean.valueOf(includegwc));
            bkpenc.setIncludeLog(Boolean.valueOf(includelog));
            String result = HTTPUtils.post((String)bkpUrl.toString(), (String)bkpenc.toString(), (String)"text/xml", (String)this.gsuser, (String)this.gspass);
            return result;
        }
        throw new IllegalArgumentException("The backup_dir must not be null or empty");
    }

    public String restore(String backupDir) throws IllegalArgumentException {
        if (backupDir != null && !backupDir.isEmpty()) {
            StringBuilder bkpUrl = new StringBuilder(this.restURL);
            bkpUrl.append("/rest/bkprst/restore");
            GSBackupEncoder bkpenc = new GSBackupEncoder(backupDir);
            String result = HTTPUtils.post((String)bkpUrl.toString(), (String)bkpenc.toString(), (String)"text/xml", (String)this.gsuser, (String)this.gspass);
            return result;
        }
        throw new IllegalArgumentException("The backup_dir must not be null or empty");
    }

    public boolean createWorkspace(String workspace) {
        GSWorkspaceEncoder wsenc;
        String wsxml;
        String sUrl = this.restURL + "/rest/workspaces";
        String result = HTTPUtils.postXml((String)sUrl, (String)(wsxml = (wsenc = new GSWorkspaceEncoder(workspace)).toString()), (String)this.gsuser, (String)this.gspass);
        return result != null;
    }

    public boolean createWorkspace(String name, URI uri) {
        return this.createNamespace(name, uri);
    }

    public boolean createNamespace(String prefix, URI uri) {
        GSNamespaceEncoder nsenc;
        String nsxml;
        String sUrl = this.restURL + "/rest/namespaces";
        String result = HTTPUtils.postXml((String)sUrl, (String)(nsxml = (nsenc = new GSNamespaceEncoder(prefix, uri)).toString()), (String)this.gsuser, (String)this.gspass);
        return result != null;
    }

    public boolean updateNamespace(String prefix, URI uri) {
        GSNamespaceEncoder nsenc;
        String nsxml;
        String sUrl = this.restURL + "/rest/namespaces/" + this.encode(prefix);
        String result = HTTPUtils.put((String)sUrl, (String)(nsxml = (nsenc = new GSNamespaceEncoder(prefix, uri)).toString()), (String)"application/xml", (String)this.gsuser, (String)this.gspass);
        return result != null;
    }

    public boolean removeNamespace(String prefix, boolean recurse) {
        return this.removeWorkspace(prefix, recurse);
    }

    public boolean publishStyle(String sldBody) {
        return this.styleManager.publishStyle(sldBody);
    }

    public boolean publishStyle(String sldBody, String name) throws IllegalArgumentException {
        return this.styleManager.publishStyle(sldBody, name);
    }

    public boolean publishStyle(File sldFile) {
        return this.styleManager.publishStyle(sldFile);
    }

    public boolean publishStyle(File sldFile, String name) {
        return this.styleManager.publishStyle(sldFile, name);
    }

    public boolean publishStyle(String sldBody, String name, boolean raw) {
        return this.styleManager.publishStyle(sldBody, name, raw);
    }

    public boolean publishStyle(File sldFile, String name, boolean raw) {
        return this.styleManager.publishStyle(sldFile, name, raw);
    }

    public boolean updateStyle(File sldFile, String name, boolean raw) throws IllegalArgumentException {
        return this.styleManager.updateStyle(sldFile, name, raw);
    }

    public boolean updateStyle(String sldBody, String name, boolean raw) throws IllegalArgumentException {
        return this.styleManager.updateStyle(sldBody, name, raw);
    }

    public boolean updateStyle(String sldBody, String name) throws IllegalArgumentException {
        return this.styleManager.updateStyle(sldBody, name);
    }

    public boolean updateStyle(File sldFile, String name) throws IllegalArgumentException {
        return this.styleManager.updateStyle(sldFile, name);
    }

    public boolean removeStyle(String styleName, boolean purge) throws IllegalArgumentException {
        return this.styleManager.removeStyle(styleName, purge);
    }

    public boolean removeStyle(String styleName) {
        return this.styleManager.removeStyle(styleName);
    }

    public boolean publishStyleInWorkspace(String workspace, String sldBody) {
        return this.styleManager.publishStyleInWorkspace(workspace, sldBody);
    }

    public boolean publishStyleInWorkspace(String workspace, String sldBody, String name) throws IllegalArgumentException {
        return this.styleManager.publishStyleInWorkspace(workspace, sldBody, name);
    }

    public boolean publishStyleInWorkspace(String workspace, File sldFile) {
        return this.styleManager.publishStyleInWorkspace(workspace, sldFile);
    }

    public boolean publishStyleInWorkspace(String workspace, File sldFile, String name) {
        return this.styleManager.publishStyleInWorkspace(workspace, sldFile, name);
    }

    public boolean updateStyleInWorkspace(String workspace, String sldBody, String name) throws IllegalArgumentException {
        return this.styleManager.updateStyleInWorkspace(workspace, sldBody, name);
    }

    public boolean updateStyleInWorkspace(String workspace, File sldFile, String name) throws IllegalArgumentException {
        return this.styleManager.updateStyleInWorkspace(workspace, sldFile, name);
    }

    public boolean removeStyleInWorkspace(String workspace, String styleName, boolean purge) throws IllegalArgumentException {
        return this.styleManager.removeStyleInWorkspace(workspace, styleName, purge);
    }

    public boolean removeStyleInWorkspace(String workspace, String styleName) {
        return this.styleManager.removeStyleInWorkspace(workspace, styleName);
    }

    private boolean createStore(String workspace, GeoServerRESTPublisher.StoreType dsType, String storeName, GeoServerRESTPublisher.UploadMethod method, Enum extension, String mimeType, URI uri, GeoServerRESTPublisher.ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        if (workspace != null && dsType != null && storeName != null && method != null && extension != null && mimeType != null && uri != null) {
            String sentResult;
            StringBuilder sbUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/").append(dsType).append("/").append(storeName).append("/").append(method).append(".").append("netcdf");
            if (configure != null) {
                sbUrl.append("?configure=").append(configure);
                if (params != (NameValuePair[])null && !(sentResult = this.appendParameters(params)).isEmpty()) {
                    sbUrl.append("&").append(sentResult);
                }
            }
            sentResult = null;
            if (method.equals((Object)GeoServerRESTPublisher.UploadMethod.FILE)) {
                File file = new File(uri);
                if (!file.exists()) {
                    throw new FileNotFoundException("unable to locate file: " + file);
                }
                sentResult = HTTPUtils.put((String)sbUrl.toString(), (File)file, (String)mimeType, (String)this.gsuser, (String)this.gspass);
            } else if (method.equals((Object)GeoServerRESTPublisher.UploadMethod.EXTERNAL)) {
                sentResult = HTTPUtils.put((String)sbUrl.toString(), (String)uri.toString(), (String)mimeType, (String)this.gsuser, (String)this.gspass);
            } else if (method.equals((Object)GeoServerRESTPublisher.UploadMethod.URL)) {
                sentResult = HTTPUtils.put((String)sbUrl.toString(), (String)uri.toString(), (String)mimeType, (String)this.gsuser, (String)this.gspass);
            }
            if (sentResult != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Store successfully created using ( " + uri + " )");
                }
                return true;
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error in creating store using: " + uri);
            }
            return false;
        }
        throw new IllegalArgumentException("Null argument");
    }

    public boolean createNetCDFStore(String workspace, String storeName, GeoServerRESTPublisher.UploadMethod method, Enum extension, String mimeType, URI uri, GeoServerRESTPublisher.ParameterConfigure configure, String content, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        if (configure == null) {
            configure = GeoServerRESTPublisher.ParameterConfigure.ALL;
        }
        if (workspace != null && storeName != null && method != null && extension != null && mimeType != null && uri != null) {
            StringBuilder sbUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/").append("coveragestores");
            if (configure != null) {
                sbUrl.append("?configure=").append(configure);
            }
            String sentResult = null;
            if (method.equals((Object)GeoServerRESTPublisher.UploadMethod.FILE)) {
                File file = new File(uri);
                if (!file.exists()) {
                    throw new FileNotFoundException("unable to locate file: " + file);
                }
                sentResult = HTTPUtils.put((String)sbUrl.toString(), (File)file, (String)mimeType, (String)this.gsuser, (String)this.gspass);
            } else if (method.equals((Object)GeoServerRESTPublisher.UploadMethod.EXTERNAL)) {
                sentResult = HTTPUtils.put((String)sbUrl.toString(), (String)uri.toString(), (String)mimeType, (String)this.gsuser, (String)this.gspass);
            } else if (method.equals((Object)GeoServerRESTPublisher.UploadMethod.URL)) {
                sentResult = HTTPUtils.put((String)sbUrl.toString(), (String)uri.toString(), (String)mimeType, (String)this.gsuser, (String)this.gspass);
            }
            if (content == null) {
                content = "<coverageStore><name>NetCDFStore</name><workspace>NetCDFWorkspace</workspace><enabled>true</enabled><type>NetCDF</type><url>file:NetCDFStore\\/sresa1b_ncar_ccsm3-example.nc</url></coverageStore>";
            }
            if ((sentResult = HTTPUtils.putXml((String)sbUrl.toString(), (String)content, (String)this.gsuser, (String)this.gspass)) != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Store successfully created using ( " + uri + " )");
                }
                return true;
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error in creating store using: " + uri);
            }
            return false;
        }
        throw new IllegalArgumentException("Null argument");
    }

    private boolean createDataStore(String workspace, String storeName, GeoServerRESTPublisher.UploadMethod method, GeoServerRESTPublisher.DataStoreExtension extension, String mimeType, URI uri, GeoServerRESTPublisher.ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        return this.createStore(workspace, GeoServerRESTPublisher.StoreType.DATASTORES, storeName, method, (Enum)extension, mimeType, uri, configure, params);
    }

    private boolean createCoverageStore(String workspace, String storeName, GeoServerRESTPublisher.UploadMethod method, GeoServerRESTPublisher.CoverageStoreExtension extension, String mimeType, URI uri, GeoServerRESTPublisher.ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        return this.createStore(workspace, GeoServerRESTPublisher.StoreType.COVERAGESTORES, storeName, method, (Enum)extension, mimeType, uri, configure, params);
    }

    public boolean createPostGISDatastore(String workspace, GSPostGISDatastoreEncoder datastoreEncoder) {
        String xml;
        String sUrl = this.restURL + "/rest/workspaces/" + workspace + "/datastores/";
        String result = HTTPUtils.postXml((String)sUrl, (String)(xml = datastoreEncoder.toString()), (String)this.gsuser, (String)this.gspass);
        return result != null;
    }

    public boolean publishDBLayer(String workspace, String storename, String layername, String srs, String defaultStyle) {
        GSFeatureTypeEncoder fte = new GSFeatureTypeEncoder();
        fte.setProjectionPolicy(GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED);
        fte.addKeyword("KEYWORD");
        fte.setTitle(layername);
        fte.setName(layername);
        fte.setSRS(srs);
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        layerEncoder.setDefaultStyle(defaultStyle);
        return this.publishDBLayer(workspace, storename, fte, layerEncoder);
    }

    public boolean publishDBLayer(String workspace, String storename, GSFeatureTypeEncoder fte, GSLayerEncoder layerEncoder) {
        String ftypeXml = fte.toString();
        StringBuilder postUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/datastores/").append(storename).append("/featuretypes");
        String layername = fte.getName();
        if (layername != null && !layername.isEmpty()) {
            String configuredResult = HTTPUtils.postXml((String)postUrl.toString(), (String)ftypeXml, (String)this.gsuser, (String)this.gspass);
            boolean published = configuredResult != null;
            boolean configured = false;
            if (!published) {
                LOGGER.warn("Error in publishing (" + configuredResult + ") " + workspace + ":" + storename + "/" + layername);
            } else {
                LOGGER.info("DB layer successfully added (layer:" + layername + ")");
                if (layerEncoder == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("GSLayerEncoder is null: Unable to find the defaultStyle for this layer");
                    }
                    return false;
                }
                configured = this.configureLayer(workspace, layername, layerEncoder);
                if (!configured) {
                    LOGGER.warn("Error in configuring (" + configuredResult + ") " + workspace + ":" + storename + "/" + layername);
                } else {
                    LOGGER.info("DB layer successfully configured (layer:" + layername + ")");
                }
            }
            return published && configured;
        }
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("GSFeatureTypeEncoder has no valid name associated, try using GSFeatureTypeEncoder.setName(String)");
        }
        return false;
    }

    public boolean publishShp(String workspace, String storename, String datasetname, File zipFile) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storename, new NameValuePair[0], datasetname, GeoServerRESTPublisher.UploadMethod.FILE, zipFile.toURI(), DEFAULT_CRS, (String)null);
    }

    public boolean publishShp(String workspace, String storeName, NameValuePair[] storeParams, String datasetName, GeoServerRESTPublisher.UploadMethod method, URI shapefile, String srs, String nativeCRS, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        if (workspace != null && storeName != null && shapefile != null && datasetName != null && policy != null) {
            boolean nativeSrsNull;
            boolean srsNull = srs == null || srs.length() == 0;
            boolean bl = nativeSrsNull = nativeCRS == null || nativeCRS.length() == 0;
            if (policy != GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED || !nativeSrsNull && !srsNull) {
                String mimeType;
                if (policy == GSResourceEncoder.ProjectionPolicy.NONE && nativeSrsNull) {
                    throw new IllegalArgumentException("Unable to run: you can't ask GeoServer to use a native srs which is null");
                }
                if (policy == GSResourceEncoder.ProjectionPolicy.FORCE_DECLARED && srsNull) {
                    throw new IllegalArgumentException("Unable to run: you can't force GeoServer to use an srs which is null");
                }
                switch (method) {
                    case EXTERNAL: 
                    case external: {
                        mimeType = "text/plain";
                        break;
                    }
                    case URL: 
                    case FILE: 
                    case file: 
                    case url: {
                        mimeType = "application/zip";
                        break;
                    }
                    default: {
                        mimeType = null;
                    }
                }
                if (!this.createDataStore(workspace, storeName != null ? storeName : FilenameUtils.getBaseName((String)shapefile.toString()), method, GeoServerRESTPublisher.DataStoreExtension.SHP, mimeType, shapefile, GeoServerRESTPublisher.ParameterConfigure.NONE, storeParams)) {
                    LOGGER.error("Unable to create data store for shapefile: " + shapefile);
                    return false;
                }
                GSFeatureTypeEncoder featureTypeEncoder = new GSFeatureTypeEncoder();
                featureTypeEncoder.setName(datasetName);
                featureTypeEncoder.setTitle(datasetName);
                if (!srsNull) {
                    featureTypeEncoder.setSRS(srs);
                } else {
                    featureTypeEncoder.setSRS(nativeCRS);
                }
                if (!nativeSrsNull) {
                    featureTypeEncoder.setNativeCRS(nativeCRS);
                }
                featureTypeEncoder.setProjectionPolicy(policy);
                if (!this.createResource(workspace, GeoServerRESTPublisher.StoreType.DATASTORES, storeName, (GSResourceEncoder)featureTypeEncoder)) {
                    LOGGER.error("Unable to create a coverage store for coverage: " + shapefile);
                    return false;
                }
                GSLayerEncoder layerEncoder = this.configureDefaultStyle(defaultStyle);
                return this.configureLayer(workspace, datasetName, layerEncoder);
            }
            throw new IllegalArgumentException("Unable to run: you can't ask GeoServer to reproject while not specifying a native CRS");
        }
        throw new IllegalArgumentException("Unable to run: null parameter");
    }

    private GSLayerEncoder configureDefaultStyle(String defaultStyle) {
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        if (defaultStyle != null && !defaultStyle.isEmpty()) {
            if (defaultStyle.indexOf(":") != -1) {
                String[] wsAndName = defaultStyle.split(":");
                layerEncoder.setDefaultStyle(wsAndName[0], wsAndName[1]);
            } else {
                layerEncoder.setDefaultStyle(defaultStyle);
            }
        }
        return layerEncoder;
    }

    public boolean publishShp(String workspace, String storeName, NameValuePair[] storeParams, String datasetName, GeoServerRESTPublisher.UploadMethod method, URI shapefile, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storeName, storeParams, datasetName, method, shapefile, srs, (String)null, policy, defaultStyle);
    }

    public boolean publishShp(String workspace, String storeName, NameValuePair[] storeParams, String datasetName, GeoServerRESTPublisher.UploadMethod method, URI shapefile, String srs, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storeName, storeParams, datasetName, method, shapefile, srs, (String)null, GSResourceEncoder.ProjectionPolicy.FORCE_DECLARED, defaultStyle);
    }

    public boolean publishShp(String workspace, String storename, String layerName, File zipFile, String srs, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storename, (NameValuePair[])null, layerName, GeoServerRESTPublisher.UploadMethod.FILE, zipFile.toURI(), srs, defaultStyle);
    }

    public boolean publishShp(String workspace, String storename, String layername, File zipFile, String srs) throws FileNotFoundException {
        return this.publishShp(workspace, storename, (NameValuePair[])null, layername, GeoServerRESTPublisher.UploadMethod.FILE, zipFile.toURI(), srs, (String)null);
    }

    public boolean publishShp(String workspace, String storename, String layername, File zipFile, String srs, NameValuePair ... params) throws FileNotFoundException, IllegalArgumentException {
        return this.publishShp(workspace, storename, params, layername, GeoServerRESTPublisher.UploadMethod.FILE, zipFile.toURI(), srs, (String)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean publishShpCollection(String workspace, String storeName, URI resource) throws FileNotFoundException {
        GeoServerRESTPublisher.UploadMethod method = null;
        String mime = null;
        if (!resource.getScheme().equals("file") && resource.isAbsolute()) {
            try {
                if (resource.toURL() == null) return this.createStore(workspace, GeoServerRESTPublisher.StoreType.DATASTORES, storeName, method, (Enum)GeoServerRESTPublisher.DataStoreExtension.SHP, mime, resource, GeoServerRESTPublisher.ParameterConfigure.ALL, new NameValuePair[0]);
                method = GeoServerRESTPublisher.UploadMethod.URL;
                mime = "text/plain";
                return this.createStore(workspace, GeoServerRESTPublisher.StoreType.DATASTORES, storeName, method, (Enum)GeoServerRESTPublisher.DataStoreExtension.SHP, mime, resource, GeoServerRESTPublisher.ParameterConfigure.ALL, new NameValuePair[0]);
            }
            catch (MalformedURLException var7) {
                throw new IllegalArgumentException("Resource is not recognized as a zip file, or a directory, or a valid URL", var7);
            }
        } else {
            File f = new File(resource);
            if (f.exists() && f.isFile() && f.toString().endsWith(".zip")) {
                method = GeoServerRESTPublisher.UploadMethod.FILE;
                mime = "application/zip";
                return this.createStore(workspace, GeoServerRESTPublisher.StoreType.DATASTORES, storeName, method, (Enum)GeoServerRESTPublisher.DataStoreExtension.SHP, mime, resource, GeoServerRESTPublisher.ParameterConfigure.ALL, new NameValuePair[0]);
            } else {
                if (!f.isDirectory()) return this.createStore(workspace, GeoServerRESTPublisher.StoreType.DATASTORES, storeName, method, (Enum)GeoServerRESTPublisher.DataStoreExtension.SHP, mime, resource, GeoServerRESTPublisher.ParameterConfigure.ALL, new NameValuePair[0]);
                method = GeoServerRESTPublisher.UploadMethod.EXTERNAL;
                mime = "text/plain";
            }
        }
        return this.createStore(workspace, GeoServerRESTPublisher.StoreType.DATASTORES, storeName, method, (Enum)GeoServerRESTPublisher.DataStoreExtension.SHP, mime, resource, GeoServerRESTPublisher.ParameterConfigure.ALL, new NameValuePair[0]);
    }

    private boolean publishCoverage(String workspace, String coveragestore, GeoServerRESTPublisher.CoverageStoreExtension extension, String mimeType, File file, GeoServerRESTPublisher.ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException {
        return this.createCoverageStore(workspace, coveragestore, GeoServerRESTPublisher.UploadMethod.FILE, extension, mimeType, file.toURI(), configure, params);
    }

    private boolean publishExternalCoverage(String workspace, String coveragestore, GeoServerRESTPublisher.CoverageStoreExtension extension, String mimeType, File file, GeoServerRESTPublisher.ParameterConfigure configure, GeoServerRESTPublisher.ParameterUpdate update) throws FileNotFoundException, IllegalArgumentException {
        NameValuePair[] nameValuePairArray;
        URI uRI = file.toURI();
        if (update != null) {
            NameValuePair[] nameValuePairArray2 = new NameValuePair[1];
            nameValuePairArray = nameValuePairArray2;
            nameValuePairArray2[0] = new NameValuePair("update", update.toString());
        } else {
            nameValuePairArray = null;
        }
        return this.createCoverageStore(workspace, coveragestore, GeoServerRESTPublisher.UploadMethod.EXTERNAL, extension, mimeType, uRI, configure, nameValuePairArray);
    }

    public boolean publishArcGrid(String workspace, String storeName, File arcgrid) throws FileNotFoundException {
        return this.publishCoverage(workspace, storeName, GeoServerRESTPublisher.CoverageStoreExtension.ARCGRID, "image/arcgrid", arcgrid, GeoServerRESTPublisher.ParameterConfigure.FIRST, null);
    }

    public boolean publishArcGrid(String workspace, String storeName, String coverageName, File arcgrid) throws FileNotFoundException, IllegalArgumentException {
        if (workspace != null && arcgrid != null) {
            NameValuePair[] nameValuePairArray;
            String string = storeName != null ? storeName : FilenameUtils.getBaseName((String)arcgrid.getAbsolutePath());
            if (coverageName != null) {
                NameValuePair[] nameValuePairArray2 = new NameValuePair[1];
                nameValuePairArray = nameValuePairArray2;
                nameValuePairArray2[0] = new NameValuePair("coverageName", coverageName);
            } else {
                nameValuePairArray = null;
            }
            return this.publishCoverage(workspace, string, GeoServerRESTPublisher.CoverageStoreExtension.ARCGRID, "image/arcgrid", arcgrid, GeoServerRESTPublisher.ParameterConfigure.FIRST, nameValuePairArray);
        }
        throw new IllegalArgumentException("Unable to proceed, some arguments are null");
    }

    public boolean publishArcGrid(String workspace, String storeName, String coverageName, File arcgrid, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox) throws FileNotFoundException, IllegalArgumentException {
        if (workspace != null && storeName != null && arcgrid != null && coverageName != null && srs != null && policy != null && defaultStyle != null) {
            if (!this.createCoverageStore(workspace, storeName != null ? storeName : FilenameUtils.getBaseName((String)arcgrid.getAbsolutePath()), GeoServerRESTPublisher.UploadMethod.FILE, GeoServerRESTPublisher.CoverageStoreExtension.ARCGRID, "image/arcgrid", arcgrid.toURI(), GeoServerRESTPublisher.ParameterConfigure.NONE, null)) {
                LOGGER.error("Unable to create coverage store for coverage: " + arcgrid);
                return false;
            }
            GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
            coverageEncoder.setName(coverageName);
            coverageEncoder.setTitle(coverageName);
            coverageEncoder.setSRS(srs);
            coverageEncoder.setNativeFormat("ArcGrid");
            coverageEncoder.addSupportedFormats("ARCGRID");
            coverageEncoder.addKeyword("arcGrid");
            coverageEncoder.addKeyword("WCS");
            coverageEncoder.setNativeCRS(srs);
            coverageEncoder.setProjectionPolicy(policy);
            coverageEncoder.setRequestSRS(srs);
            coverageEncoder.setResponseSRS(srs);
            if (bbox != null && bbox.length == 4) {
                coverageEncoder.setLatLonBoundingBox(bbox[0], bbox[1], bbox[2], bbox[3], DEFAULT_CRS);
            }
            if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
                LOGGER.error("Unable to create a coverage store for coverage: " + arcgrid);
                return false;
            }
            GSLayerEncoder layerEncoder = this.configureDefaultStyle(defaultStyle);
            return this.configureLayer(workspace, coverageName, layerEncoder);
        }
        throw new IllegalArgumentException("Unable to run: null parameter");
    }

    public boolean publishExternalArcGrid(String workspace, String storeName, File arcgrid, String coverageName, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        if (workspace != null && storeName != null && arcgrid != null && coverageName != null && srs != null && policy != null && defaultStyle != null) {
            GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
            coverageEncoder.setName(coverageName);
            coverageEncoder.setTitle(coverageName);
            coverageEncoder.setSRS(srs);
            coverageEncoder.setProjectionPolicy(policy);
            GSLayerEncoder layerEncoder = new GSLayerEncoder();
            layerEncoder.setDefaultStyle(defaultStyle);
            return this.publishExternalArcGrid(workspace, storeName, arcgrid, coverageEncoder, layerEncoder) != null;
        }
        throw new IllegalArgumentException("Unable to run: null parameter");
    }

    public RESTCoverageStore publishExternalArcGrid(String workspace, String storeName, File arcgrid, GSCoverageEncoder coverageEncoder, GSLayerEncoder layerEncoder) throws IllegalArgumentException, FileNotFoundException {
        if (workspace != null && arcgrid != null && storeName != null && layerEncoder != null && coverageEncoder != null) {
            String coverageName = coverageEncoder.getName();
            if (coverageName.isEmpty()) {
                throw new IllegalArgumentException("Unable to run: empty coverage store name");
            }
            boolean store = this.publishExternalCoverage(workspace, storeName, GeoServerRESTPublisher.CoverageStoreExtension.ARCGRID, "text/plain", arcgrid, GeoServerRESTPublisher.ParameterConfigure.NONE, GeoServerRESTPublisher.ParameterUpdate.OVERWRITE);
            if (!store) {
                return null;
            }
            if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Unable to create a coverage for the store:" + coverageName);
                }
                return null;
            }
            if (this.configureLayer(workspace, coverageName, layerEncoder)) {
                try {
                    GeoServerRESTReader reader = new GeoServerRESTReader(this.restURL, this.gsuser, this.gspass);
                    return reader.getCoverageStore(workspace, storeName);
                }
                catch (MalformedURLException var10) {
                    LOGGER.error(var10.getMessage(), (Throwable)var10);
                }
            }
            return null;
        }
        throw new IllegalArgumentException("Unable to run: null parameter");
    }

    public boolean publishGeoTIFF(String workspace, String storeName, File geotiff) throws FileNotFoundException {
        return this.publishCoverage(workspace, storeName, GeoServerRESTPublisher.CoverageStoreExtension.GEOTIFF, "image/geotiff", geotiff, GeoServerRESTPublisher.ParameterConfigure.FIRST, null);
    }

    public boolean publishGeoTIFF(String workspace, String storeName, String coverageName, File geotiff) throws FileNotFoundException, IllegalArgumentException {
        if (workspace != null && geotiff != null) {
            NameValuePair[] nameValuePairArray;
            String string = storeName != null ? storeName : FilenameUtils.getBaseName((String)geotiff.getAbsolutePath());
            if (coverageName != null) {
                NameValuePair[] nameValuePairArray2 = new NameValuePair[1];
                nameValuePairArray = nameValuePairArray2;
                nameValuePairArray2[0] = new NameValuePair("coverageName", coverageName);
            } else {
                nameValuePairArray = null;
            }
            return this.publishCoverage(workspace, string, GeoServerRESTPublisher.CoverageStoreExtension.GEOTIFF, "image/geotiff", geotiff, GeoServerRESTPublisher.ParameterConfigure.FIRST, nameValuePairArray);
        }
        throw new IllegalArgumentException("Unable to proceed, some arguments are null");
    }

    public boolean publishGeoTIFF(String workspace, String storeName, String resourceName, File geotiff, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        return this.publishGeoTIFF(workspace, storeName, resourceName, geotiff, srs, policy, defaultStyle, null);
    }

    public boolean publishGeoTIFF(String workspace, String storeName, String coverageName, File geotiff, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox) throws FileNotFoundException, IllegalArgumentException {
        if (workspace != null && storeName != null && geotiff != null && coverageName != null && srs != null && policy != null && defaultStyle != null) {
            if (!this.createCoverageStore(workspace, storeName != null ? storeName : FilenameUtils.getBaseName((String)geotiff.getAbsolutePath()), GeoServerRESTPublisher.UploadMethod.FILE, GeoServerRESTPublisher.CoverageStoreExtension.GEOTIFF, "image/geotiff", geotiff.toURI(), GeoServerRESTPublisher.ParameterConfigure.NONE, null)) {
                LOGGER.error("Unable to create coverage store for coverage: " + geotiff);
                return false;
            }
            GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
            coverageEncoder.setName(coverageName);
            coverageEncoder.setTitle(coverageName);
            coverageEncoder.setSRS(srs);
            coverageEncoder.setNativeFormat("GeoTIFF");
            coverageEncoder.addSupportedFormats("GEOTIFF");
            coverageEncoder.addKeyword("geoTiff");
            coverageEncoder.addKeyword("WCS");
            coverageEncoder.setNativeCRS(srs);
            coverageEncoder.setProjectionPolicy(policy);
            coverageEncoder.setRequestSRS(srs);
            coverageEncoder.setResponseSRS(srs);
            if (bbox != null && bbox.length == 4) {
                coverageEncoder.setLatLonBoundingBox(bbox[0], bbox[1], bbox[2], bbox[3], DEFAULT_CRS);
            }
            if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
                LOGGER.error("Unable to create a coverage store for coverage: " + geotiff);
                return false;
            }
            GSLayerEncoder layerEncoder = this.configureDefaultStyle(defaultStyle);
            return this.configureLayer(workspace, coverageName, layerEncoder);
        }
        throw new IllegalArgumentException("Unable to run: null parameter");
    }

    public boolean publishNetCDF(String workspace, String storeName, String coverageName, File netcdfFile, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox) throws FileNotFoundException, IllegalArgumentException {
        LOGGER.info("I have managed to reach public boolean publishNetCDF");
        if (workspace != null && storeName != null && netcdfFile != null && coverageName != null && srs != null && policy != null && defaultStyle != null) {
            if (!this.createCoverageStore(workspace, storeName != null ? storeName : FilenameUtils.getBaseName((String)netcdfFile.getAbsolutePath()), GeoServerRESTPublisher.UploadMethod.FILE, GeoServerRESTPublisher.CoverageStoreExtension.GEOTIFF, "application/zip", netcdfFile.toURI(), GeoServerRESTPublisher.ParameterConfigure.NONE, null)) {
                LOGGER.error("Unable to create coverage store for coverage: " + netcdfFile);
                return false;
            }
            GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
            coverageEncoder.setName(coverageName);
            coverageEncoder.setTitle(coverageName);
            coverageEncoder.setSRS(srs);
            coverageEncoder.setNativeFormat("NetCDF");
            coverageEncoder.addSupportedFormats("NetCDF");
            coverageEncoder.addKeyword("NetCDF");
            coverageEncoder.addKeyword("WCS");
            coverageEncoder.setNativeCRS(srs);
            coverageEncoder.setProjectionPolicy(policy);
            coverageEncoder.setRequestSRS(srs);
            coverageEncoder.setResponseSRS(srs);
            if (bbox != null && bbox.length == 4) {
                coverageEncoder.setLatLonBoundingBox(bbox[0], bbox[1], bbox[2], bbox[3], DEFAULT_CRS);
            }
            if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
                LOGGER.error("Unable to create a coverage store for coverage: " + netcdfFile);
                return false;
            }
            GSLayerEncoder layerEncoder = this.configureDefaultStyle(defaultStyle);
            return this.configureLayer(workspace, coverageName, layerEncoder);
        }
        throw new IllegalArgumentException("Unable to run: null parameter");
    }

    public boolean publishExternalGeoTIFF(String workspace, String storeName, File geotiff, String coverageName, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle) throws FileNotFoundException, IllegalArgumentException {
        if (workspace != null && storeName != null && geotiff != null && coverageName != null && srs != null && policy != null && defaultStyle != null) {
            GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
            coverageEncoder.setName(coverageName);
            coverageEncoder.setTitle(coverageName);
            coverageEncoder.setSRS(srs);
            coverageEncoder.setProjectionPolicy(policy);
            GSLayerEncoder layerEncoder = new GSLayerEncoder();
            layerEncoder.setDefaultStyle(defaultStyle);
            return this.publishExternalGeoTIFF(workspace, storeName, geotiff, coverageEncoder, layerEncoder) != null;
        }
        throw new IllegalArgumentException("Unable to run: null parameter");
    }

    public RESTCoverageStore publishExternalGeoTIFF(String workspace, String storeName, File geotiff, GSCoverageEncoder coverageEncoder, GSLayerEncoder layerEncoder) throws IllegalArgumentException, FileNotFoundException {
        if (workspace != null && geotiff != null && storeName != null && layerEncoder != null && coverageEncoder != null) {
            String coverageName = coverageEncoder.getName();
            if (coverageName.isEmpty()) {
                throw new IllegalArgumentException("Unable to run: empty coverage store name");
            }
            boolean store = this.publishExternalCoverage(workspace, storeName, GeoServerRESTPublisher.CoverageStoreExtension.GEOTIFF, "text/plain", geotiff, GeoServerRESTPublisher.ParameterConfigure.NONE, GeoServerRESTPublisher.ParameterUpdate.OVERWRITE);
            if (!store) {
                return null;
            }
            if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Unable to create a coverage for the store:" + coverageName);
                }
                return null;
            }
            if (this.configureLayer(workspace, coverageName, layerEncoder)) {
                try {
                    GeoServerRESTReader reader = new GeoServerRESTReader(this.restURL, this.gsuser, this.gspass);
                    return reader.getCoverageStore(workspace, storeName);
                }
                catch (MalformedURLException var10) {
                    LOGGER.error(var10.getMessage(), (Throwable)var10);
                }
            }
            return null;
        }
        throw new IllegalArgumentException("Unable to run: null parameter");
    }

    public boolean publishWorldImage(String workspace, String coveragestore, File zipFile) throws FileNotFoundException {
        return this.publishWorldImage(workspace, coveragestore, zipFile, GeoServerRESTPublisher.ParameterConfigure.FIRST, new NameValuePair[]{null});
    }

    public boolean publishWorldImage(String workspace, String coveragestore, File zipFile, GeoServerRESTPublisher.ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException {
        return this.publishCoverage(workspace, coveragestore, GeoServerRESTPublisher.CoverageStoreExtension.WORLDIMAGE, "application/zip", zipFile, configure, params);
    }

    public boolean publishImageMosaic(String workspace, String storeName, File zipFile) throws FileNotFoundException {
        return this.publishCoverage(workspace, storeName, GeoServerRESTPublisher.CoverageStoreExtension.IMAGEMOSAIC, "application/zip", zipFile, GeoServerRESTPublisher.ParameterConfigure.FIRST, null);
    }

    public boolean publishImageMosaic(String workspace, String storeName, File zipFile, GeoServerRESTPublisher.ParameterConfigure configure, NameValuePair ... params) throws FileNotFoundException {
        return this.publishCoverage(workspace, storeName, GeoServerRESTPublisher.CoverageStoreExtension.IMAGEMOSAIC, "application/zip", zipFile, configure, params);
    }

    public RESTCoverageStore createExternaMosaicDatastore(String workspace, String storeName, File mosaicDir, GeoServerRESTPublisher.ParameterConfigure configure, GeoServerRESTPublisher.ParameterUpdate update) throws FileNotFoundException {
        if (!mosaicDir.isDirectory() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Directory '" + mosaicDir + "' not exists locally. Continue: please check existance on the remote server.");
        }
        String sUrl = this.restURL + "/rest/workspaces/" + workspace + "/coveragestores/" + storeName + "/external.imagemosaic?configure=" + configure.toString() + "&update=" + update.toString();
        String sendResult = HTTPUtils.put((String)sUrl, (String)mosaicDir.toURI().toString(), (String)"text/plain", (String)this.gsuser, (String)this.gspass);
        return RESTCoverageStore.build((String)sendResult);
    }

    public boolean publishExternalMosaic(String workspace, String storeName, File mosaicDir, String srs, String defaultStyle) throws FileNotFoundException {
        GSCoverageEncoder coverageEncoder = new GSCoverageEncoder();
        coverageEncoder.setSRS(srs);
        String name = FilenameUtils.getBaseName((String)mosaicDir.getName());
        coverageEncoder.setName(name);
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        layerEncoder.setDefaultStyle(defaultStyle);
        return this.publishExternalMosaic(workspace, storeName, mosaicDir, coverageEncoder, layerEncoder);
    }

    public boolean createExternalMosaic(String workspace, String storeName, File mosaicDir, GSCoverageEncoder coverageEncoder, GSLayerEncoder layerEncoder) throws FileNotFoundException {
        return this.publishExternalMosaic(workspace, storeName, mosaicDir, coverageEncoder, layerEncoder);
    }

    public boolean publishExternalMosaic(String workspace, String storeName, File mosaicDir, GSCoverageEncoder coverageEncoder, GSLayerEncoder layerEncoder) throws FileNotFoundException, IllegalArgumentException {
        if (coverageEncoder == null) {
            throw new IllegalArgumentException("no coverageEncoder provided for mosaic " + mosaicDir);
        }
        if (layerEncoder == null) {
            throw new IllegalArgumentException("no layerEncoder provided for " + mosaicDir);
        }
        RESTCoverageStore store = this.createExternaMosaicDatastore(workspace, storeName, mosaicDir, GeoServerRESTPublisher.ParameterConfigure.NONE, GeoServerRESTPublisher.ParameterUpdate.OVERWRITE);
        if (store == null) {
            return false;
        }
        String coverageName = coverageEncoder.getName();
        if (coverageName == null) {
            coverageName = mosaicDir.getName();
            coverageEncoder.setName(coverageName);
        }
        if (!this.createCoverage(workspace, storeName, coverageEncoder)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to create a coverage for the store:" + coverageName);
            }
            return false;
        }
        if (!this.configureLayer(workspace, coverageName, layerEncoder)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to configure the Layer for the coverage:" + coverageName);
            }
            return false;
        }
        return true;
    }

    public boolean unpublishCoverage(String workspace, String storename, String layerName) {
        try {
            boolean covDeleted;
            boolean layerDeleted;
            String fqLayerName;
            if (workspace == null) {
                fqLayerName = layerName;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Null workspace while configuring layer : " + layerName + " -- This behavior is deprecated.");
                }
            } else {
                fqLayerName = workspace + ":" + layerName;
            }
            URL deleteLayerUrl = new URL(this.restURL + "/rest/layers/" + fqLayerName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Going to delete /rest/layers/" + fqLayerName);
            }
            if (!(layerDeleted = HTTPUtils.delete((String)deleteLayerUrl.toExternalForm(), (String)this.gsuser, (String)this.gspass))) {
                LOGGER.warn("Could not delete layer '" + fqLayerName + "'");
                return false;
            }
            URL deleteCovUrl = new URL(this.restURL + "/rest/workspaces/" + workspace + "/coveragestores/" + storename + "/coverages/" + layerName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Going to delete /rest/workspaces/" + workspace + "/coveragestores/" + storename + "/coverages/" + layerName);
            }
            if (!(covDeleted = HTTPUtils.delete((String)deleteCovUrl.toExternalForm(), (String)this.gsuser, (String)this.gspass))) {
                LOGGER.warn("Could not delete coverage " + workspace + ":" + storename + "/" + layerName + ", but layer was deleted.");
            } else {
                LOGGER.info("Coverage successfully deleted " + workspace + ":" + storename + "/" + layerName);
            }
            return covDeleted;
        }
        catch (MalformedURLException var9) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(var9.getLocalizedMessage(), (Throwable)var9);
            }
            return false;
        }
    }

    public boolean unpublishFeatureType(String workspace, String storename, String layerName) {
        try {
            URL deleteLayerUrl;
            boolean layerDeleted;
            String fqLayerName;
            if (workspace == null) {
                fqLayerName = layerName;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Null workspace while configuring layer : " + layerName + " -- This behavior is deprecated.");
                }
            } else {
                fqLayerName = workspace + ":" + layerName;
            }
            if (!(layerDeleted = HTTPUtils.delete((String)(deleteLayerUrl = new URL(this.restURL + "/rest/layers/" + fqLayerName)).toExternalForm(), (String)this.gsuser, (String)this.gspass))) {
                LOGGER.warn("Could not delete layer '" + fqLayerName + "'");
                return false;
            }
            URL deleteFtUrl = new URL(this.restURL + "/rest/workspaces/" + workspace + "/datastores/" + storename + "/featuretypes/" + layerName);
            boolean ftDeleted = HTTPUtils.delete((String)deleteFtUrl.toExternalForm(), (String)this.gsuser, (String)this.gspass);
            if (!ftDeleted) {
                LOGGER.warn("Could not delete featuretype " + workspace + ":" + storename + "/" + layerName + ", but layer was deleted.");
            } else {
                LOGGER.info("FeatureType successfully deleted " + workspace + ":" + storename + "/" + layerName);
            }
            return ftDeleted;
        }
        catch (MalformedURLException var9) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(var9.getLocalizedMessage(), (Throwable)var9);
            }
            return false;
        }
    }

    public boolean removeDatastore(String workspace, String storename) {
        try {
            return this.removeDatastore(workspace, storename, true);
        }
        catch (IllegalArgumentException var4) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Arguments may not be null or empty!", (Throwable)var4);
            }
            return false;
        }
    }

    public boolean removeDatastore(String workspace, String storename, boolean recurse) throws IllegalArgumentException {
        return this.removeStore(workspace, storename, GeoServerRESTPublisher.StoreType.DATASTORES, recurse, GeoServerRESTPublisher.Purge.NONE);
    }

    public boolean removeDatastore(String workspace, String storename, boolean recurse, GeoServerRESTPublisher.Purge purge) throws IllegalArgumentException {
        return this.removeStore(workspace, storename, GeoServerRESTPublisher.StoreType.DATASTORES, recurse, purge);
    }

    public boolean removeCoverageStore(String workspace, String storename) {
        return this.removeCoverageStore(workspace, storename, true);
    }

    public boolean removeCoverageStore(String workspace, String storename, boolean recurse) throws IllegalArgumentException {
        return this.removeStore(workspace, storename, GeoServerRESTPublisher.StoreType.COVERAGESTORES, recurse, GeoServerRESTPublisher.Purge.NONE);
    }

    public boolean removeCoverageStore(String workspace, String storename, boolean recurse, GeoServerRESTPublisher.Purge purge) throws IllegalArgumentException {
        return this.removeStore(workspace, storename, GeoServerRESTPublisher.StoreType.COVERAGESTORES, recurse, purge);
    }

    private boolean removeStore(String workspace, String storename, GeoServerRESTPublisher.StoreType type, boolean recurse, GeoServerRESTPublisher.Purge purge) throws IllegalArgumentException {
        try {
            if (workspace != null && storename != null) {
                if (!workspace.isEmpty() && !storename.isEmpty()) {
                    URL deleteStore;
                    boolean deleted;
                    StringBuilder url = new StringBuilder(this.restURL);
                    url.append("/rest/workspaces/").append(workspace).append("/").append(type).append("/").append(storename);
                    url.append("?recurse=").append(recurse);
                    if (purge != null) {
                        url.append("&purge=").append(purge);
                    }
                    if (!(deleted = HTTPUtils.delete((String)(deleteStore = new URL(url.toString())).toExternalForm(), (String)this.gsuser, (String)this.gspass))) {
                        LOGGER.warn("Could not delete store " + workspace + ":" + storename);
                    } else {
                        LOGGER.info("Store successfully deleted " + workspace + ":" + storename);
                    }
                    return deleted;
                }
                throw new IllegalArgumentException("Arguments may not be empty!");
            }
            throw new IllegalArgumentException("Arguments may not be null!");
        }
        catch (MalformedURLException var9) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(var9.getLocalizedMessage(), (Throwable)var9);
            }
            return false;
        }
    }

    public boolean removeWorkspace(String workspace) {
        return this.removeWorkspace(workspace, false);
    }

    public boolean removeWorkspace(String workspace, boolean recurse) throws IllegalArgumentException {
        workspace = this.sanitize(workspace);
        try {
            if (workspace == null) {
                throw new IllegalArgumentException("Arguments may not be null!");
            }
            if (workspace.isEmpty()) {
                throw new IllegalArgumentException("Arguments may not be empty!");
            }
            StringBuffer url = new StringBuffer(this.restURL).append("/rest/workspaces/").append(workspace);
            if (recurse) {
                url.append("?recurse=true");
            }
            this.deleteStylesForWorkspace(workspace);
            URL deleteUrl = new URL(url.toString());
            boolean deleted = HTTPUtils.delete((String)deleteUrl.toExternalForm(), (String)this.gsuser, (String)this.gspass);
            if (!deleted) {
                LOGGER.warn("Could not delete Workspace " + workspace);
            } else {
                LOGGER.info("Workspace successfully deleted " + workspace);
            }
            return deleted;
        }
        catch (MalformedURLException var6) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(var6.getLocalizedMessage(), (Throwable)var6);
            }
            return false;
        }
    }

    private void deleteStylesForWorkspace(String workspace) {
        RESTStyleList styles = this.styleManager.getStyles(workspace);
        if (styles != null) {
            for (NameLinkElem nameLinkElem : styles) {
                this.removeStyleInWorkspace(workspace, nameLinkElem.getName(), true);
            }
        }
    }

    public boolean removeLayerGroup(String workspace, String name) {
        String url = this.restURL + "/rest";
        url = workspace == null ? url + "/layergroups/" + name : url + "/workspaces/" + workspace + "/layergroups/" + name;
        try {
            URL deleteUrl = new URL(url);
            boolean deleted = HTTPUtils.delete((String)deleteUrl.toExternalForm(), (String)this.gsuser, (String)this.gspass);
            if (!deleted) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Could not delete layergroup " + name);
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Layergroup successfully deleted: " + name);
            }
            return deleted;
        }
        catch (MalformedURLException var6) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(var6.getLocalizedMessage(), (Throwable)var6);
            }
            return false;
        }
    }

    public boolean removeLayerGroup(String name) {
        return this.removeLayerGroup(null, name);
    }

    public boolean removeLayer(String workspace, String layerName) {
        String fqLayerName;
        if (workspace == null) {
            fqLayerName = layerName;
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Null workspace while removing layer : " + layerName + " -- This behavior is deprecated.");
            }
        } else {
            fqLayerName = workspace + ":" + layerName;
        }
        if (layerName == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Null layerName : " + layerName);
            }
            return false;
        }
        String url = this.restURL + "/rest/layers/" + fqLayerName;
        boolean result = HTTPUtils.delete((String)url, (String)this.gsuser, (String)this.gspass);
        if (result) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Layer successfully removed: " + fqLayerName);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error removing layer " + fqLayerName);
        }
        return result;
    }

    public boolean reloadStore(String workspace, String storeName, GeoServerRESTPublisher.StoreType storeType) throws IllegalArgumentException, MalformedURLException {
        String url = HTTPUtils.append((String[])new String[]{this.restURL, "/rest/workspaces/", workspace, "/", storeType.toString(), "/", storeName, ".xml"}).toString();
        String store = HTTPUtils.get((String)url, (String)this.gsuser, (String)this.gspass);
        if (store != null) {
            String storeTag = storeType.getTypeName();
            String startTag = "<" + storeTag + ">";
            int start = store.indexOf(startTag);
            String endTag = "</" + storeTag + ">";
            int stop = store.indexOf(endTag) + endTag.length();
            return HTTPUtils.putXml((String)url, (String)(store.subSequence(0, start) + store.substring(stop)), (String)this.gsuser, (String)this.gspass) != null;
        }
        return false;
    }

    public boolean reload() {
        String sUrl = this.restURL + "/rest/reload";
        String result = HTTPUtils.post((String)sUrl, (String)"", (String)"text/plain", (String)this.gsuser, (String)this.gspass);
        return result != null;
    }

    public boolean reset() {
        String sUrl = this.restURL + "/rest/reset";
        String result = HTTPUtils.post((String)sUrl, (String)"", (String)"text/plain", (String)this.gsuser, (String)this.gspass);
        return result != null;
    }

    public boolean configureLayer(String workspace, String resourceName, GSLayerEncoder layer) throws IllegalArgumentException {
        if (workspace != null && resourceName != null && layer != null) {
            if (!(workspace.isEmpty() || resourceName.isEmpty() || layer.isEmpty())) {
                String layerXml;
                String fqLayerName = workspace + ":" + resourceName;
                String url = this.restURL + "/rest/layers/" + fqLayerName;
                String sendResult = HTTPUtils.putXml((String)url, (String)(layerXml = layer.toString()), (String)this.gsuser, (String)this.gspass);
                if (sendResult != null) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Layer successfully configured: " + fqLayerName);
                    }
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Error configuring layer " + fqLayerName + " (" + sendResult + ")");
                }
                return sendResult != null;
            }
            throw new IllegalArgumentException("Empty argument");
        }
        throw new IllegalArgumentException("Null argument");
    }

    public boolean createLayerGroup(String name, GSLayerGroupEncoder group) {
        return this.createLayerGroup(null, name, group);
    }

    public boolean createLayerGroup(String workspace, String name, GSLayerGroupEncoder group) {
        String url = this.restURL + "/rest";
        if (workspace == null) {
            url = url + "/layergroups/";
        } else {
            group.setWorkspace(workspace);
            url = url + "/workspaces/" + workspace + "/layergroups/";
        }
        group.setName(name);
        String sendResult = HTTPUtils.postXml((String)url, (String)group.toString(), (String)this.gsuser, (String)this.gspass);
        if (sendResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("LayerGroup successfully configured: " + name);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring LayerGroup " + name + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean configureLayerGroup(String name, GSLayerGroupEncoder group) {
        return this.configureLayerGroup(null, name, group);
    }

    public boolean configureLayerGroup(String workspace, String name, GSLayerGroupEncoder group) {
        String url = this.restURL + "/rest";
        url = workspace == null ? url + "/layergroups/" + name : url + "/workspaces/" + workspace + "/layergroups/" + name;
        String sendResult = HTTPUtils.putXml((String)url, (String)group.toString(), (String)this.gsuser, (String)this.gspass);
        if (sendResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("LayerGroup successfully configured: " + name);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring LayerGroup " + name + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean configureCoverage(GSCoverageEncoder ce, String wsname, String csname) {
        return this.configureCoverage(ce, wsname, csname, ce.getName());
    }

    public boolean configureCoverage(GSCoverageEncoder ce, String wsname, String csname, String coverageName) {
        String xmlBody;
        GeoServerRESTReader reader;
        if (coverageName == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to configure a coverage with no name try using GSCoverageEncoder.setName(String)");
            }
            return false;
        }
        try {
            reader = new GeoServerRESTReader(this.restURL, this.gsuser, this.gspass);
        }
        catch (MalformedURLException var10) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(var10.getLocalizedMessage(), (Throwable)var10);
            }
            return false;
        }
        RESTCoverage coverage = reader.getCoverage(wsname, csname, coverageName);
        if (coverage == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("No coverages found in new coveragestore " + csname + " called " + coverageName);
            }
            return false;
        }
        String url = this.restURL + "/rest/workspaces/" + wsname + "/coveragestores/" + csname + "/coverages/" + coverageName + ".xml";
        String sendResult = HTTPUtils.putXml((String)url, (String)(xmlBody = ce.toString()), (String)this.gsuser, (String)this.gspass);
        if (sendResult != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Coverage successfully configured " + wsname + ":" + csname + ":" + coverageName);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring coverage " + wsname + ":" + csname + ":" + coverageName + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean createCoverage(GSCoverageEncoder ce, String wsname, String csname) {
        return this.createCoverage(wsname, csname, ce);
    }

    public boolean createCoverage(String wsname, String storeName, GSCoverageEncoder ce) throws IllegalArgumentException {
        return this.createResource(wsname, GeoServerRESTPublisher.StoreType.COVERAGESTORES, storeName, (GSResourceEncoder)ce);
    }

    private boolean createResource(String workspace, GeoServerRESTPublisher.StoreType dsType, String storeName, GSResourceEncoder re) throws IllegalArgumentException {
        if (workspace != null && dsType != null && storeName != null && re != null) {
            StringBuilder sbUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/").append(dsType).append("/").append(storeName).append("/").append(dsType.getTypeNameWithFormat(GeoServerRESTPublisher.Format.XML));
            String resourceName = re.getName();
            if (resourceName == null) {
                throw new IllegalArgumentException("Unable to configure a coverage using unnamed coverage encoder");
            }
            String xmlBody = re.toString();
            String sendResult = HTTPUtils.postXml((String)sbUrl.toString(), (String)xmlBody, (String)this.gsuser, (String)this.gspass);
            if (sendResult != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(dsType + " successfully created " + workspace + ":" + storeName + ":" + resourceName);
                }
            } else if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error creating coverage " + workspace + ":" + storeName + ":" + resourceName + " (" + sendResult + ")");
            }
            return sendResult != null;
        }
        throw new IllegalArgumentException("Null argument");
    }

    public boolean createNetCDFCoverageStore(String workspace, String storeName, String xmlBody) {
        if (workspace == null || xmlBody == null || storeName == null) {
            throw new IllegalArgumentException("Null argument");
        }
        StringBuilder sbUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/coveragestores?configure=all");
        LOGGER.info("Submitting request to geoserver at URL: " + sbUrl.toString());
        String sendResult = HTTPUtils.postXml((String)sbUrl.toString(), (String)xmlBody, (String)this.gsuser, (String)this.gspass);
        LOGGER.info("Result from request: " + sendResult);
        if (sendResult != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Coverage successfully created " + workspace + ":" + storeName);
            }
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Error creating coverage " + workspace + ":" + storeName + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean createNetCDFLayerFromFile(String workspace, String storeName, File netCDFFile) {
        if (workspace == null || storeName == null) {
            throw new IllegalArgumentException("Null argument");
        }
        StringBuilder sbUrl = new StringBuilder(this.restURL).append("/rest/workspaces/").append(workspace).append("/coveragestores/").append(storeName).append("/file.netcdf");
        LOGGER.info("Submitting request to geoserver at: " + sbUrl.toString());
        String sendResult = HTTPUtils.put((String)sbUrl.toString(), (File)netCDFFile, (String)"application/zip", (String)this.gsuser, (String)this.gspass);
        LOGGER.info("Result from request: " + sendResult);
        if (sendResult != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Coverage successfully created " + workspace + ":" + storeName);
            }
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Error creating coverage " + workspace + ":" + storeName + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    protected String sanitize(String s) {
        return s.indexOf(".") != -1 ? s + ".DUMMY" : s;
    }

    private String appendParameters(NameValuePair ... params) {
        int paramsSize;
        StringBuilder sbUrl = new StringBuilder();
        if (params != null && (paramsSize = params.length) > 0) {
            String value;
            String name;
            int i = 0;
            NameValuePair param = params[i];
            while (param != null && i++ < paramsSize) {
                name = param.getName();
                value = param.getValue();
                if (name != null && !name.isEmpty() && value != null && !value.isEmpty()) {
                    sbUrl.append(name).append("=").append(value);
                    param = null;
                    continue;
                }
                param = params[i];
            }
            while (i < paramsSize) {
                param = params[i];
                if (param != null) {
                    name = param.getName();
                    value = param.getValue();
                    sbUrl.append(name).append("=").append(value);
                    if (name != null && !name.isEmpty() && value != null && !value.isEmpty()) {
                        sbUrl.append("&").append(name).append("=").append(value);
                    }
                }
                ++i;
            }
        }
        return sbUrl.toString();
    }

    protected String encode(String s) {
        return URLEncoder.encode(s);
    }

    public boolean harvestExternal(String workspace, String coverageStore, String format, String path) {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.restURL), this.gsuser, this.gspass);
                return manager.harvestExternal(workspace, coverageStore, format, path);
            }
            catch (IllegalArgumentException var6) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(var6.getLocalizedMessage(), (Throwable)var6);
                }
            }
            catch (MalformedURLException var7) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(var7.getLocalizedMessage(), (Throwable)var7);
            }
        }
        return false;
    }

    public boolean createImageMosaic(String workspace, String coverageStore, String path) {
        return this.createImageMosaic(workspace, coverageStore, path, GeoServerRESTStructuredGridCoverageReaderManager.ConfigureCoveragesOption.ALL);
    }

    public boolean createImageMosaic(String workspace, String coverageStore, String path, GeoServerRESTStructuredGridCoverageReaderManager.ConfigureCoveragesOption configureOpt) {
        NetCDFPublisher.checkString(workspace);
        NetCDFPublisher.checkString(coverageStore);
        NetCDFPublisher.checkString(path);
        File zipFile = new File(path);
        if (zipFile.exists() && zipFile.isFile() && zipFile.canRead()) {
            ZipFile zip = null;
            try {
                zip = new ZipFile(zipFile);
                zip.getName();
            }
            catch (Exception var15) {
                LOGGER.trace(var15.getLocalizedMessage(), (Object[])var15.getStackTrace());
                throw new IllegalArgumentException("The provided pathname does not point to a valide zip file: " + path);
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException var14) {
                        LOGGER.trace(var14.getLocalizedMessage(), (Object[])var14.getStackTrace());
                    }
                }
            }
            StringBuilder ss = HTTPUtils.append((String[])new String[]{this.restURL, "/rest/workspaces/", workspace, "/coveragestores/", coverageStore, "/", GeoServerRESTPublisher.UploadMethod.EXTERNAL.toString(), ".imagemosaic"});
            switch (configureOpt) {
                case NONE: {
                    ss.append("?configure=none");
                }
                case ALL: {
                    String sUrl = ss.toString();
                    String result = HTTPUtils.put((String)sUrl, (File)zipFile, (String)"application/zip", (String)this.gsuser, (String)this.gspass);
                    return result != null;
                }
            }
            throw new IllegalArgumentException("Unrecognized COnfigureOption: " + configureOpt);
        }
        throw new IllegalArgumentException("The provided pathname does not point to a valide zip file: " + path);
    }

    public boolean removeGranuleById(String workspace, String coverageStore, String coverage, String granuleId) {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.restURL), this.gsuser, this.gspass);
                return manager.removeGranuleById(workspace, coverageStore, coverage, granuleId);
            }
            catch (IllegalArgumentException var6) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(var6.getLocalizedMessage(), (Throwable)var6);
                }
            }
            catch (MalformedURLException var7) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(var7.getLocalizedMessage(), (Throwable)var7);
            }
        }
        return false;
    }

    public boolean removeGranulesByCQL(String workspace, String coverageStore, String coverage, String filter) throws UnsupportedEncodingException {
        block4: {
            try {
                GeoServerRESTStructuredGridCoverageReaderManager manager = new GeoServerRESTStructuredGridCoverageReaderManager(new URL(this.restURL), this.gsuser, this.gspass);
                return manager.removeGranulesByCQL(workspace, coverageStore, coverage, filter);
            }
            catch (IllegalArgumentException var6) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(var6.getLocalizedMessage(), (Throwable)var6);
                }
            }
            catch (MalformedURLException var7) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info(var7.getLocalizedMessage(), (Throwable)var7);
            }
        }
        return false;
    }

    private static void checkString(String string) {
        if (string == null) {
            throw new NullPointerException("Provided string is is null!");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("Provided string is is empty!");
        }
    }

    public static enum StoreType {
        COVERAGESTORES,
        DATASTORES;


        public static String getTypeNameWithFormat(GeoServerRESTPublisher.StoreType type, GeoServerRESTPublisher.Format format) {
            return StoreType.getTypeName(type) + "." + format;
        }

        public static String getTypeName(GeoServerRESTPublisher.StoreType type) {
            switch (type) {
                case COVERAGESTORES: {
                    return "coverages";
                }
                case DATASTORES: {
                    return "featureTypes";
                }
            }
            return "coverages";
        }

        public static String getType(GeoServerRESTPublisher.StoreType type) {
            switch (type) {
                case COVERAGESTORES: {
                    return "coverageStore";
                }
                case DATASTORES: {
                    return "dataStore";
                }
            }
            return "coverageStore";
        }
    }

    public static enum UploadMethod {
        FILE,
        file,
        URL,
        url,
        EXTERNAL,
        external;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum DataStoreExtension {
        SHP,
        PROPERTIES,
        H2,
        SPATIALITE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum CoverageStoreExtension {
        GEOTIFF,
        IMAGEMOSAIC,
        WORLDIMAGE,
        ARCGRID;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum ParameterConfigure {
        FIRST,
        NONE,
        ALL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum ParameterUpdate {
        APPEND,
        OVERWRITE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Format {
        XML,
        JSON,
        HTML,
        SLD,
        SLD_1_1_0;


        public static String getContentType(GeoServerRESTPublisher.Format f) {
            switch (f) {
                case XML: {
                    return "application/xml";
                }
                case HTML: {
                    return "application/html";
                }
                case JSON: {
                    return "application/json";
                }
                case SLD: {
                    return "application/vnd.ogc.sld+xml";
                }
                case SLD_1_1_0: {
                    return "application/vnd.ogc.se+xml";
                }
            }
            return null;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Purge {
        NONE,
        METADATA,
        ALL;

    }
}

