/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.geoservermanager.geowebcache;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.geoanalytics.context.GeoServerBridgeConfig;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GwcClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String service;
    private Client client;
    private GeoServerBridgeConfig geoServerBridgeConfig;
    private String geoserverEndpoint;
    private String user;
    private String password;
    private static final ObjectMapper mapper = new ObjectMapper();

    public GwcClient(GeoServerBridgeConfig geoServerBridgeConfig) {
        this.geoServerBridgeConfig = geoServerBridgeConfig;
        this.geoserverEndpoint = geoServerBridgeConfig.getGeoServerBridgeUrl();
        this.user = geoServerBridgeConfig.getGeoServerBridgeUser();
        this.password = geoServerBridgeConfig.getGeoServerBridgePassword();
        this.client = ClientBuilder.newClient();
        this.client.register((Object)HttpAuthenticationFeature.basic((String)this.user, (String)this.password));
        this.logger.debug("Initialized GwcClient");
    }

    public boolean seedGeoTIFF(String seedRequest, String layerName) {
        this.logger.info("im sending to: " + this.geoserverEndpoint + "/gwc/rest/seed/" + layerName + ".json");
        Response response = this.client.target(this.geoserverEndpoint).path("/gwc/rest/seed/" + layerName + ".json").request(new String[]{"application/json"}).post(Entity.entity((Object)seedRequest, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        this.logger.debug("Send seed request with response:" + response.getStatus());
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        return true;
    }

    public boolean deleteCachedLayer(String layerName) {
        Response response = (Response)this.client.target(this.geoserverEndpoint).path("/gwc/rest/layers/" + layerName + ".json").request(new String[]{"application/json"}).delete(Response.class);
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        return true;
    }

    public Response getCachedLayers() {
        Response response = (Response)this.client.target(this.geoserverEndpoint).path("/gwc/rest/layers.xml").request(new String[]{"application/xml"}).get(Response.class);
        if (response.getStatus() == 200) {
            return response;
        }
        throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
    }
}

