/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.project.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.dao.ProjectDao;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import gr.cite.geoanalytics.dataaccess.entities.workflow.Workflow;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectDaoImpl
extends JpaDao<Project, UUID>
implements ProjectDao {
    private static final Logger log = LoggerFactory.getLogger(ProjectDaoImpl.class);

    @Override
    public List<Project> getActiveProjects() {
        return this.entityManager.createQuery("from project p where p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), Project.class).getResultList();
    }

    @Override
    public List<Project> getArchivedProjects() {
        return this.entityManager.createQuery("from project p where p.status=" + Project.ProjectStatus.ARCHIVE.statusCode(), Project.class).getResultList();
    }

    @Override
    public List<Project> getDeletedProjects() {
        return this.entityManager.createQuery("from project p where p.status=" + Project.ProjectStatus.DELETED.statusCode(), Project.class).getResultList();
    }

    @Override
    public List<Project> findByCreator(Principal principal) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.creator = :principal", Project.class);
        query.setParameter("principal", (Object)principal);
        return query.getResultList();
    }

    @Override
    public List<Project> findActiveByNameAndCreator(String name, Principal creator) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.name = :name and p.creator = :creator and p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), Project.class);
        query.setParameter("name", (Object)name);
        query.setParameter("creator", (Object)creator);
        return query.getResultList();
    }

    @Override
    public List<Project> findActiveByNameAndCreatorAndTenant(String name, Principal creator, String tenant) {
        TypedQuery query = this.entityManager.createQuery("FROM Project p WHERE p.name = :name AND p.tenant.name = :tenant AND p.creator = :creator AND p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), Project.class);
        query.setParameter("name", (Object)name);
        query.setParameter("tenant", (Object)tenant);
        query.setParameter("creator", (Object)creator);
        return query.getResultList();
    }

    @Override
    public List<Project> findByNameAndCreator(String name, Principal creator) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.name = :name and p.creator = :creator", Project.class);
        query.setParameter("name", (Object)name);
        query.setParameter("creator", (Object)creator);
        return query.getResultList();
    }

    @Override
    public List<Project> findByNameAndCreatorAndTenant(String name, Principal creator, String tenant) {
        TypedQuery query = this.entityManager.createQuery("FROM Project p WHERE p.name = :name AND p.tenant.name = :tenant AND p.creator = :creator", Project.class);
        query.setParameter("name", (Object)name);
        query.setParameter("tenant", (Object)tenant);
        query.setParameter("creator", (Object)creator);
        return query.getResultList();
    }

    @Override
    public List<Project> findByName(String projectName) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.name = :name", Project.class);
        query.setParameter("name", (Object)projectName);
        return query.getResultList();
    }

    @Override
    public List<Project> findByNameAndTenant(String projectName, String tenant) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.name = :name AND p.tenant.name = :tenant", Project.class);
        query.setParameter("name", (Object)projectName);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public List<Project> findActiveByCreator(Principal creator) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.creator = :creator and p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), Project.class);
        query.setParameter("creator", (Object)creator);
        return query.getResultList();
    }

    @Override
    public List<Project> findActiveByCreatorAndTenant(Principal creator, String tenantName) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.creator = :creator and p.tenant.name = :tenant and p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), Project.class);
        query.setParameter("creator", (Object)creator);
        query.setParameter("tenant", (Object)tenantName);
        return query.getResultList();
    }

    @Override
    public List<Project> findByTenant(Tenant tenant) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.tenant = :tenant", Project.class);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public List<Project> findByActiveTenant(Tenant tenant) {
        TypedQuery query = this.entityManager.createQuery("from Project p where p.tenant = :tenant and p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), Project.class);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public List<String> listProjects() {
        return this.entityManager.createQuery("select p.name from project p", String.class).getResultList();
    }

    @Override
    public List<String> listActiveProjects() {
        return this.entityManager.createQuery("select p.name from project p where p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), String.class).getResultList();
    }

    @Override
    public List<String> listProjectsOfCreator(Principal creator) {
        TypedQuery query = this.entityManager.createQuery("select p.name from Project p where p.creator = :creator", String.class);
        query.setParameter("creator", (Object)creator);
        return query.getResultList();
    }

    @Override
    public List<String> listActiveProjectsOfCreator(Principal creator) {
        TypedQuery query = this.entityManager.createQuery("select p.name from Project p where p.creator = :creator and p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), String.class);
        query.setParameter("principal", (Object)creator);
        return query.getResultList();
    }

    @Override
    public List<String> listProjectsOfTenant(Tenant tenant) {
        TypedQuery query = this.entityManager.createQuery("select p.name from Project p where p.tenant = :tenant", String.class);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public List<String> listActiveProjectsOfTenant(Tenant tenant) {
        TypedQuery query = this.entityManager.createQuery("select p.name from Project p where p.tenant = :tenant and p.status=" + Project.ProjectStatus.ACTIVE.statusCode(), String.class);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public List<Project> searchProjects(List<String> terms) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("from Project p");
        if (!terms.isEmpty()) {
            queryB.append(" where p.status=" + Project.ProjectStatus.ACTIVE.statusCode() + " and (");
        }
        int j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            queryB.append("lower(p.name) like :term" + j);
            queryB.append(" or lower(p.description) like :term" + ++j);
            ++j;
            if (i >= terms.size() - 1) continue;
            queryB.append(" or ");
        }
        queryB.append(")");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Project.class);
        j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            String lower = terms.get(i).toLowerCase();
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
        }
        result = query.getResultList();
        log.debug("Active projects by name/description pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Project p : result) {
                log.debug("Project (" + p.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Project> searchProjectsOfCreator(List<String> terms, Principal creator) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("from Project p");
        if (!terms.isEmpty()) {
            queryB.append(" where p.creator = :creator and p.status=" + Project.ProjectStatus.ACTIVE.statusCode() + " and (");
        }
        int j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            queryB.append("lower(p.name) like :term" + j);
            queryB.append(" or lower(p.description) like :term" + ++j);
            ++j;
            if (i >= terms.size() - 1) continue;
            queryB.append(" or ");
        }
        queryB.append(")");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Project.class);
        query.setParameter("creator", (Object)creator);
        j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            String lower = terms.get(i).toLowerCase();
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
        }
        result = query.getResultList();
        log.debug("Active projects of creator " + creator.getId() + " by name/description pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Project p : result) {
                log.debug("Project (" + p.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Project> searchProjectsOfTenant(List<String> terms, Tenant tenant) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("from Project p");
        if (!terms.isEmpty()) {
            queryB.append(" where p.tenant = :tenant and p.status=" + Project.ProjectStatus.ACTIVE.statusCode() + " and (");
        }
        int j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            queryB.append("lower(p.name) like :term" + j);
            queryB.append(" or lower(p.description) like :term" + ++j);
            ++j;
            if (i >= terms.size() - 1) continue;
            queryB.append(" or ");
        }
        queryB.append(")");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Project.class);
        query.setParameter("tenant", (Object)tenant);
        j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            String lower = terms.get(i).toLowerCase();
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
        }
        result = query.getResultList();
        log.debug("Active projects of tenant " + tenant.getId() + " by name/description pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Project p : result) {
                log.debug("Project (" + p.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Workflow> getWorkflowsOfProject(Project p) {
        TypedQuery query = this.entityManager.createQuery("from Workflow w where w.project = :p", Workflow.class);
        query.setParameter("p", (Object)p);
        return query.getResultList();
    }

    @Override
    public Set<String> findClientOfPrincipal(Principal principal) {
        TypedQuery query = this.entityManager.createQuery("select distinct p.client from Project p where p.creator = :principal", String.class);
        query.setParameter("principal", (Object)principal);
        List result = query.getResultList();
        return new HashSet<String>(result);
    }

    @Override
    public Project loadDetails(Project p) {
        p.getCreator().getName();
        if (p.getTenant() != null) {
            p.getTenant().getId();
        }
        return p;
    }
}

