/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.layer.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.geocode.TaxonomyLayer;
import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import gr.cite.geoanalytics.dataaccess.entities.layer.dao.TaxonomyLayerDao;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyLayerDaoImpl
extends JpaDao<TaxonomyLayer, UUID>
implements TaxonomyLayerDao {
    public static Logger log = LoggerFactory.getLogger(TaxonomyLayerDaoImpl.class);

    @Override
    public TaxonomyLayer loadDetails(TaxonomyLayer t) {
        return t;
    }

    @Override
    public List<Layer> findLayerByNameAndGeocodeSystem(String layerName, String taxonomyName) {
        List layers = null;
        log.debug("Searching for layer by name: " + layerName + " and taxonomy: " + taxonomyName);
        TypedQuery query = this.entityManager.createQuery("from TaxonomyLayer tl where tl.taxonomy.name = :taxonomyName and tl.layer.name = :layerName", Layer.class);
        query.setParameter("layerName", (Object)layerName);
        query.setParameter("taxonomyName", (Object)taxonomyName);
        layers = query.getResultList();
        return layers;
    }

    @Override
    public List<Layer> findLayerByNameAndGeocodeSystems(String layerName, List<GeocodeSystem> taxonomies) {
        log.debug("Fetching layer by name: " + layerName + " and taxonomies :" + taxonomies.toString());
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from TaxonomyLayer tl where tl.layer.name = :layerName and tl.taxonomy in (:taxonomies)", Layer.class);
        query.setParameter("layerName", (Object)layerName);
        query.setParameter("taxonomies", taxonomies);
        result = query.getResultList();
        log.debug("Taxonomies that we searched in:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Layer layer : result) {
                log.debug("Layer (" + layer.getName() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Layer> findByGeocodeSystem(GeocodeSystem taxonomy) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select layer from TaxonomyLayer tl where tl.taxonomy = :taxonomy", Layer.class);
        query.setParameter("taxonomy", (Object)taxonomy);
        result = query.getResultList();
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            log.debug("Found " + result.size() + " layers for taxonomy: " + taxonomy.toString());
        }
        return result;
    }

    @Override
    public List<Layer> findByLayerNameAndGeocodeSystem(String layerName, GeocodeSystem taxonomy) {
        log.debug("Fetching layers by layerName: " + layerName + " and taxonomy: " + taxonomy.toString());
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select layer from TaxonomyLayer tl where tl.name = :layerName and tl.taxonomy = :taxonomy", Layer.class);
        query.setParameter("layerName", (Object)layerName);
        query.setParameter("taxonomy", (Object)taxonomy);
        result = query.getResultList();
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            log.debug("Found: " + result.size() + " results for " + layerName + " and taxonomy: " + taxonomy.toString());
        }
        return result;
    }

    @Override
    public List<Layer> findAllLayersByGeocodeSystems(List<GeocodeSystem> taxonomies) {
        log.debug("Fetching layer by taxonomies :" + taxonomies.toString());
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from TaxonomyLayer tl where tl.taxonomy in (:taxonomies)", Layer.class);
        query.setParameter("taxonomies", taxonomies);
        result = query.getResultList();
        log.debug("Got " + result.size() + " layers results for given taxonomies: " + taxonomies.stream().map(GeocodeSystem::getName).collect(Collectors.toList()));
        return result;
    }

    @Override
    public List<GeocodeSystem> findTaxonomiesOfLayer(Layer layer) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select taxonomy from TaxonomyLayer tl where tl.layer = :layer", GeocodeSystem.class);
        query.setParameter("layer", (Object)layer);
        result = query.getResultList();
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            log.debug("Found " + result.size() + " taxonomies for layer: " + result.toString());
        }
        return result;
    }
}

