/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.security.principal.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.ActiveStatus;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.principal.PrincipalMembership;
import gr.cite.geoanalytics.dataaccess.entities.security.principal.dao.PrincipalMembershipDao;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository
public class PrincipalMembershipDaoImpl
extends JpaDao<PrincipalMembership, UUID>
implements PrincipalMembershipDao {
    @Override
    public List<Principal> findRolesByPrincipal(Principal principal) {
        List result = null;
        StringBuilder queryB = new StringBuilder("from PrincipalMembership pm where pm.member = :p");
        queryB.append(" and pm.member.isActive = :active");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), PrincipalMembership.class);
        query.setParameter("p", (Object)principal);
        query.setParameter("active", (Object)ActiveStatus.ACTIVE.code());
        result = query.getResultList();
        ArrayList<Principal> roles = new ArrayList<Principal>();
        for (PrincipalMembership pm : result) {
            roles.add(pm.getGroup());
        }
        return roles;
    }

    @Override
    public List<PrincipalMembership> findPrincipalMembershipByUser(Principal principal) {
        List result = null;
        StringBuilder queryB = new StringBuilder("from PrincipalMembership pm where pm.member = :p");
        queryB.append(" and pm.member.isActive = :active");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), PrincipalMembership.class);
        query.setParameter("p", (Object)principal);
        query.setParameter("active", (Object)ActiveStatus.ACTIVE.code());
        result = query.getResultList();
        if (result == null) {
            return new ArrayList<PrincipalMembership>();
        }
        return result;
    }

    @Override
    public PrincipalMembership findPrincipalMembershipByPrincipalAndGroup(Principal principal, Principal group) {
        PrincipalMembership result = null;
        StringBuilder queryB = new StringBuilder("FROM PrincipalMembership pm WHERE pm.member = :p");
        queryB.append(" AND pm.group = :group");
        queryB.append(" AND pm.member.isActive = :active");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), PrincipalMembership.class);
        query.setParameter("p", (Object)principal);
        query.setParameter("group", (Object)group);
        query.setParameter("active", (Object)ActiveStatus.ACTIVE.code());
        result = (PrincipalMembership)query.getSingleResult();
        return result;
    }

    @Override
    public List<String> listPrincipalNamesOfProjectGroupByNameAndTenant(String tenant, String groupName) {
        ArrayList principalNames = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("SELECT pm.member.name FROM PrincipalMembership pm");
        queryB.append(" WHERE pm.group.name = :groupName");
        queryB.append(" AND pm.group.tenant.name = :tenant");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), String.class);
        query.setParameter("tenant", (Object)tenant);
        query.setParameter("groupName", (Object)groupName);
        principalNames = query.getResultList();
        if (principalNames == null) {
            principalNames = new ArrayList();
        }
        return principalNames;
    }

    @Override
    public PrincipalMembership loadDetails(PrincipalMembership pm) {
        pm.getGroup().getName();
        pm.getMember().getName();
        return pm;
    }

    @Override
    public void deletePrincipalGroupMembers(Principal projectGroup) {
        StringBuilder queryB = new StringBuilder("delete from PrincipalMembership pm where pm.group = :projectGroup");
        Query query = this.entityManager.createQuery(queryB.toString());
        query.setParameter("projectGroup", (Object)projectGroup);
        query.executeUpdate();
    }
}

