package gr.cite.geoanalytics.dataaccess.entities.project.dao;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import gr.cite.geoanalytics.dataaccess.dao.Dao;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import gr.cite.geoanalytics.dataaccess.entities.workflow.Workflow;

public interface ProjectDao extends Dao<Project, UUID> {
	public List<Project> getActiveProjects();
	public List<Project> getArchivedProjects();
	public List<Project> getDeletedProjects();
	
	public List<Project> findByCreator(Principal principal);
	public List<Project> findActiveByCreator(Principal principal);
	public List<Project> findActiveByCreatorAndTenant(Principal creator, String tenantName);
	
	public List<Project> findByNameAndCreator(String name, Principal principal);
	public List<Project> findActiveByNameAndCreator(String name, Principal principal);
	
	public List<Project> findByTenant(Tenant tenant);
	public List<Project> findByActiveTenant(Tenant tenant);
	
	public List<String> listProjects();
	public List<String> listProjectsOfCreator(Principal principal);
	public List<String> listProjectsOfTenant(Tenant tenant);
	
	public List<String> listActiveProjects();
	public List<String> listActiveProjectsOfCreator(Principal principal);
	public List<String> listActiveProjectsOfTenant(Tenant tenant);
	
	public List<Project> searchProjects(List<String> terms);
	public List<Project> searchProjectsOfCreator(List<String> terms, Principal principal);	
	public List<Project> searchProjectsOfTenant(List<String> terms, Tenant tenant);
	
	public List<Workflow> getWorkflowsOfProject(Project p);
	
	public Set<String> findClientOfPrincipal(Principal principal);
	public List<Project> findByName(String projectName);
	public List<Project> findByNameAndTenant(String projectName, String tenant);
	public List<Project> findActiveByNameAndCreatorAndTenant(String name, Principal creator, String tenant);
	public List<Project> findByNameAndCreatorAndTenant(String name, Principal creator, String tenant);
}
