/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.document.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.document.dao.DocumentDao;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import gr.cite.geoanalytics.dataaccess.entities.workflow.WorkflowTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class DocumentDaoImpl
extends JpaDao<Document, UUID>
implements DocumentDao {
    private static Logger log = LoggerFactory.getLogger(DocumentDaoImpl.class);

    @Override
    public long totalSize() {
        TypedQuery query = this.entityManager.createQuery("select sum(d.size) from Document d", Long.class);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Document> findByCreatorAndCustomer(Principal principal, Tenant tenant) {
        TypedQuery query = this.entityManager.createQuery("from Document d where d.creator = :principal and d.tenant = :tenant", Document.class);
        query.setParameter("principal", (Object)principal);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public List<Document> findByCreator(Principal principal) {
        TypedQuery query = this.entityManager.createQuery("from Document d where d.creator = :principal", Document.class);
        query.setParameter("principal", (Object)principal);
        return query.getResultList();
    }

    @Override
    public List<Document> findByCustomer(Tenant tenant) {
        TypedQuery query = this.entityManager.createQuery("from Document d where d.tenant = :tenant", Document.class);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public List<UUID> listDocuments() {
        TypedQuery query = this.entityManager.createQuery("select d.id from Document d", UUID.class);
        return query.getResultList();
    }

    @Override
    public List<Document> getDocumentsOfProject(Project project) {
        TypedQuery query = this.entityManager.createQuery("select pd.document from ProjectDocument pd where pd.project = :p", Document.class);
        query.setParameter("p", (Object)project);
        return query.getResultList();
    }

    @Override
    public List<Document> getDocumentsOfShape(Shape shape) {
        TypedQuery query = this.entityManager.createQuery("select sd.document from ShapeDocument sd, GeocodeShape tts where sd.geocodeShape = tts and tts.shape = :s", Document.class);
        query.setParameter("s", (Object)shape);
        return query.getResultList();
    }

    @Override
    public Document getDocumentOfShape(Shape s, GeocodeSystem t) {
        TypedQuery query = this.entityManager.createQuery("select sd.document from ShapeDocument sd, GeocodeShape tts, Geocode tt where sd.geocodeShape = tts and tts.geocode = tt and tt.taxonomy = :t and tts.geocodeShape = :tts", Document.class);
        query.setParameter("s", (Object)s);
        query.setParameter("t", (Object)t);
        return (Document)query.getSingleResult();
    }

    @Override
    public List<Document> getDocumentsOfWorkflowTask(WorkflowTask wt) {
        TypedQuery query = this.entityManager.createQuery("select wftd.document from WorkflowTaskDocument wftd where wftd.workflowTask = :wt", Document.class);
        query.setParameter("wt", (Object)wt);
        return query.getResultList();
    }

    @Override
    public Project findProjectOfDocument(Document d) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select pd.project from ProjectDocument pd where pd.document = :d", Project.class);
        query.setParameter("d", (Object)d);
        List res = query.getResultList();
        if (res.size() > 1) {
            throw new Exception("More than one projects found for document " + d.getId());
        }
        if (res.isEmpty()) {
            return null;
        }
        return (Project)res.get(0);
    }

    @Override
    public List<WorkflowTask> findWorkflowTasksOfDocument(Project p, Document d) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select wftd.workflowTask from WorkflowTaskDocument wftd, WorkflowTask wft, Workflow w, Project p where wftd.document = :d and wft.workflow=w and w.project=:p", WorkflowTask.class);
        query.setParameter("d", (Object)d);
        query.setParameter("p", (Object)p);
        List res = query.getResultList();
        ArrayList<WorkflowTask> fil = new ArrayList<WorkflowTask>();
        HashSet<UUID> ids = new HashSet<UUID>();
        for (WorkflowTask r : res) {
            if (ids.contains(r.getId())) continue;
            fil.add(r);
            ids.add(r.getId());
        }
        return fil;
    }

    @Override
    public long countWorkflowTasksOfDocument(Project p, Document d) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select count(distinct wftd.workflowTask) from WorkflowTaskDocument wftd, WorkflowTask wft, Workflow w, Project p where wftd.document = :d and wft.workflow=w and w.project=:p", Long.class);
        query.setParameter("d", (Object)d);
        query.setParameter("p", (Object)p);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Document> searchDocuments(List<String> terms) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("from Document d");
        if (!terms.isEmpty()) {
            queryB.append(" where ");
        }
        int j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            queryB.append("lower(d.name) like :term" + j++);
            queryB.append(" or lower(d.description) like :term" + j++);
            if (i >= terms.size() - 1) continue;
            queryB.append(" or ");
        }
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Document.class);
        j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            String lower = terms.get(i).toLowerCase();
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
        }
        result = query.getResultList();
        log.debug("Documents by name/description pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Document d : result) {
                log.debug("Document (" + d.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Document> searchDocumentsOfProject(List<String> terms, Project project) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("from Document d, ProjectDocument pd");
        if (!terms.isEmpty()) {
            queryB.append(" where ");
        }
        queryB.append("pd.project = : p and pd.document=d and(");
        int j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            queryB.append("lower(d.name) like :term" + j);
            queryB.append(" or lower(d.description) like :term" + ++j);
            ++j;
            if (i >= terms.size() - 1) continue;
            queryB.append(" or ");
        }
        queryB.append(")");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Document.class);
        query.setParameter("p", (Object)project);
        j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            String lower = terms.get(i).toLowerCase();
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
        }
        result = query.getResultList();
        log.debug("Documents of project " + project.getId() + " by name/description pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Document d : result) {
                log.debug("Document (" + d.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Document> searchDocumentsOfCreator(List<String> terms, Principal creator) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("from Document d");
        if (!terms.isEmpty()) {
            queryB.append(" where ");
        }
        queryB.append("pd.creator = :creator and(");
        int j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            queryB.append("lower(d.name) like :term" + j);
            queryB.append(" or lower(d.description) like :term" + ++j);
            ++j;
            if (i >= terms.size() - 1) continue;
            queryB.append(" or ");
        }
        queryB.append(")");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Document.class);
        query.setParameter("creator", (Object)creator);
        j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            String lower = terms.get(i).toLowerCase();
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
            query.setParameter("term" + j++, (Object)("%" + lower + "%"));
        }
        result = query.getResultList();
        log.debug("Documents of principals " + creator.getId() + " by name/description pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Document d : result) {
                log.debug("Document (" + d.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public Document loadDetails(Document doc) {
        doc.getCreator().getName();
        if (doc.getTenant() != null) {
            doc.getTenant().getId();
        }
        return doc;
    }
}

