/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.tenant;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.annotation.Annotation;
import gr.cite.geoanalytics.dataaccess.entities.auditing.Auditing;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.tenant.TenantActivation;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"Tenant\"")
public class Tenant
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"TEN_ID\"", nullable=false)
    private UUID id = null;
    @Column(name="\"TEN_Name\"", nullable=false, length=100)
    private String name = null;
    @Column(name="\"TEN_Code\"", nullable=false, length=20)
    private String code = null;
    @Column(name="\"TEN_EmailAddress\"", length=250)
    private String email = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"TEN_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"TEN_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"TEN_Creator\"", nullable=false)
    private Principal creator = null;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tenant", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Principal> principals = new HashSet<Principal>(0);
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tenant", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Annotation> annotations = new HashSet<Annotation>(0);
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tenant", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Auditing> auditings = new HashSet<Auditing>(0);
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tenant", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Document> documents = new HashSet<Document>(0);
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tenant", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Project> projects = new HashSet<Project>(0);
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tenant", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<TenantActivation> tenantActivations = new HashSet<TenantActivation>(0);

    public Set<Principal> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Set<Principal> principals) {
        this.principals = principals;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public Set<Auditing> getAuditings() {
        return this.auditings;
    }

    public void setAuditings(Set<Auditing> auditings) {
        this.auditings = auditings;
    }

    public Set<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(Set<Document> documents) {
        this.documents = documents;
    }

    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    public Set<TenantActivation> getTenantActivations() {
        return this.tenantActivations;
    }

    public void setTenantActivations(Set<TenantActivation> tanantActivations) {
        this.tenantActivations = tanantActivations;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String eMail) {
        this.email = eMail;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public String toString() {
        return "Customer(id=" + this.getId() + " name=" + this.getName() + " code=" + this.getCode() + " eMailAddress=" + this.getEmail() + " creation=" + this.getCreationDate() + "lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null);
    }
}

