package gr.cite.geoanalytics.dataaccess.entities.project;

import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.principal.PrincipalProject;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;

import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "\"Project\"")
public class Project implements gr.cite.geoanalytics.dataaccess.entities.Entity, Identifiable, Stampable
{
	
	public enum ProjectStatus
	{
		DELETED((short)-1), ARCHIVE((short)0), ACTIVE((short)2);
		
		private final short statusCode;
		
		private static final Map<Short,ProjectStatus> lookup  = new HashMap<Short,ProjectStatus>();
		 
		static {
		      for(ProjectStatus s : EnumSet.allOf(ProjectStatus.class))
		           lookup.put(s.statusCode(), s);
		 }
		
		ProjectStatus(short statusCode)
		{
			this.statusCode = statusCode;
		}
		
		public short statusCode() { return statusCode; }
	
		public static ProjectStatus fromStatusCode(short statusCode)
		{
			return lookup.get(statusCode);
		}
	};
	
	@Id
	@Type(type="org.hibernate.type.PostgresUUIDType") //DEPWARN dependency to Hibernate and PostgreSQL
	@Column(name = "\"PRJ_ID\"", nullable = false)
	private UUID id = null;

	@ManyToOne
	@JoinColumn(name = "\"PRJ_Tenant\"", nullable = false)
	private Tenant tenant = null;

	@Column(name = "\"PRJ_Name\"", nullable = false, length = 250)
	private String name = null;

	@Lob
	@Type(type = "org.hibernate.type.TextType") //DEPWARN dependency to Hibernate and PostgreSQL (workaround for text~~bigint hibernate bug)
	@Basic(fetch = FetchType.LAZY)
	@Column(name = "\"PRJ_Description\"", nullable = true)
	private String description = null;
	
//	@Column(name="\"PRJ_Client\"", nullable = false, length = 250)
	@Column(name="\"PRJ_Extent\"", nullable = false, length = 250)
	private String client = null;
	
	@Column(name = "\"PRJ_Status\"", nullable = false)
	private short status = 1;

	@Column(name = "\"PRJ_IsTemplate\"", nullable = false)
	private Short isTemplate = 0;

	@Column(name = "\"PRJ_Shape\"", nullable = true)
	@Type(type="org.hibernate.type.PostgresUUIDType")
	//TODO check if should be non-nullable foreign key
	private UUID shape = null;

	@ManyToOne
	@JoinColumn(name = "\"PRJ_Creator\"", nullable = false)
	private Principal creator = null;

	@OneToMany(fetch = FetchType.LAZY, mappedBy = "project", cascade=CascadeType.ALL)
	private Set<PrincipalProject> principalProject = new HashSet<PrincipalProject>();

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "\"PRJ_CreationDate\"", nullable = false)
	private Date creationDate = null;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "\"PRJ_LastUpdate\"", nullable = false)
	private Date lastUpdate = null;

	public Set<PrincipalProject> getPrincipalProject() {
		return principalProject;
	}

	public void setPrincipalProject(Set<PrincipalProject> principalProject) {
		this.principalProject = principalProject;
	}

	public Project() {
	}

	public UUID getId() {
		return id;
	}

	public void setId(UUID id) {
		this.id = id;
	}

	public Tenant getTenant() {
		return tenant;
	}

	public void setTenant(Tenant tenant) {
		this.tenant = tenant;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public String getClient() {
		return client;
	}
	
	public void setClient(String client) {
		this.client = client;
	}

	public ProjectStatus getStatus() {
		return ProjectStatus.fromStatusCode(status);
	}

	public void setStatus(ProjectStatus status) {
		this.status = status.statusCode();
	}

	public boolean getIsTemplate() {
		if(isTemplate == null) return false;
		return isTemplate == 0 ? false : true;
	}

	public void setIsTemplate(boolean isTemplate) {
		this.isTemplate = (short)(isTemplate == true ? 1 : 0);
	}

	public UUID getShape() {
		return shape;
	}

	public void setShape(UUID shape) {
		this.shape = shape;
	}

	public Principal getCreator() {
		return creator;
	}

	public void setCreator(Principal creator) {
		this.creator = creator;
	}

	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	public Date getLastUpdate() {
		return lastUpdate;
	}

	public void setLastUpdate(Date lastUpdate) {
		this.lastUpdate = lastUpdate;
	}
	
	@Override
	public String toString()
	{
		return "Project(" + "id=" + getId() + " name=" + getName() + 
				" description=" + getDescription() + " status=" + getStatus() +
				" isTemplate=" + getIsTemplate() + 
				" creation=" + getCreationDate() + " lastUpdate=" + getLastUpdate() +
				" creator=" + (creator != null ? creator.getId() : null) + 
				" customer=" + (tenant != null ? tenant.getId() : null) + 
				" shape=" + (shape != null ? shape : null);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Project other = (Project) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}
	
}
