/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer;

import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlSeeAlso(value={LayerConfig.class})
public class SystemLayerConfig {
    private List<LayerConfig> layerConfigs = new ArrayList<LayerConfig>();
    @XmlTransient
    private Map<String, LayerConfig> lookup = new HashMap<String, LayerConfig>();

    public List<LayerConfig> getLayerConfigs() {
        return this.layerConfigs;
    }

    @XmlElementWrapper(name="layers")
    public void setLayerConfigs(List<LayerConfig> layerConfigs) {
        this.layerConfigs = layerConfigs;
        this.lookup = new HashMap<String, LayerConfig>();
        for (LayerConfig cfg : layerConfigs) {
            this.lookup.put(cfg.getTermId(), cfg);
        }
    }

    public LayerConfig getLayerConfig(String termId) {
        LayerConfig lcfg = this.lookup.get(termId);
        if (lcfg == null) {
            return null;
        }
        return new LayerConfig(lcfg);
    }

    public void removeLayerConfig(String termId) {
        LayerConfig tmp = new LayerConfig();
        tmp.setTermId(termId);
        this.lookup.remove(termId);
        this.layerConfigs.remove(tmp);
    }

    public void setLayerConfig(LayerConfig cfg) {
        this.lookup.put(cfg.getTermId(), cfg);
        int pos = this.layerConfigs.indexOf(cfg);
        if (pos != -1) {
            this.layerConfigs.remove(pos);
        }
        this.layerConfigs.add(pos != -1 ? pos : this.layerConfigs.size(), cfg);
    }
}

