/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.layer;

import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;

public enum DataSource {
    PostGIS("PostGIS"),
    GeoTIFF("GeoTIFF");

    private final String type;

    private DataSource(String type) {
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    public static boolean isPostGIS(Layer layer) {
        return PostGIS.equals((Object)layer.getDataSource());
    }

    public static boolean isGeoTIFF(Layer layer) {
        return GeoTIFF.equals((Object)layer.getDataSource());
    }

    public static boolean isPostGIS(DataSource dataSource) {
        return PostGIS.equals((Object)dataSource);
    }

    public static boolean isGeoTIFF(DataSource dataSource) {
        return GeoTIFF.equals((Object)dataSource);
    }

    public static boolean isVector(DataSource dataSource) {
        return DataSource.isPostGIS(dataSource);
    }

    public static boolean isRaster(DataSource dataSource) {
        return DataSource.isGeoTIFF(dataSource);
    }
}

