package gr.cite.geoanalytics.dataaccess.entities.project;

import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Index;

@Entity
@IdClass(ProjectDocumentPK.class)
@Table(name = "\"ProjectDocument\"")
public class ProjectDocument implements gr.cite.geoanalytics.dataaccess.entities.Entity, Stampable {
	
	@Id
	@OneToOne
	@JoinColumn(name = "\"PD_Project\"", nullable = false)
	private Project project = null;

	@Id
	@ManyToOne
	@JoinColumn(name = "\"PD_Document\"", nullable = false)
	private Document document = null;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "\"PD_CreationDate\"", nullable = false)
	private Date creationDate = null;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "\"PD_LastUpdate\"", nullable = false)
	private Date lastUpdate = null;

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "\"PD_Creator\"", nullable = false)
	private Principal creator = null;

	public ProjectDocument() {
	}

	public Project getProject() {
		return project;
	}

	public void setProject(Project project) {
		this.project = project;
	}

	public Document getDocument() {
		return document;
	}

	public void setDocument(Document document) {
		this.document = document;
	}

	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(Date creation) {
		this.creationDate = creation;
	}

	public Date getLastUpdate() {
		return lastUpdate;
	}

	public void setLastUpdate(Date lastUpdate) {
		this.lastUpdate = lastUpdate;
	}

	public Principal getCreator() {
		return creator;
	}

	public void setCreator(Principal creator) {
		this.creator = creator;
	}
	
	@Override
	public String toString()
	{
		return "ProjectDocument(" + "project=" + getProject().getId() + " name=" + getDocument().getId() + 
				" creation=" + getCreationDate() + " lastUpdate=" + getLastUpdate() +
				" creator=" + (creator != null ? creator.getId() : null);
	}

}
