/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classifier;

import it.geosolutions.jaiext.classifier.ColorMapTransformElement;
import it.geosolutions.jaiext.classifier.ConstantColorMapElement;
import it.geosolutions.jaiext.piecewise.DefaultLinearPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.MathTransformation;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.range.Range;
import java.awt.Color;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearColorMapElement
extends DefaultLinearPiecewiseTransform1DElement
implements PiecewiseTransform1DElement,
ColorMapTransformElement {
    private static final long serialVersionUID = 2216106857184603629L;
    private Color[] colors;
    private int hashCode = -1;

    public static LinearColorMapElement create(CharSequence name, Color[] colors, Range valueRange, Range sampleRange) throws IllegalArgumentException {
        return new LinearColorMapElement(name, colors, valueRange, sampleRange);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, Range inRange, int outVal) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, inRange, outVal);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, short value, int sample) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, value, sample);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, int value, int sample) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, value, sample);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, float value, int sample) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, value, sample);
    }

    public static LinearColorMapElement create(CharSequence name, Color color, double value, int sample) throws IllegalArgumentException {
        return new ConstantColorMapElement(name, color, value, sample);
    }

    LinearColorMapElement(CharSequence name, Color[] colors, Range valueRange, Range sampleRange) throws IllegalArgumentException {
        super(name, valueRange, LinearColorMapElement.checkSampleRange(sampleRange));
        this.colors = new Color[colors.length];
        System.arraycopy(colors, 0, this.colors, 0, colors.length);
    }

    private static Range checkSampleRange(Range numberRange) {
        if (numberRange == null) {
            throw new IllegalArgumentException();
        }
        Class<? extends Number> elementClass = numberRange.getDataType().getClassValue();
        if (!(elementClass.equals(Integer.class) || elementClass.equals(Byte.class) || elementClass.equals(Short.class))) {
            throw new IllegalArgumentException("The following Range cannot be used for mapping value to colours");
        }
        if (numberRange.getMin().intValue() < 0 || numberRange.getMax().intValue() > 65535) {
            throw new IndexOutOfBoundsException("Input Range bounds are outside the available color representation");
        }
        return numberRange;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LinearColorMapElement)) {
            return false;
        }
        LinearColorMapElement that = (LinearColorMapElement)object;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (Arrays.equals(this.getColors(), that.getColors())) {
            return true;
        }
        return super.equals(that);
    }

    @Override
    public Color[] getColors() {
        return (Color[])this.colors.clone();
    }

    MathTransformation accessTransform() {
        return this.getTransform();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append("\n").append("colors=");
        for (int i = 0; this.colors != null && i < this.colors.length; ++i) {
            buffer.append(this.colors[i]);
            if (i + 1 >= this.colors.length) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return LinearColorMapElement.class;
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = PiecewiseUtilities.hash(this.colors, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(super.hashCode(), this.hashCode);
        return this.hashCode;
    }
}

