/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Graphic;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.picocontainer.MutablePicoContainer;

public class SLDPointSymbolizerBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDPointSymbolizerBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    @Override
    public QName getTarget() {
        return SLD.POINTSYMBOLIZER;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return PointSymbolizer.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        PointSymbolizer ps = this.styleFactory.createPointSymbolizer();
        if (node.hasChild("Geometry")) {
            Expression geometry = (Expression)node.getChildValue("Geometry");
            if (geometry instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)geometry;
                ps.setGeometryPropertyName(propertyName.getPropertyName());
            } else {
                ps.setGeometry(geometry);
            }
        }
        if (node.hasChild("Graphic")) {
            ps.setGraphic((Graphic)node.getChildValue("Graphic"));
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            ps.getOptions().put(param.getName(), param.getExpression().evaluate(null, String.class));
        }
        return ps;
    }
}

