/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import javax.xml.namespace.QName;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.DirectPosition3D;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionTypeBinding
extends AbstractComplexBinding {
    GeometryFactory factory;

    public DirectPositionTypeBinding(GeometryFactory factory) {
        this.factory = factory;
    }

    @Override
    public QName getTarget() {
        return GML.DirectPositionType;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return CoordinateSequence.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        Double[] position = (Double[])value;
        DirectPosition dp = null;
        if (position.length < 2) {
            dp = crs != null ? new DirectPosition1D(crs) : new DirectPosition1D();
            dp.setOrdinate(0, position[0]);
        } else if (position.length < 3) {
            dp = crs != null ? new DirectPosition2D(crs) : new DirectPosition2D();
            dp.setOrdinate(0, position[0]);
            dp.setOrdinate(1, position[1]);
        } else {
            dp = crs != null ? new DirectPosition3D(crs) : new DirectPosition3D();
            dp.setOrdinate(0, position[0]);
            dp.setOrdinate(1, position[1]);
            dp.setOrdinate(2, position[2]);
        }
        return dp;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        CoordinateSequence cs = (CoordinateSequence)object;
        StringBuffer sb = new StringBuffer();
        if (cs.size() >= 1) {
            int dim = cs.getDimension();
            for (int d = 0; d < dim; ++d) {
                double v = cs.getOrdinate(0, d);
                if (Double.isNaN(v) && d > 1) continue;
                sb.append(String.valueOf(v)).append(" ");
            }
            if (dim > 0) {
                sb.setLength(sb.length() - 1);
            }
        }
        value.appendChild(document.createTextNode(sb.toString()));
        return value;
    }
}

