/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map.event;

import java.util.EventObject;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapLayerEvent;

public class MapLayerListEvent
extends EventObject {
    private MapLayer mapLayer;
    private Layer layer;
    private int fromIndex;
    private int toIndex;
    private MapLayerEvent mapLayerEvent;

    public MapLayerListEvent(MapContext source, MapLayer layer, int fromIndex, int toIndex) {
        super(source);
        this.mapLayer = layer;
        this.layer = layer == null ? null : layer.toLayer();
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    public MapLayerListEvent(MapContext source, MapLayer layer, int position) {
        super(source);
        this.mapLayer = layer;
        this.layer = layer == null ? null : layer.toLayer();
        this.fromIndex = position;
        this.toIndex = position;
    }

    public MapLayerListEvent(MapContext source, MapLayer layer, int position, MapLayerEvent mapLayerEvent) {
        this(source, layer, position);
        this.mapLayerEvent = mapLayerEvent;
    }

    public MapLayerListEvent(MapContent map, Layer element, int index) {
        super(map);
        this.layer = element;
        this.mapLayer = element == null ? null : new DefaultMapLayer(element);
        this.fromIndex = index;
        this.toIndex = index;
    }

    public MapLayerListEvent(MapContent map, Layer element, int fromIndex, int toIndex) {
        super(map);
        this.layer = element;
        this.mapLayer = element == null ? null : new DefaultMapLayer(element);
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    public MapLayerListEvent(MapContent map, Layer element, int index, MapLayerEvent mapLayerEvent) {
        super(map);
        this.layer = element;
        this.mapLayer = element == null ? null : new DefaultMapLayer(element);
        this.fromIndex = index;
        this.toIndex = index;
        this.mapLayerEvent = mapLayerEvent;
    }

    public Layer getElement() {
        return this.layer;
    }

    public MapLayer getLayer() {
        return this.mapLayer;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getToIndex() {
        return this.toIndex;
    }

    public MapLayerEvent getMapLayerEvent() {
        return this.mapLayerEvent;
    }
}

