/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.ReadResolutionCalculator;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.EmptyIntersectionException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.PolygonExtractor;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class GridCoverageReaderHelper {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final int DEFAULT_PADDING = 10;
    private static final Logger LOGGER = Logging.getLogger(GridCoverageReaderHelper.class);
    private GridCoverage2DReader reader;
    private ReferencedEnvelope mapExtent;
    private Rectangle mapRasterArea;
    private MathTransform worldToScreen;
    private GridGeometry2D requestedGridGeometry;
    private boolean paddingRequired;
    private boolean sameCRS;

    public GridCoverageReaderHelper(GridCoverage2DReader reader, Rectangle mapRasterArea, ReferencedEnvelope mapExtent, Interpolation interpolation) throws FactoryException, IOException {
        this.reader = reader;
        this.mapExtent = mapExtent;
        this.requestedGridGeometry = new GridGeometry2D(new GridEnvelope2D(mapRasterArea), mapExtent);
        this.worldToScreen = this.requestedGridGeometry.getCRSToGrid2D();
        this.sameCRS = CRS.equalsIgnoreMetadata(mapExtent.getCoordinateReferenceSystem(), reader.getCoordinateReferenceSystem());
        boolean bl = this.paddingRequired = (!this.sameCRS || !(interpolation instanceof InterpolationNearest)) && !GridCoverageReaderHelper.isReprojectingReader(reader);
        if (this.paddingRequired) {
            GridEnvelope2D requestedGridEnvelope = new GridEnvelope2D(mapRasterArea);
            this.applyReadGutter(requestedGridEnvelope);
            try {
                this.requestedGridGeometry = new GridGeometry2D((GridEnvelope)requestedGridEnvelope, PixelInCell.CELL_CORNER, this.worldToScreen.inverse(), mapExtent.getCoordinateReferenceSystem(), null);
                this.mapExtent = ReferencedEnvelope.reference(this.requestedGridGeometry.getEnvelope2D());
                this.mapRasterArea = this.requestedGridGeometry.getGridRange2D().getBounds();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.mapExtent = mapExtent;
            this.mapRasterArea = mapRasterArea;
        }
    }

    public static boolean isReprojectingReader(GridCoverage2DReader reader) throws IOException {
        return "true".equals(reader.getMetadataValue("ReprojectingReader"));
    }

    public ReferencedEnvelope getReadEnvelope() {
        return this.mapExtent;
    }

    private void applyReadGutter(GridEnvelope2D gridRange) {
        gridRange.setBounds(gridRange.x - 10, gridRange.y - 10, gridRange.width + 20, gridRange.height + 20);
    }

    private GridGeometry2D applyReadGutter(GridGeometry2D gg) {
        MathTransform gridToCRS = gg.getGridToCRS();
        GridEnvelope2D range = new GridEnvelope2D(gg.getGridRange2D());
        this.applyReadGutter(range);
        CoordinateReferenceSystem crs = gg.getEnvelope2D().getCoordinateReferenceSystem();
        GridGeometry2D result = new GridGeometry2D((GridEnvelope)range, PixelInCell.CELL_CORNER, gridToCRS, crs, null);
        return result;
    }

    public GridCoverage2D readCoverage(GeneralParameterValue[] params) throws IOException {
        return this.readSingleCoverage(params, this.requestedGridGeometry);
    }

    public List<GridCoverage2D> readCoverages(GeneralParameterValue[] readParams, ProjectionHandler handler) throws IOException, FactoryException, TransformException {
        return this.readCoverages(readParams, handler, new GridCoverageFactory());
    }

    public List<GridCoverage2D> readCoverages(GeneralParameterValue[] readParams, ProjectionHandler handler, GridCoverageFactory gridCoverageFactory) throws IOException, FactoryException, TransformException {
        if (handler == null) {
            GridCoverage2D readCoverage = this.readCoverage(readParams);
            GridCoverage2D cropped = this.cropCoverageOnRequestedEnvelope(readCoverage);
            if (cropped == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(cropped);
        }
        ArrayList<GridCoverage2D> coverages = new ArrayList<GridCoverage2D>();
        List<ReferencedEnvelope> queryEnvelopes = handler.getQueryEnvelopes();
        for (ReferencedEnvelope envelope : queryEnvelopes) {
            List<GridCoverage2D> readCoverages = this.readCoverageInEnvelope(envelope, readParams, handler, this.paddingRequired);
            if (readCoverages == null) continue;
            coverages.addAll(readCoverages);
        }
        SingleCRS readerCRS = CRS.getHorizontalCRS(this.reader.getCoordinateReferenceSystem());
        if (readerCRS instanceof GeographicCRS) {
            int lonAxis;
            ReferencedEnvelope readerEnvelope = ReferencedEnvelope.reference(this.reader.getOriginalEnvelope());
            boolean northEast = CRS.getAxisOrder(readerCRS) == CRS.AxisOrder.NORTH_EAST;
            int n = lonAxis = northEast ? 1 : 0;
            if (readerEnvelope.getMaximum(lonAxis) > 180.0) {
                double ty;
                double tx;
                ReferencedEnvelope excess;
                if (northEast) {
                    excess = new ReferencedEnvelope(-90.0, 90.0, 180.0, 360.0, readerCRS);
                    tx = 0.0;
                    ty = 360.0;
                } else {
                    excess = new ReferencedEnvelope(180.0, 360.0, -90.0, 90.0, readerCRS);
                    tx = 360.0;
                    ty = 0.0;
                }
                for (ReferencedEnvelope envelope : queryEnvelopes) {
                    List<GridCoverage2D> readCoverages;
                    ReferencedEnvelope translated = new ReferencedEnvelope(envelope);
                    translated.translate(tx, ty);
                    ReferencedEnvelope intersection = new ReferencedEnvelope(translated.intersection(excess), translated.getCoordinateReferenceSystem());
                    boolean isEmptyEnvelope = intersection == null || intersection.isNull() || intersection.getHeight() == 0.0 || intersection.getWidth() == 0.0;
                    if (isEmptyEnvelope || (readCoverages = this.readCoverageInEnvelope(intersection, readParams, handler, false)) == null) continue;
                    for (GridCoverage2D gc : readCoverages) {
                        GridCoverage2D displaced = GridCoverageRendererUtilities.displace(gc, -tx, -ty, gridCoverageFactory);
                        coverages.add(displaced);
                    }
                }
            }
        }
        return coverages;
    }

    private GridCoverage2D cropCoverageOnRequestedEnvelope(GridCoverage2D readCoverage) {
        if (readCoverage == null) {
            return null;
        }
        try {
            ReferencedEnvelope requested = ReferencedEnvelope.reference(this.requestedGridGeometry.getEnvelope());
            ReferencedEnvelope requestedNativeCRS = requested.transform(readCoverage.getCoordinateReferenceSystem(), true);
            ReferencedEnvelope coverageEnvelope = ReferencedEnvelope.reference(readCoverage.getEnvelope());
            ReferencedEnvelope cropEnvelope = new ReferencedEnvelope(requestedNativeCRS.intersection(coverageEnvelope), readCoverage.getCoordinateReferenceSystem());
            if (this.isNotEmpty(cropEnvelope)) {
                GridCoverage2D cropCoverage = this.cropCoverage(readCoverage, requestedNativeCRS);
                return cropCoverage;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to crop coverage on the requested area, using the original one", e);
            return readCoverage;
        }
    }

    List<GridCoverage2D> readCoverageInEnvelope(ReferencedEnvelope envelope, GeneralParameterValue[] readParams, ProjectionHandler handler, boolean paddingRequired) throws TransformException, FactoryException, IOException {
        GridCoverage2D coverage;
        Polygon polygon = JTS.toGeometry(envelope);
        GridGeometry2D gg = new GridGeometry2D(new GridEnvelope2D(this.mapRasterArea), this.mapExtent);
        CoordinateReferenceSystem readerCRS = this.reader.getCoordinateReferenceSystem();
        GridGeometry2D readingGridGeometry = this.computeReadingGeometry(gg, readerCRS, polygon, handler);
        if (readingGridGeometry == null) {
            return null;
        }
        if (paddingRequired) {
            readingGridGeometry = this.applyReadGutter(readingGridGeometry);
        }
        if ((coverage = this.readSingleCoverage(readParams, readingGridGeometry)) == null) {
            return null;
        }
        ReferencedEnvelope readingEnvelope = ReferencedEnvelope.reference(readingGridGeometry.getEnvelope2D());
        ReferencedEnvelope coverageEnvelope = ReferencedEnvelope.reference(coverage.getEnvelope2D());
        Polygon coverageFootprint = JTS.toGeometry(coverageEnvelope);
        Geometry preProcessed = handler.preProcess(coverageFootprint);
        if (preProcessed != null && !preProcessed.isEmpty()) {
            if (coverageFootprint.equals(preProcessed)) {
                if (!readingEnvelope.contains(coverageEnvelope)) {
                    ReferencedEnvelope cropEnvelope = new ReferencedEnvelope(readingEnvelope.intersection(coverageEnvelope), readerCRS);
                    GridCoverage2D cropped = this.cropCoverage(coverage, cropEnvelope);
                    return this.singleton(cropped);
                }
                return this.singleton(coverage);
            }
            List<Polygon> polygons = PolygonExtractor.INSTANCE.getPolygons(preProcessed);
            ArrayList<GridCoverage2D> coverages = new ArrayList<GridCoverage2D>();
            for (Polygon p : polygons) {
                ReferencedEnvelope cropEnvelope = new ReferencedEnvelope(p.getEnvelopeInternal(), readerCRS);
                cropEnvelope = new ReferencedEnvelope(cropEnvelope.intersection(coverageEnvelope), readerCRS);
                GridCoverage2D cropped = this.cropCoverage(coverage, cropEnvelope = new ReferencedEnvelope(cropEnvelope.intersection(readingEnvelope), readerCRS));
                if (cropped == null) continue;
                coverages.add(cropped);
            }
            return coverages;
        }
        return null;
    }

    private List<GridCoverage2D> singleton(GridCoverage2D coverage) {
        if (coverage == null) {
            return null;
        }
        return Collections.singletonList(coverage);
    }

    private boolean isNotEmpty(ReferencedEnvelope envelope) {
        return !envelope.isEmpty() && !envelope.isNull() && envelope.getWidth() > 0.0 && envelope.getHeight() > 0.0;
    }

    private GridCoverage2D cropCoverage(GridCoverage2D coverage, ReferencedEnvelope cropEnvelope) {
        if (this.isNotEmpty(cropEnvelope)) {
            ParameterValueGroup param = PROCESSOR.getOperation("CoverageCrop").getParameters();
            param.parameter("Source").setValue(coverage);
            param.parameter("Envelope").setValue(cropEnvelope);
            try {
                GridCoverage2D cropped = (GridCoverage2D)PROCESSOR.doOperation(param);
                return cropped;
            }
            catch (EmptyIntersectionException e) {
                return null;
            }
        }
        return null;
    }

    private GridGeometry2D computeReadingGeometry(GridGeometry2D gg, CoordinateReferenceSystem readerCRS, Polygon polygon, ProjectionHandler handler) throws TransformException, FactoryException, IOException {
        GridGeometry2D readingGridGeometry;
        MathTransform2D crsToGrid2D = gg.getCRSToGrid2D();
        MathTransform2D gridToCRS2D = gg.getGridToCRS2D();
        if (this.sameCRS) {
            Envelope gridEnvelope = JTS.transform(polygon, (MathTransform)crsToGrid2D).getEnvelopeInternal();
            GridEnvelope2D gridRange = new GridEnvelope2D((int)gridEnvelope.getMinX(), (int)gridEnvelope.getMinY(), (int)Math.round(gridEnvelope.getWidth()), (int)Math.round(gridEnvelope.getHeight()));
            readingGridGeometry = new GridGeometry2D(gridRange, (MathTransform)gridToCRS2D, readerCRS);
        } else {
            ReferencedEnvelope readEnvelope = new ReferencedEnvelope(polygon.getEnvelopeInternal(), readerCRS);
            ReferencedEnvelope reducedEnvelope = this.reduceEnvelope(readEnvelope, handler);
            if (reducedEnvelope == null) {
                return null;
            }
            ReferencedEnvelope reducedEnvelopeInRequestedCRS = reducedEnvelope.transform(this.requestedGridGeometry.getCoordinateReferenceSystem(), true);
            ReferencedEnvelope gridEnvelope = ReferencedEnvelope.reference(CRS.transform(crsToGrid2D, (org.opengis.geometry.Envelope)reducedEnvelopeInRequestedCRS));
            GridEnvelope2D readingGridRange = new GridEnvelope2D((int)gridEnvelope.getMinX(), (int)gridEnvelope.getMinY(), (int)gridEnvelope.getWidth(), (int)gridEnvelope.getHeight());
            GridGeometry2D localGridGeometry = new GridGeometry2D(readingGridRange, (MathTransform)gridToCRS2D, this.mapExtent.getCoordinateReferenceSystem());
            double[][] resolutionLevels = this.reader.getResolutionLevels();
            ReadResolutionCalculator calculator = new ReadResolutionCalculator(localGridGeometry, readerCRS, resolutionLevels != null ? resolutionLevels[0] : null);
            calculator.setAccurateResolution(this.isAccurateResolutionComputationSafe(readEnvelope));
            double[] readResolution = calculator.computeRequestedResolution(reducedEnvelope);
            int width = (int)Math.max(1L, Math.round(readEnvelope.getWidth() / Math.abs(readResolution[0])));
            int height = (int)Math.max(1L, Math.round(readEnvelope.getHeight() / Math.abs(readResolution[1])));
            GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, width, height);
            readingGridGeometry = new GridGeometry2D(gridRange, readEnvelope);
        }
        return readingGridGeometry;
    }

    boolean isAccurateResolutionComputationSafe(ReferencedEnvelope readEnvelope) throws MismatchedDimensionException, FactoryException, TransformException {
        CoordinateReferenceSystem readCRS = readEnvelope.getCoordinateReferenceSystem();
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler(new ReferencedEnvelope(readCRS), DefaultGeographicCRS.WGS84, true);
        if (handler != null) {
            if (handler.getValidAreaBounds() == null || handler instanceof WrappingProjectionHandler) {
                return true;
            }
            try {
                ReferencedEnvelope validBounds = handler.getValidAreaBounds().transform(readCRS, true);
                return validBounds.contains(readEnvelope);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private ReferencedEnvelope reduceEnvelope(ReferencedEnvelope envelope, ProjectionHandler handler) throws TransformException, FactoryException {
        Polygon polygon = JTS.toGeometry(envelope);
        Geometry geom = handler.preProcess(polygon);
        if (geom == null) {
            return null;
        }
        PolygonExtractor pe = new PolygonExtractor();
        Geometry largest = null;
        for (Polygon p : pe.getPolygons(geom)) {
            if (largest != null && !(((Polygon)largest).getArea() > p.getArea())) continue;
            largest = p;
        }
        ReferencedEnvelope reduced = new ReferencedEnvelope(largest.getEnvelopeInternal(), envelope.getCoordinateReferenceSystem());
        return reduced;
    }

    GridCoverage2D readSingleCoverage(GeneralParameterValue[] readParams, GridGeometry2D gg) throws IOException {
        ReferencedEnvelope requestedEnvelope = ReferencedEnvelope.reference(gg.getEnvelope2D());
        try {
            ReferencedEnvelope requestEnvelopeWGS84;
            ReferencedEnvelope dataEnvelopeWGS84;
            CoordinateReferenceSystem coverageCRS = this.reader.getCoordinateReferenceSystem();
            CoordinateReferenceSystem requestCRS = gg.getCoordinateReferenceSystem();
            ReferencedEnvelope coverageEnvelope = ReferencedEnvelope.reference(this.reader.getOriginalEnvelope());
            ReferencedEnvelope readEnvelope = requestedEnvelope;
            boolean sameCRS = CRS.equalsIgnoreMetadata(coverageCRS, requestCRS);
            if (sameCRS ? !coverageEnvelope.intersects(readEnvelope) : !(dataEnvelopeWGS84 = coverageEnvelope.transform(DefaultGeographicCRS.WGS84, true)).intersects(requestEnvelopeWGS84 = readEnvelope.transform(DefaultGeographicCRS.WGS84, true))) {
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to compare data and request envelopes, reading the whole mapExtent instead", e);
        }
        Parameter readGGParam = (Parameter)AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        readGGParam.setValue(new GridGeometry2D(gg));
        GridCoverage2D coverage = null;
        if (readParams != null) {
            int length = readParams.length;
            if (length > 0) {
                int i;
                String name = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
                for (i = 0; i < length && !readParams[i].getDescriptor().getName().toString().equalsIgnoreCase(name); ++i) {
                }
                if (i < length) {
                    readParams[i] = readGGParam;
                    coverage = this.reader.read(readParams);
                } else {
                    GeneralParameterValue[] readParams2 = new GeneralParameterValue[length + 1];
                    System.arraycopy(readParams, 0, readParams2, 0, length);
                    readParams2[length] = readGGParam;
                    coverage = this.reader.read(readParams2);
                }
            } else {
                coverage = this.reader.read(new GeneralParameterValue[]{readGGParam});
            }
        } else {
            coverage = gg != null ? this.reader.read(new GeneralParameterValue[]{readGGParam}) : this.reader.read(null);
        }
        return coverage;
    }
}

