/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v1_0;

import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.ows10.DCPType;
import net.opengis.ows10.HTTPType;
import net.opengis.ows10.Ows10Factory;
import net.opengis.ows10.RequestMethodType;
import org.geotools.wfs.v1_0.WFSCapabilities;
import org.geotools.xml.AbstractComplexEMFBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class DCPTypeBinding
extends AbstractComplexEMFBinding {
    @Override
    public QName getTarget() {
        return WFSCapabilities.DCPType;
    }

    @Override
    public Class getType() {
        return DCPType.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Ows10Factory ows10Factory = Ows10Factory.eINSTANCE;
        DCPType dcpType = ows10Factory.createDCPType();
        HTTPType httpType = ows10Factory.createHTTPType();
        dcpType.setHTTP(httpType);
        List httpChildren = node.getChildren("HTTP");
        for (Node http : httpChildren) {
            Node post;
            Node get = http.getChild("Get");
            if (get != null) {
                RequestMethodType methodType = this.createRequestMethodType(ows10Factory, get);
                httpType.getGet().add(methodType);
            }
            if ((post = http.getChild("Post")) == null) continue;
            RequestMethodType methodType = this.createRequestMethodType(ows10Factory, post);
            httpType.getPost().add(methodType);
        }
        return dcpType;
    }

    private RequestMethodType createRequestMethodType(Ows10Factory ows10Factory, Node getOrPostNode) {
        RequestMethodType methodType = ows10Factory.createRequestMethodType();
        String href = (String)getOrPostNode.getAttributeValue("onlineResource");
        methodType.setHref(href);
        return methodType;
    }
}

