/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.path;

import org.geotools.graph.path.Path;
import org.geotools.graph.path.WrongPathException;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.GraphWalker;
import org.geotools.graph.traverse.basic.BasicGraphTraversal;
import org.geotools.graph.traverse.standard.AStarIterator;

public class AStarShortestPathFinder
implements GraphWalker {
    private Graph m_graph;
    private GraphTraversal m_traversal;
    private AStarIterator m_iterator;
    private Node m_target;

    public AStarShortestPathFinder(Graph graph, Node source, Node target, AStarIterator.AStarFunctions afuncs) {
        this.m_graph = graph;
        this.m_target = target;
        this.m_iterator = new AStarIterator(source, afuncs);
        this.m_traversal = new BasicGraphTraversal(graph, this, this.m_iterator);
    }

    public void calculate() {
        this.m_traversal.init();
        this.m_traversal.traverse();
    }

    @Override
    public int visit(Graphable element, GraphTraversal traversal) {
        if (element.equals(this.m_target)) {
            return 3;
        }
        return 0;
    }

    public Path getPath() throws WrongPathException {
        Path path = new Path();
        path.add(this.m_target);
        Node parent = this.m_iterator.getParent(this.m_target);
        while (parent != null) {
            path.add(parent);
            parent = this.m_iterator.getParent(parent);
        }
        if (!path.getLast().equals(this.m_iterator.getSource())) {
            throw new WrongPathException("getPath: The path obtained doesn't begin correctly");
        }
        return path;
    }

    @Override
    public void finish() {
    }
}

