/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml3.XSDIdRegistry;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class GeometryPropertyTypeBindingBase
extends AbstractComplexBinding {
    private XSDIdRegistry idSet;
    private boolean makeEmpty = false;
    private GML3EncodingUtils encodingUtils;

    public GeometryPropertyTypeBindingBase(GML3EncodingUtils encodingUtils, XSDIdRegistry idRegistry) {
        this.idSet = idRegistry;
        this.encodingUtils = encodingUtils;
    }

    @Override
    public Class getType() {
        return this.getGeometryType();
    }

    public Class<? extends Geometry> getGeometryType() {
        return Geometry.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return node.getChildValue(this.getGeometryType());
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        this.checkExistingId((Geometry)object);
        return value;
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        return this.encodingUtils.GeometryPropertyType_GetProperty((Geometry)object, name, this.makeEmpty);
    }

    @Override
    public List getProperties(Object object) throws Exception {
        return this.encodingUtils.GeometryPropertyType_GetProperties((Geometry)object);
    }

    private void checkExistingId(Geometry geom) {
        if (geom != null) {
            String id = GML2EncodingUtils.getID(geom);
            if (id != null && this.idSet.idExists(id)) {
                this.makeEmpty = true;
            } else if (id != null) {
                this.idSet.add(id);
            }
        }
    }
}

