/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.event;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import org.geotools.swing.MapPane;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.event.MapMouseEventDispatcher;
import org.geotools.swing.event.MapMouseListener;

public class DefaultMapMouseEventDispatcher
implements MapMouseEventDispatcher {
    private MapPane mapPane;
    private List<MapMouseListener> listeners;

    public DefaultMapMouseEventDispatcher(MapPane mapPane) {
        this.mapPane = mapPane;
        this.listeners = new ArrayList<MapMouseListener>();
    }

    @Override
    public boolean addMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (!this.listeners.contains(listener)) {
            return this.listeners.add(listener);
        }
        return false;
    }

    @Override
    public boolean removeMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        return this.listeners.remove(listener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        MapMouseEvent mapEv = this.convertEvent(ev);
        if (mapEv != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseClicked(mapEv);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        MapMouseEvent mapEv = this.convertEvent(ev);
        if (mapEv != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMousePressed(mapEv);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        MapMouseEvent mapEv = this.convertEvent(ev);
        if (mapEv != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseReleased(mapEv);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
        MapMouseEvent mapEv = this.convertEvent(ev);
        if (mapEv != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseEntered(mapEv);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        MapMouseEvent mapEv = this.convertEvent(ev);
        if (mapEv != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseExited(mapEv);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        MapMouseEvent mapEv = this.convertEvent(ev);
        if (mapEv != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseDragged(mapEv);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        MapMouseEvent mapEv = this.convertEvent(ev);
        if (mapEv != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseMoved(mapEv);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent ev) {
        MapMouseEvent mapEv = this.convertEvent(ev);
        if (mapEv != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseWheelMoved(mapEv);
            }
        }
    }

    @Override
    public MapMouseEvent convertEvent(MouseEvent ev) {
        MapMouseEvent mapEv = null;
        if (this.mapPane.getScreenToWorldTransform() != null) {
            mapEv = new MapMouseEvent(this.mapPane, ev);
        }
        return mapEv;
    }

    @Override
    public MapMouseEvent convertEvent(MouseWheelEvent ev) {
        MapMouseEvent mapEv = null;
        if (this.mapPane.getScreenToWorldTransform() != null) {
            mapEv = new MapMouseEvent(this.mapPane, ev);
        }
        return mapEv;
    }
}

