/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils.iterator;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RectIter;
import org.jaitools.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleIterator {
    protected final WeakReference<RenderedImage> imageRef;
    protected final int imageDataType;
    protected final Rectangle iterBounds;
    protected final RectIter delegateIter;
    private final int numImageBands;
    private final Order order;
    private final Integer outsideValue_Integer;
    private final Float outsideValue_Float;
    private final Double outsideValue_Double;
    private final List<Rectangle> subBoundList;
    private int currentSubBound;
    private final int lastSubBound;
    private final Point startSubPos;
    private final Point endSubPos;
    private final Point mainPos;
    private final Rectangle delegateBounds;
    private final Point delegatePos;

    public AbstractSimpleIterator(DelegateHelper helper, RenderedImage image, Rectangle bounds, Number outsideValue, Order order) {
        if (image == null) {
            throw new IllegalArgumentException("image must not be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("order must not be null");
        }
        this.imageRef = new WeakReference<RenderedImage>(image);
        this.imageDataType = image.getSampleModel().getDataType();
        this.numImageBands = image.getSampleModel().getNumBands();
        Rectangle imageBounds = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        this.iterBounds = bounds == null ? imageBounds : new Rectangle(bounds);
        this.delegateBounds = imageBounds.intersection(this.iterBounds);
        if (this.delegateBounds.isEmpty()) {
            this.delegatePos = null;
            this.delegateIter = null;
        } else {
            this.delegatePos = new Point(this.delegateBounds.x, this.delegateBounds.y);
            this.delegateIter = helper.create(image, this.delegateBounds);
        }
        this.mainPos = new Point(this.iterBounds.x, this.iterBounds.y);
        this.outsideValue_Integer = outsideValue == null ? null : Integer.valueOf(outsideValue.intValue());
        this.outsideValue_Float = outsideValue == null ? null : Float.valueOf(outsideValue.floatValue());
        this.outsideValue_Double = outsideValue == null ? null : Double.valueOf(outsideValue.doubleValue());
        this.order = order;
        this.startSubPos = new Point();
        this.endSubPos = new Point();
        this.subBoundList = this.buildSubBoundList(image);
        this.lastSubBound = this.subBoundList.size() - 1;
        this.setCurrentSubBound(0);
    }

    public RenderedImage getImage() {
        return (RenderedImage)this.imageRef.get();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.iterBounds);
    }

    public List<Rectangle> getSubBounds() {
        List<Rectangle> copy = CollectionFactory.list();
        for (Rectangle r : this.subBoundList) {
            copy.add(new Rectangle(r));
        }
        return copy;
    }

    public Point getStartPos() {
        return new Point(this.iterBounds.x, this.iterBounds.y);
    }

    public Point getEndPos() {
        return new Point(this.iterBounds.x + this.iterBounds.width - 1, this.iterBounds.y + this.iterBounds.height - 1);
    }

    public boolean isWithinImage() {
        return this.delegatePos != null && this.mainPos.equals(this.delegatePos);
    }

    public boolean hasNext() {
        return this.currentSubBound < this.lastSubBound || this.mainPos.x < this.endSubPos.x || this.mainPos.y < this.endSubPos.y;
    }

    public boolean next() {
        if (this.hasNext()) {
            ++this.mainPos.x;
            if (this.mainPos.x > this.endSubPos.x) {
                this.mainPos.x = this.startSubPos.x;
                ++this.mainPos.y;
                if (this.mainPos.y > this.endSubPos.y) {
                    this.setCurrentSubBound(this.currentSubBound + 1);
                    this.mainPos.setLocation(this.startSubPos);
                }
            }
            this.setDelegatePosition();
            return true;
        }
        return false;
    }

    public void reset() {
        this.setPos(this.iterBounds.x, this.iterBounds.y);
    }

    public Point getPos() {
        return this.getPos(null);
    }

    public Point getPos(Point dest) {
        if (dest == null) {
            dest = new Point(this.mainPos);
        } else {
            dest.setLocation(this.mainPos);
        }
        return dest;
    }

    public boolean setPos(Point pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos must not be null");
        }
        return this.setPos(pos.x, pos.y);
    }

    public boolean setPos(int x, int y) {
        if (this.iterBounds.contains(x, y)) {
            int index = this.findSubBound(x, y);
            this.setCurrentSubBound(index);
            this.mainPos.setLocation(x, y);
            this.setDelegatePosition();
            return true;
        }
        return false;
    }

    public Number getSample() {
        return this.getSample(0);
    }

    public Number getSample(Point pos) {
        if (pos == null) {
            throw new IllegalArgumentException("pos must not be null");
        }
        return this.getSample(pos.x, pos.y);
    }

    public Number getSample(int x, int y) {
        if (this.setPos(x, y)) {
            return this.getSample();
        }
        return null;
    }

    public Number getSample(int band) {
        Number value;
        RenderedImage image = (RenderedImage)this.imageRef.get();
        if (image == null) {
            throw new IllegalStateException("Target image has been deleted");
        }
        boolean inside = this.delegateBounds.contains(this.mainPos);
        switch (this.imageDataType) {
            case 5: {
                if (inside) {
                    value = new Double(this.delegateIter.getSampleDouble(band));
                    break;
                }
                value = this.outsideValue_Double;
                break;
            }
            case 4: {
                if (inside) {
                    value = new Float(this.delegateIter.getSampleFloat(band));
                    break;
                }
                value = this.outsideValue_Float;
                break;
            }
            default: {
                value = inside ? Integer.valueOf(this.delegateIter.getSample(band)) : this.outsideValue_Integer;
            }
        }
        return value;
    }

    public Number getSample(Point pos, int band) {
        if (pos == null) {
            throw new IllegalArgumentException("pos must not be null");
        }
        return this.getSample(pos.x, pos.y, band);
    }

    public Number getSample(int x, int y, int band) {
        if (this.setPos(x, y)) {
            return this.getSample(band);
        }
        return null;
    }

    public void done() {
        this.imageRef.clear();
        if (this.delegateIter instanceof RandomIter) {
            ((RandomIter)((Object)this.delegateIter)).done();
        }
    }

    protected void setDelegatePosition() {
        if (this.isInsideDelegateBounds()) {
            int dy = this.mainPos.y - this.delegatePos.y;
            if (dy < 0) {
                this.delegateIter.startLines();
                this.delegatePos.y = this.delegateBounds.y;
                dy = this.mainPos.y - this.delegateBounds.y;
            }
            while (dy > 0) {
                this.delegateIter.nextLineDone();
                ++this.delegatePos.y;
                --dy;
            }
            int dx = this.mainPos.x - this.delegatePos.x;
            if (dx < 0) {
                this.delegateIter.startPixels();
                this.delegatePos.x = this.delegateBounds.x;
                dx = this.mainPos.x - this.delegateBounds.x;
            }
            while (dx > 0) {
                this.delegateIter.nextPixelDone();
                ++this.delegatePos.x;
                --dx;
            }
        }
    }

    protected boolean isInsideDelegateBounds() {
        return this.delegateIter != null && this.delegateBounds.contains(this.mainPos);
    }

    protected void checkBandArg(int band) {
        if (band < 0 || band >= this.numImageBands) {
            throw new IllegalArgumentException(String.format("band argument (%d) is out of range: number of image bands is %d", band, this.numImageBands));
        }
    }

    private List<Rectangle> buildSubBoundList(RenderedImage image) {
        List<Rectangle> boundsList = CollectionFactory.list();
        switch (this.order) {
            case IMAGE_X_Y: {
                boundsList.add(this.iterBounds);
                break;
            }
            case TILE_X_Y: {
                this.getIntersectingTileBounds(image, boundsList);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized iterator order: " + (Object)((Object)this.order));
            }
        }
        return boundsList;
    }

    private void setCurrentSubBound(int index) {
        Rectangle r = this.subBoundList.get(index);
        this.startSubPos.setLocation(r.x, r.y);
        this.endSubPos.setLocation(r.x + r.width - 1, r.y + r.height - 1);
        this.currentSubBound = index;
    }

    private int findSubBound(int x, int y) {
        for (int i = 0; i < this.subBoundList.size(); ++i) {
            if (!this.subBoundList.get(i).contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    private void getIntersectingTileBounds(RenderedImage image, List<Rectangle> destList) {
        int tileWidth = image.getTileWidth();
        int tileHeight = image.getTileHeight();
        int xOffset = image.getTileGridXOffset();
        int yOffset = image.getTileGridYOffset();
        int minTileX = this.pixelToTile(this.iterBounds.x, xOffset, tileWidth);
        int minTileY = this.pixelToTile(this.iterBounds.y, yOffset, tileHeight);
        int maxTileX = this.pixelToTile(this.iterBounds.x + this.iterBounds.width - 1, xOffset, tileWidth);
        int maxTileY = this.pixelToTile(this.iterBounds.y + this.iterBounds.height - 1, yOffset, tileHeight);
        for (int ty = minTileY; ty <= maxTileY; ++ty) {
            int y = ty * tileHeight + yOffset;
            for (int tx = minTileX; tx <= maxTileX; ++tx) {
                int x = tx * tileWidth + xOffset;
                Rectangle tileRect = new Rectangle(x, y, tileWidth, tileHeight);
                Rectangle within = tileRect.intersection(this.iterBounds);
                if (within.isEmpty()) continue;
                destList.add(within);
            }
        }
    }

    private int pixelToTile(int ordinate, int offset, int dim) {
        if ((ordinate -= offset) < 0) {
            ordinate += 1 - dim;
        }
        return ordinate / dim;
    }

    protected static interface DelegateHelper {
        public RectIter create(RenderedImage var1, Rectangle var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        IMAGE_X_Y,
        TILE_X_Y;

    }
}

