/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorindexer;

import it.geosolutions.jaiext.colorindexer.CachingColorIndexer;
import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.colorindexer.ColorMap;
import it.geosolutions.jaiext.colorindexer.ColorUtils;
import it.geosolutions.jaiext.colorindexer.MappedColorIndexer;
import it.geosolutions.jaiext.colorindexer.PackedHistogram;
import it.geosolutions.jaiext.colorindexer.SimpleColorIndexer;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Quantizer {
    static final Logger LOGGER = Logger.getLogger("Quantizer");
    boolean MEDIAN_SPLIT = true;
    boolean MEDIAN_BOX = true;
    float THRESHOLD = 0.5f;
    boolean subsample = false;
    int maxColors;

    public Quantizer(int maxColors) {
        this.maxColors = maxColors;
    }

    public Quantizer subsample() {
        this.subsample = false;
        return this;
    }

    public ColorIndexer buildColorIndexer(RenderedImage image) {
        int subsy;
        int subsx;
        long totalPixelCount = (long)image.getWidth() * (long)image.getHeight();
        if (this.subsample) {
            subsx = 1 + (int)(Math.log(image.getWidth()) / Math.log(8.0));
            subsy = 1 + (int)(Math.log(image.getHeight()) / Math.log(8.0));
        } else {
            subsx = 1;
            subsy = 1;
        }
        PackedHistogram histogram = new PackedHistogram(image, subsx, subsy);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Found " + histogram.size() + " unique colors with shift " + histogram.getShift());
            LOGGER.fine("Histogram count " + histogram.pixelCount() + " and pixels " + totalPixelCount);
        }
        int colors = Math.min(histogram.size(), this.maxColors);
        ArrayList<Box> boxes = new ArrayList<Box>();
        boxes.add(new Box(0, histogram.size(), totalPixelCount, histogram, null));
        int sortSwitch = Math.round((float)colors * this.THRESHOLD);
        Comparator<Box> comparator = new SumComparator();
        VolumeComparator volumeComparator = new VolumeComparator();
        while (boxes.size() < colors) {
            int boxIndex;
            for (boxIndex = 0; boxIndex < boxes.size() && ((Box)boxes.get(boxIndex)).colors <= 1; ++boxIndex) {
            }
            if (boxIndex == boxes.size()) break;
            Box box = (Box)boxes.get(boxIndex);
            int spana = box.getAlphaSpan();
            int spanr = box.getRedSpan();
            int spang = box.getGreenSpan();
            int spanb = box.getBlueSpan();
            PackedHistogram.SortComponent sort = spana > spanr && spana > spanb && spana > spang ? PackedHistogram.SortComponent.Alpha : (spanr > spang && spanr > spanb ? PackedHistogram.SortComponent.Red : (spang > spanb ? PackedHistogram.SortComponent.Green : PackedHistogram.SortComponent.Blue));
            box.sort(sort);
            Box newBox = box.split();
            boxes.add(newBox);
            if (comparator instanceof SumComparator && boxes.size() > sortSwitch) {
                comparator = volumeComparator;
            }
            Collections.sort(boxes, comparator);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < boxes.size(); ++i) {
                Box b = (Box)boxes.get(i);
                sb.append("Box " + i + ", pixels: " + b.sum + " colors: " + b.colors + " volume: " + b.getVolume() + " p*v: " + b.getVolume() * b.sum);
            }
            sb.append("\n");
            LOGGER.finer("Median cut resulted in the following boxes:\n" + sb);
        }
        if (boxes.size() == 1) {
            boxes.add((Box)boxes.get(0));
        }
        Object[] palette = new PaletteEntry[boxes.size()];
        int shift = histogram.getShift();
        for (int i = 0; i < boxes.size(); ++i) {
            byte a;
            byte b;
            byte g;
            byte r;
            int color;
            Box box = (Box)boxes.get(i);
            if (box.colors == 1) {
                color = histogram.getColor(box.idx);
                r = (byte)ColorUtils.red(color);
                g = (byte)ColorUtils.green(color);
                b = (byte)ColorUtils.blue(color);
                a = (byte)ColorUtils.alpha(color);
            } else if (this.MEDIAN_BOX) {
                color = histogram.getColor(box.idx + box.colors / 2);
                r = (byte)ColorUtils.red(color);
                g = (byte)ColorUtils.green(color);
                b = (byte)ColorUtils.blue(color);
                a = (byte)ColorUtils.alpha(color);
            } else {
                int start = box.idx;
                int end = box.idx + box.colors;
                long sum = 0L;
                long as = 0L;
                long bs = 0L;
                long gs = 0L;
                long rs = 0L;
                for (int idx = start; idx < end; ++idx) {
                    int color2 = histogram.getColor(idx);
                    long count = histogram.getCount(idx);
                    rs += (long)ColorUtils.red(color2) * count;
                    gs += (long)ColorUtils.green(color2) * count;
                    bs += (long)ColorUtils.blue(color2) * count;
                    as += (long)ColorUtils.alpha(color2) * count;
                    sum += count;
                }
                r = (byte)(rs / sum);
                g = (byte)(gs / sum);
                b = (byte)(bs / sum);
                a = (byte)(as / sum);
            }
            palette[i] = new PaletteEntry(r, g, b, a, i);
        }
        Arrays.sort(palette);
        byte[][] rgba = new byte[4][palette.length];
        for (int i = 0; i < palette.length; ++i) {
            Object pe = palette[i];
            rgba[0][i] = ((PaletteEntry)pe).r;
            rgba[1][i] = ((PaletteEntry)pe).g;
            rgba[2][i] = ((PaletteEntry)pe).b;
            rgba[3][i] = ((PaletteEntry)pe).a;
        }
        SimpleColorIndexer simpleMapper = new SimpleColorIndexer(rgba);
        ColorMap colorMap = histogram.colorMap;
        for (ColorMap.ColorEntry ce : colorMap) {
            int idx;
            int color = ce.color;
            int r = ColorUtils.red(color);
            int g = ColorUtils.green(color);
            int b = ColorUtils.blue(color);
            int a = ColorUtils.alpha(color);
            if (shift > 0) {
                r = ColorUtils.unshift(r, shift);
                g = ColorUtils.unshift(g, shift);
                b = ColorUtils.unshift(b, shift);
                a = ColorUtils.unshift(a, shift);
            }
            ce.value = idx = simpleMapper.getClosestIndex(r, g, b, a) & 0xFF;
        }
        MappedColorIndexer delegate = new MappedColorIndexer(rgba, colorMap, shift);
        return new CachingColorIndexer(delegate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PaletteEntry
    implements Comparable<PaletteEntry> {
        byte r;
        byte g;
        byte b;
        byte a;
        int idx;

        public PaletteEntry(byte r, byte g, byte b, byte a, int idx) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.idx = idx;
        }

        @Override
        public int compareTo(PaletteEntry other) {
            return (this.a & 0xFF) - (other.a & 0xFF);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class VolumeComparator
    implements Comparator<Box> {
        VolumeComparator() {
        }

        @Override
        public int compare(Box b1, Box b2) {
            long vs1;
            if (b1.colors == 1) {
                if (b2.colors == 1) {
                    return ColorUtils.compareLong(b2.sum, b1.sum);
                }
                return 1;
            }
            if (b2.colors == 1) {
                return -1;
            }
            long vs2 = b2.getVolume() * b2.sum;
            long diff = vs2 - (vs1 = b1.getVolume() * b1.sum);
            if (diff == 0L) {
                return 0;
            }
            if (diff > 0L) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SumComparator
    implements Comparator<Box> {
        SumComparator() {
        }

        @Override
        public int compare(Box b1, Box b2) {
            if (b1.colors == 1) {
                if (b2.colors == 1) {
                    return ColorUtils.compareLong(b2.sum, b1.sum);
                }
                return 1;
            }
            if (b2.colors == 1) {
                return -1;
            }
            return ColorUtils.compareLong(b2.sum, b1.sum);
        }
    }

    final class Box {
        private int idx;
        private int colors;
        private long sum;
        private PackedHistogram.SortComponent sort;
        private PackedHistogram histogram;
        private int spana = -1;
        private int spanb = -1;
        private int spanr = -1;
        private int spang = -1;

        public Box(int idx, int colors, long sum, PackedHistogram histogram, PackedHistogram.SortComponent sort) {
            this.idx = idx;
            this.colors = colors;
            this.histogram = histogram;
            this.sum = sum;
            this.sort = sort;
        }

        public void sort(PackedHistogram.SortComponent sort) {
            if (this.sort != sort) {
                this.sort = sort;
                int start = this.idx + 1;
                int end = this.idx + this.colors;
                this.histogram.sort(start, end, sort);
            }
        }

        public Box split() {
            long ps;
            int i;
            long fullsum = this.sum;
            if (Quantizer.this.MEDIAN_SPLIT) {
                int mid = this.idx + this.colors / 2;
                for (i = this.idx + 1; i < mid; ++i) {
                    ps += this.histogram.getCount(i);
                }
            } else {
                int end = this.idx + this.colors;
                long halfsum = fullsum / 2L;
                for (ps = this.histogram.getCount(this.idx); i < end - 1 && ps < halfsum; ps += this.histogram.getCount(i), ++i) {
                }
            }
            int fullColors = this.colors;
            this.colors = i - this.idx;
            this.sum = ps;
            this.spana = -1;
            this.spanb = -1;
            this.spanr = -1;
            this.spang = -1;
            long rest = fullsum - ps;
            return new Box(i, fullColors - this.colors, rest, this.histogram, this.sort);
        }

        public String toString() {
            return "Box [idx=" + this.idx + ", colors=" + this.colors + ", sum=" + this.sum + "]";
        }

        public int getAlphaSpan() {
            if (this.spana == -1) {
                this.updateSpans();
            }
            return this.spana;
        }

        public int getRedSpan() {
            if (this.spanr == -1) {
                this.updateSpans();
            }
            return this.spanr;
        }

        public int getGreenSpan() {
            if (this.spang == -1) {
                this.updateSpans();
            }
            return this.spang;
        }

        public int getBlueSpan() {
            if (this.spanb == -1) {
                this.updateSpans();
            }
            return this.spanb;
        }

        private void updateSpans() {
            int maxa;
            int maxb;
            int maxg;
            int maxr;
            int color = this.histogram.getPackedColor(this.idx);
            int minr = maxr = ColorUtils.red(color);
            int ming = maxg = ColorUtils.green(color);
            int minb = maxb = ColorUtils.blue(color);
            int mina = maxa = ColorUtils.alpha(color);
            int start = this.idx + 1;
            int end = this.idx + this.colors;
            for (int i = start; i < end; ++i) {
                color = this.histogram.getPackedColor(i);
                int r = ColorUtils.red(color);
                if (r < minr) {
                    minr = r;
                } else if (r > maxr) {
                    maxr = r;
                }
                int g = ColorUtils.green(color);
                if (g < ming) {
                    ming = g;
                } else if (g > maxg) {
                    maxg = g;
                }
                int b = ColorUtils.blue(color);
                if (b < minb) {
                    minb = b;
                } else if (b > maxb) {
                    maxb = b;
                }
                int a = ColorUtils.alpha(color);
                if (a < mina) {
                    mina = a;
                    continue;
                }
                if (a <= maxa) continue;
                maxa = a;
            }
            this.spana = maxa - mina;
            this.spanr = maxr - minr;
            this.spang = maxg - ming;
            this.spanb = maxb - minb;
        }

        public long getVolume() {
            if (this.spana == -1) {
                this.updateSpans();
            }
            return ((long)this.spana + 1L) * ((long)this.spanr + 1L) * ((long)this.spang + 1L) * ((long)this.spanb + 1L) * (long)ColorUtils.shift(1, this.histogram.getShift());
        }
    }
}

