/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.ArcTypeBinding;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.gml3.bindings.LineStringSegmentTypeBinding;
import org.geotools.gml3.bindings.LineStringTypeBinding;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class ArcStringTypeBinding
extends AbstractComplexBinding
implements Comparable {
    GeometryFactory gFactory;
    CoordinateSequenceFactory csFactory;
    ArcParameters arcParameters;

    public ArcStringTypeBinding(GeometryFactory gFactory, CoordinateSequenceFactory csFactory, ArcParameters arcParameters) {
        this.gFactory = gFactory;
        this.csFactory = csFactory;
        this.arcParameters = arcParameters;
    }

    @Override
    public QName getTarget() {
        return GML.ArcStringType;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    @Override
    public Class getType() {
        return SingleCurvedGeometry.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LineString arcLineString = GML3ParsingUtils.lineString(node, this.gFactory, this.csFactory);
        CoordinateSequence cs = arcLineString.getCoordinateSequence();
        if (cs.size() < 3) {
            throw new RuntimeException("Number of coordinates in an arc string must be at least 3, " + cs.size() + " were specified: " + arcLineString);
        }
        CurvedGeometryFactory factory = GML3ParsingUtils.getCurvedGeometryFactory(this.arcParameters, this.gFactory, cs);
        return factory.createCurvedGeometry(cs);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if ("interpolation".equals(name.getLocalPart())) {
            return "circularArc3Points";
        }
        if ("posList".equals(name.getLocalPart())) {
            return GML3EncodingUtils.positions((LineString)object);
        }
        return super.getProperty(object, name);
    }

    public int compareTo(Object o) {
        if (o instanceof LineStringTypeBinding || o instanceof LineStringSegmentTypeBinding || o instanceof ArcTypeBinding) {
            return -1;
        }
        return 0;
    }
}

