/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata;

import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.opengis.annotation.ComplianceLevel;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Profile;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;

@UML(identifier="MD_MetaData", specification=Specification.ISO_19115)
@Profile(level=ComplianceLevel.CORE)
public interface MetaData {
    @UML(identifier="fileIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public String getFileIdentifier();

    @UML(identifier="language", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Locale getLanguage();

    @UML(identifier="characterSet", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public CharacterSet getCharacterSet();

    @UML(identifier="parentIdentifier", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public String getParentIdentifier();

    @UML(identifier="hierarchyLevel", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<ScopeCode> getHierarchyLevels();

    @UML(identifier="hierarchyLevelName", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<String> getHierarchyLevelNames();

    @UML(identifier="contact", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends ResponsibleParty> getContacts();

    @UML(identifier="dateStamp", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Date getDateStamp();

    @UML(identifier="metadataStandardName", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public String getMetadataStandardName();

    @UML(identifier="metadataStandardVersion", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public String getMetadataStandardVersion();

    @UML(identifier="dataSetURI", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public String getDataSetUri();

    @UML(identifier="locale", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Locale> getLocales();

    @UML(identifier="spatialRepresentationInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends SpatialRepresentation> getSpatialRepresentationInfo();

    @UML(identifier="referenceSystemInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends ReferenceSystem> getReferenceSystemInfo();

    @UML(identifier="metadataExtensionInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends MetadataExtensionInformation> getMetadataExtensionInfo();

    @UML(identifier="identificationInfo", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends Identification> getIdentificationInfo();

    @UML(identifier="contentInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends ContentInformation> getContentInfo();

    @UML(identifier="distributionInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Distribution getDistributionInfo();

    @UML(identifier="dataQualityInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends DataQuality> getDataQualityInfo();

    @UML(identifier="portrayalCatalogueInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends PortrayalCatalogueReference> getPortrayalCatalogueInfo();

    @UML(identifier="metadataConstraints", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Constraints> getMetadataConstraints();

    @UML(identifier="applicationSchemaInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends ApplicationSchemaInformation> getApplicationSchemaInfo();

    @UML(identifier="metadataMaintenance", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public MaintenanceInformation getMetadataMaintenance();
}

