/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.feature.type.Types;
import org.opengis.feature.Association;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AssociationDescriptor;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AttributeBuilder {
    protected static final ComplexType ANYTYPE_TYPE = new ComplexTypeImpl((Name)new NameImpl("http://www.w3.org/2001/XMLSchema", "anyType"), null, false, true, (List<Filter>)Collections.EMPTY_LIST, null, null);
    FeatureFactory attributeFactory;
    String namespace;
    AttributeType type;
    AttributeDescriptor descriptor;
    List properties;
    CoordinateReferenceSystem crs;
    Object defaultGeometry;

    public AttributeBuilder(FeatureFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
    }

    public FeatureFactory getFeatureFactory() {
        return this.attributeFactory;
    }

    public void setFeatureFactory(FeatureFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
    }

    public void init() {
        this.descriptor = null;
        this.type = null;
        this.properties = null;
        this.crs = null;
        this.defaultGeometry = null;
    }

    public void init(Attribute attribute) {
        Feature feature;
        this.init();
        this.descriptor = attribute.getDescriptor();
        this.type = attribute.getType();
        if (attribute instanceof ComplexAttribute) {
            ComplexAttribute complex = (ComplexAttribute)attribute;
            Object properties = complex.getValue();
            Iterator itr = properties.iterator();
            while (itr.hasNext()) {
                Property property = (Property)itr.next();
                if (property instanceof Attribute) {
                    Attribute att = (Attribute)property;
                    this.add(att.getIdentifier() == null ? null : att.getIdentifier().toString(), att.getValue(), att.getName());
                    continue;
                }
                if (!(property instanceof Association)) continue;
                Association assoc = (Association)property;
                this.associate(assoc.getValue(), assoc.getName());
            }
        }
        if (attribute instanceof Feature && (feature = (Feature)attribute).getDefaultGeometryProperty() != null) {
            if (this.crs == null) {
                this.crs = feature.getDefaultGeometryProperty().getType().getCoordinateReferenceSystem();
            }
            this.defaultGeometry = feature.getDefaultGeometryProperty().getValue();
        }
    }

    public void setNamespaceURI(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public void setType(AttributeType type) {
        this.type = type;
        this.descriptor = null;
    }

    public void setDescriptor(AttributeDescriptor descriptor) {
        this.descriptor = descriptor;
        this.type = descriptor.getType();
    }

    public AttributeType getType() {
        return this.type;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public CoordinateReferenceSystem getCRS(Object geom) {
        Object userData;
        if (this.crs != null) {
            return this.crs;
        }
        if (geom != null && geom instanceof Geometry && (userData = ((Geometry)geom).getUserData()) != null && userData instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)userData;
        }
        return null;
    }

    public void setDefaultGeometry(Object defaultGeometry) {
        this.defaultGeometry = defaultGeometry;
    }

    public Object getDefaultGeometry() {
        return this.defaultGeometry;
    }

    public Attribute add(Object value, String name) {
        return this.add(null, value, name);
    }

    public void associate(Attribute value, String name) {
        this.associate(value, name, this.namespace);
    }

    public Attribute add(Object value, String name, String namespaceURI) {
        return this.add(null, value, name, namespaceURI);
    }

    public void associate(Attribute attribute, String name, String namespaceURI) {
        this.associate(attribute, Types.typeName(namespaceURI, name));
    }

    public Attribute add(Object value, Name name) {
        return this.add(null, value, name);
    }

    public void associate(Attribute value, Name name) {
        AssociationDescriptor descriptor = this.associationDescriptor(name);
        Association association = this.attributeFactory.createAssociation(value, descriptor);
        this.properties().add(association);
    }

    public Attribute add(String id, Object value, String name) {
        return this.add(id, value, name, this.namespace);
    }

    public Attribute add(String id, Object value, String name, String namespaceURI) {
        return this.add(id, value, Types.typeName(namespaceURI, name));
    }

    public Attribute add(String id, Object value, Name name) {
        AttributeDescriptor descriptor = this.attributeDescriptor(name);
        Attribute attribute = this.create(value, null, descriptor, id);
        this.properties().add(attribute);
        return attribute;
    }

    protected List properties() {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        return this.properties;
    }

    protected AssociationDescriptor associationDescriptor(Name name) {
        PropertyDescriptor descriptor = Types.descriptor((ComplexType)this.type, name);
        if (descriptor == null) {
            String msg = "Could not locate association: " + name + " in type: " + this.type.getName();
            throw new IllegalArgumentException(msg);
        }
        if (!(descriptor instanceof AssociationDescriptor)) {
            String msg = name + " references a non association";
            throw new IllegalArgumentException(msg);
        }
        return (AssociationDescriptor)descriptor;
    }

    protected AttributeDescriptor attributeDescriptor(Name name) {
        PropertyDescriptor descriptor = Types.findDescriptor((ComplexType)this.type, name);
        if (descriptor == null) {
            String msg = "Could not locate attribute: " + name + " in type: " + this.type.getName();
            throw new IllegalArgumentException(msg);
        }
        if (!(descriptor instanceof AttributeDescriptor)) {
            String msg = name + " references a non attribute";
            throw new IllegalArgumentException(msg);
        }
        return (AttributeDescriptor)descriptor;
    }

    protected Attribute create(Object value, AttributeType type, AttributeDescriptor descriptor, String id) {
        if (descriptor != null) {
            type = descriptor.getType();
        }
        if (type instanceof FeatureType) {
            return descriptor != null ? this.attributeFactory.createFeature((Collection<Property>)((Collection)value), descriptor, id) : this.attributeFactory.createFeature((Collection<Property>)((Collection)value), (FeatureType)type, id);
        }
        if (type instanceof ComplexType) {
            return this.createComplexAttribute((Collection)value, (ComplexType)type, descriptor, id);
        }
        if (type instanceof GeometryType) {
            return this.attributeFactory.createGeometryAttribute(value, (GeometryDescriptor)descriptor, id, this.getCRS(value));
        }
        return this.attributeFactory.createAttribute(value, descriptor, id);
    }

    public ComplexAttribute createComplexAttribute(Object value, ComplexType type, AttributeDescriptor descriptor, String id) {
        return descriptor != null ? this.attributeFactory.createComplexAttribute((Collection<Property>)((Collection)value), descriptor, id) : this.attributeFactory.createComplexAttribute((Collection<Property>)((Collection)value), type, id);
    }

    public Attribute build() {
        return this.build(null);
    }

    public Attribute build(String id) {
        Attribute built = this.create(this.properties(), this.type, this.descriptor, id);
        if (built instanceof Feature) {
            Feature feature = (Feature)built;
            if (this.defaultGeometry != null) {
                for (Attribute attribute : feature.getProperties()) {
                    if (!(attribute instanceof GeometryAttribute) || !this.defaultGeometry.equals(attribute.getValue())) continue;
                    feature.setDefaultGeometryProperty((GeometryAttribute)attribute);
                }
            }
        }
        this.properties().clear();
        return built;
    }

    public Attribute addAnyTypeValue(Object value, AttributeType type, AttributeDescriptor descriptor, String id) {
        Attribute attribute = this.create(value, type, descriptor, id);
        this.properties().add(attribute);
        return attribute;
    }

    public Attribute addComplexAnyTypeAttribute(Object value, AttributeDescriptor descriptor, String id) {
        Map<Object, Object> userData = descriptor.getUserData();
        descriptor = new AttributeDescriptorImpl(ANYTYPE_TYPE, descriptor.getName(), descriptor.getMinOccurs(), descriptor.getMaxOccurs(), descriptor.isNillable(), descriptor.getDefaultValue());
        descriptor.getUserData().putAll(userData);
        return this.createComplexAttribute(value, ANYTYPE_TYPE, descriptor, id);
    }

    public AttributeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    protected List getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        return this.properties;
    }

    public Attribute buildSimple(String id, Object value) {
        return this.create(value, this.type, this.descriptor, id);
    }
}

