/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.Configuration;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvelopeTypeBinding
extends AbstractComplexBinding {
    Configuration config;
    SrsSyntax srsSyntax;

    public EnvelopeTypeBinding(Configuration config, SrsSyntax srsSyntax) {
        this.config = config;
        this.srsSyntax = srsSyntax;
    }

    @Override
    public QName getTarget() {
        return GML.EnvelopeType;
    }

    @Override
    public Class getType() {
        return Envelope.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        if (node.getChild("lowerCorner") != null) {
            DirectPosition l = (DirectPosition)node.getChildValue("lowerCorner");
            DirectPosition u = (DirectPosition)node.getChildValue("upperCorner");
            if (l.getDimension() > 2) {
                return new ReferencedEnvelope3D(u.getOrdinate(0), l.getOrdinate(0), u.getOrdinate(1), l.getOrdinate(1), u.getOrdinate(2), l.getOrdinate(2), crs);
            }
            return new ReferencedEnvelope(u.getOrdinate(0), l.getOrdinate(0), u.getOrdinate(1), l.getOrdinate(1), crs);
        }
        if (node.hasChild(Coordinate.class)) {
            List c = node.getChildValues(Coordinate.class);
            Coordinate c1 = (Coordinate)c.get(0);
            Coordinate c2 = (Coordinate)c.get(1);
            if (!Double.isNaN(c1.z)) {
                return new ReferencedEnvelope3D(c1.x, c2.x, c1.y, c2.y, c1.z, c1.z, crs);
            }
            return new ReferencedEnvelope(c1.x, c2.x, c1.y, c2.y, crs);
        }
        if (node.hasChild(DirectPosition.class)) {
            List dp = node.getChildValues(DirectPosition.class);
            DirectPosition dp1 = (DirectPosition)dp.get(0);
            DirectPosition dp2 = (DirectPosition)dp.get(1);
            if (dp1.getDimension() > 2) {
                return new ReferencedEnvelope3D(dp1.getOrdinate(0), dp2.getOrdinate(0), dp1.getOrdinate(1), dp2.getOrdinate(1), dp1.getOrdinate(2), dp2.getOrdinate(2), crs);
            }
            return new ReferencedEnvelope(dp1.getOrdinate(0), dp2.getOrdinate(0), dp1.getOrdinate(1), dp2.getOrdinate(1), crs);
        }
        if (node.hasChild(CoordinateSequence.class)) {
            CoordinateSequence seq = (CoordinateSequence)node.getChildValue(CoordinateSequence.class);
            if (seq.getDimension() > 2) {
                return new ReferencedEnvelope3D(seq.getX(0), seq.getX(1), seq.getY(0), seq.getY(1), seq.getOrdinate(0, 2), seq.getOrdinate(1, 2), crs);
            }
            return new ReferencedEnvelope(seq.getX(0), seq.getX(1), seq.getY(0), seq.getY(1), crs);
        }
        return null;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        Envelope envelope = (Envelope)object;
        if (envelope.isNull()) {
            value.appendChild(document.createElementNS(this.getTarget().getNamespaceURI(), GML.Null.getLocalPart()));
        }
        return null;
    }

    @Override
    public Object getProperty(Object object, QName name) {
        Envelope envelope = (Envelope)object;
        if (envelope.isNull()) {
            return null;
        }
        if (name.getLocalPart().equals("lowerCorner")) {
            return new LiteCoordinateSequence(new double[]{envelope.getMinX(), envelope.getMinY()}, 2);
        }
        if (name.getLocalPart().equals("upperCorner")) {
            return new LiteCoordinateSequence(new double[]{envelope.getMaxX(), envelope.getMaxY()}, 2);
        }
        if (envelope instanceof ReferencedEnvelope) {
            String localName = name.getLocalPart();
            if (localName.equals("srsName")) {
                return GML3EncodingUtils.toURI(((ReferencedEnvelope)envelope).getCoordinateReferenceSystem(), this.srsSyntax);
            }
            if (localName.equals("srsDimension")) {
                if (this.config.hasProperty(GMLConfiguration.NO_SRS_DIMENSION)) {
                    return null;
                }
                CoordinateReferenceSystem crs = ((ReferencedEnvelope)envelope).getCoordinateReferenceSystem();
                if (crs != null) {
                    return crs.getCoordinateSystem().getDimension();
                }
            }
        }
        return null;
    }
}

