/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.impl.XSDNamedComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDNotationDeclarationImpl
extends XSDNamedComponentImpl
implements XSDNotationDeclaration {
    protected static final String SYSTEM_IDENTIFIER_EDEFAULT = null;
    protected String systemIdentifier = SYSTEM_IDENTIFIER_EDEFAULT;
    protected static final String PUBLIC_IDENTIFIER_EDEFAULT = null;
    protected String publicIdentifier = PUBLIC_IDENTIFIER_EDEFAULT;
    protected XSDAnnotation annotation;

    public static XSDNotationDeclaration createNotationDeclaration(Node node) {
        if (XSDConstants.nodeType(node) == 29) {
            XSDNotationDeclaration xsdNotationDeclaration = XSDFactory.eINSTANCE.createXSDNotationDeclaration();
            xsdNotationDeclaration.setElement((Element)node);
            return xsdNotationDeclaration;
        }
        return null;
    }

    protected XSDNotationDeclarationImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_NOTATION_DECLARATION;
    }

    public String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public void setSystemIdentifier(String newSystemIdentifier) {
        String oldSystemIdentifier = this.systemIdentifier;
        this.systemIdentifier = newSystemIdentifier;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldSystemIdentifier, (Object)this.systemIdentifier));
        }
    }

    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    public void setPublicIdentifier(String newPublicIdentifier) {
        String oldPublicIdentifier = this.publicIdentifier;
        this.publicIdentifier = newPublicIdentifier;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldPublicIdentifier, (Object)this.publicIdentifier));
        }
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)((Object)this.annotation)).eInverseRemove(this, -14, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)((Object)newAnnotation)).eInverseAdd(this, -14, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 13: {
                return this.basicSetAnnotation(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getSystemIdentifier();
            }
            case 12: {
                return this.getPublicIdentifier();
            }
            case 13: {
                return this.getAnnotation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setSystemIdentifier((String)newValue);
                return;
            }
            case 12: {
                this.setPublicIdentifier((String)newValue);
                return;
            }
            case 13: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setSystemIdentifier(SYSTEM_IDENTIFIER_EDEFAULT);
                return;
            }
            case 12: {
                this.setPublicIdentifier(PUBLIC_IDENTIFIER_EDEFAULT);
                return;
            }
            case 13: {
                this.setAnnotation(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return SYSTEM_IDENTIFIER_EDEFAULT == null ? this.systemIdentifier != null : !SYSTEM_IDENTIFIER_EDEFAULT.equals(this.systemIdentifier);
            }
            case 12: {
                return PUBLIC_IDENTIFIER_EDEFAULT == null ? this.publicIdentifier != null : !PUBLIC_IDENTIFIER_EDEFAULT.equals(this.publicIdentifier);
            }
            case 13: {
                return this.annotation != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (systemIdentifier: ");
        result.append(this.systemIdentifier);
        result.append(", publicIdentifier: ");
        result.append(this.publicIdentifier);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(29);
        this.setElement(newElement);
        return newElement;
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-notation", theElement, new String[]{"id", "name", "public", "system"});
            this.checkComplexContent("annotated", "http://www.w3.org/TR/xmlschema-1/", "element-notation", theElement);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-notation", theElement, "id", false);
        }
        this.checkBuiltInTypeConstraint("NCName", this.getName(), "http://www.w3.org/TR/xmlschema-1/", "element-notation", theElement, "name", true);
        this.checkBuiltInTypeConstraint("public", this.getPublicIdentifier(), "http://www.w3.org/TR/xmlschema-1/", "element-notation", theElement, "public", true);
        this.checkBuiltInTypeConstraint("anyURI", this.getSystemIdentifier(), "http://www.w3.org/TR/xmlschema-1/", "element-notation", theElement, "system", false);
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement.hasAttributeNS(null, "public")) {
            String newPublicIdentifier = changedElement.getAttributeNS(null, "public");
            if (newPublicIdentifier == null || !newPublicIdentifier.equals(this.getPublicIdentifier())) {
                this.setPublicIdentifier(newPublicIdentifier);
            }
        } else if (this.getPublicIdentifier() != null) {
            this.setPublicIdentifier(null);
        }
        if (changedElement.hasAttributeNS(null, "system")) {
            String newSystemIdentifier = changedElement.getAttributeNS(null, "system");
            if (newSystemIdentifier == null || !newSystemIdentifier.equals(this.getSystemIdentifier())) {
                this.setSystemIdentifier(newSystemIdentifier);
            }
        } else if (this.getSystemIdentifier() != null) {
            this.setSystemIdentifier(null);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        Element theElement;
        if (this.isReconciling) {
            return;
        }
        super.changeAttribute(eAttribute);
        if ((eAttribute == null || eAttribute == XSDPackage.Literals.XSD_NOTATION_DECLARATION__PUBLIC_IDENTIFIER) && (theElement = this.getElement()) != null) {
            this.niceSetAttribute(theElement, "public", this.getPublicIdentifier());
        }
        if ((eAttribute == null || eAttribute == XSDPackage.Literals.XSD_NOTATION_DECLARATION__SYSTEM_IDENTIFIER) && (theElement = this.getElement()) != null) {
            this.niceSetAttribute(theElement, "system", this.getSystemIdentifier());
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDNotationDeclarationImpl clonedNotationDeclaration = (XSDNotationDeclarationImpl)this.getXSDFactory().createXSDNotationDeclaration();
        clonedNotationDeclaration.isReconciling = true;
        if (this.getName() != null) {
            clonedNotationDeclaration.setName(this.getName());
        }
        clonedNotationDeclaration.setPublicIdentifier(this.getPublicIdentifier());
        clonedNotationDeclaration.setSystemIdentifier(this.getSystemIdentifier());
        if (deep && this.getAnnotation() != null) {
            clonedNotationDeclaration.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedNotationDeclaration.setElement(this.getElement());
        }
        clonedNotationDeclaration.isReconciling = shareDOM;
        return clonedNotationDeclaration;
    }
}

