/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.io.standard;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import org.geotools.graph.build.GraphGenerator;
import org.geotools.graph.io.standard.AbstractReaderWriter;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;

public abstract class DBReaderWriter
extends AbstractReaderWriter {
    public static final String DRIVERCLASS = "DRIVERCLASS";
    public static final String DRIVERURL = "DRIVERURL";
    public static final String SERVER = "SERVER";
    public static final String PORT = "PORT";
    public static final String DBNAME = "DBNAME";
    public static final String USERNAME = "USERNAME";
    public static final String TABLENAME = "TABLENAME";

    @Override
    public Graph read() throws Exception {
        GraphGenerator generator = (GraphGenerator)this.getProperty("GENERATOR");
        Connection conn = this.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery(this.getQuery());
        while (rs.next()) {
            generator.add(this.readInternal(rs));
        }
        rs.close();
        st.close();
        conn.close();
        return generator.getGraph();
    }

    @Override
    public void write(Graph g) throws Exception {
        Iterator itr;
        Connection conn = this.getConnection();
        Statement st = conn.createStatement();
        if (this.getProperty("NODES") != null) {
            itr = g.getNodes().iterator();
            while (itr.hasNext()) {
                this.writeNode(st, (Node)itr.next());
            }
        }
        if (this.getProperty("EDGES") != null) {
            itr = g.getEdges().iterator();
            while (itr.hasNext()) {
                this.writeEdge(st, (Edge)itr.next());
            }
        }
        st.close();
        conn.close();
    }

    protected Connection getConnection() throws Exception {
        String driverclass = (String)this.getProperty(DRIVERCLASS);
        String driverurl = (String)this.getProperty(DRIVERURL);
        String server = (String)this.getProperty(SERVER);
        String port = (String)this.getProperty(PORT);
        String dbname = (String)this.getProperty(DBNAME);
        String username = (String)this.getProperty(USERNAME);
        Class.forName(driverclass);
        return DriverManager.getConnection(driverurl + server + ":" + port + "/" + dbname + "?user=" + username);
    }

    protected void writeNode(Statement st, Node node) {
    }

    protected void writeEdge(Statement st, Edge edge) {
    }

    protected abstract String getQuery();

    protected abstract Object readInternal(ResultSet var1) throws Exception;
}

