/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.clustermanager.layers.DataCreatorGos;
import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.geoanalytics.context.DataLayerConfig;
import gr.cite.geoanalytics.context.DataStoreConfig;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeDao;
import gr.cite.gos.helpers.Transforming;
import gr.cite.gos.resources.ShapeManagementResource;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="/ShapeManagement")
public class ShapeManagementResource {
    private static Logger logger = LoggerFactory.getLogger(ShapeManagementResource.class);
    private ObjectMapper mapper;
    private ShapeDao shapeDao;
    private DataCreatorGos dataCreatorGos;
    private DataStoreConfig dataStoreConfig;
    private DataLayerConfig dataLayerConfig;

    public ShapeManagementResource(ShapeDao shapeDao, DataCreatorGos dataCreatorGos, DataStoreConfig dataStoreConfig, DataLayerConfig dataLayerConfig) {
        this.shapeDao = shapeDao;
        this.dataCreatorGos = dataCreatorGos;
        this.dataStoreConfig = dataStoreConfig;
        this.dataLayerConfig = dataLayerConfig;
        this.mapper = new ObjectMapper();
    }

    @PostConstruct
    private void createZnodeData() {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        executorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="getShapeByID/{shapeID}")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response getShapeById(@PathParam(value="shapeID") String shapeID) throws Exception {
        Shape shape = (Shape)this.shapeDao.read((Serializable)UUID.fromString(shapeID));
        ShapeMessenger sm = shape != null ? new ShapeMessenger(shape) : null;
        String json = sm != null ? this.mapper.writeValueAsString((Object)sm) : "";
        return Response.ok((Object)json).build();
    }

    @GET
    @Path(value="countShapesOfLayer/{layerID}")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response countShapesOfLayer(@PathParam(value="layerID") String layerID) throws Exception {
        Long count = this.shapeDao.countShapesOfLayer(UUID.fromString(layerID));
        return Response.ok((Object)count).build();
    }

    @DELETE
    @Path(value="deleteShape/{shapeID}")
    @Transactional(rollbackFor={Exception.class})
    public Response deleteShape(@PathParam(value="shapeID") String shapeID) throws Exception {
        UUID shapeUUID = null;
        try {
            shapeUUID = UUID.fromString(shapeID);
        }
        catch (IllegalArgumentException ex) {
            return Response.status((int)400).entity((Object)("That's not a valid 'shapeID'. Used: " + shapeID)).build();
        }
        this.shapeDao.deleteByShapeID(shapeUUID);
        return Response.status((int)200).entity((Object)("Deleted shapeID: " + shapeID)).build();
    }

    @DELETE
    @Path(value="deleteShapes")
    @Transactional(rollbackFor={Exception.class})
    public Response deleteShapes(@FormParam(value="shapeIDs") String shapeIDsJSON) throws Exception {
        2 mappingType = new /* Unavailable Anonymous Inner Class!! */;
        List shapeIDs = (List)this.mapper.readValue(shapeIDsJSON, (TypeReference)mappingType);
        for (String shapeID : shapeIDs) {
            this.shapeDao.deleteByShapeID(UUID.fromString(shapeID));
        }
        return Response.status((int)200).entity((Object)("{\"msg\":\"Deleted shapeIDs: " + shapeIDs + "\"}")).build();
    }

    @DELETE
    @Path(value="deleteLayer/{layerID}")
    @Transactional(rollbackFor={Exception.class})
    public Response deleteLayer(@PathParam(value="layerID") String layerID) throws Exception {
        this.shapeDao.deleteShapesOfLayer(UUID.fromString(layerID));
        return Response.status((int)200).entity((Object)("Deleted layerID: " + layerID)).build();
    }

    @POST
    @Path(value="insertShapes")
    @Transactional(rollbackFor={Exception.class})
    public Response insertShapes(@FormParam(value="shapeMessengerListJSON") String shapeMessengerListJSON) throws Exception {
        try {
            3 mappingType = new /* Unavailable Anonymous Inner Class!! */;
            List shapeMessengers = (List)this.mapper.readValue(shapeMessengerListJSON, (TypeReference)mappingType);
            List shapes = shapeMessengers.stream().map(shapeMessenger -> {
                try {
                    return shapeMessenger.toShape();
                }
                catch (Exception e) {
                    return new Shape();
                }
            }).collect(Collectors.toList());
            for (Shape shape2 : shapes) {
                this.shapeDao.create((Entity)shape2);
            }
            return Response.status((int)201).entity((Object)("Inserted the " + shapes.size() + " following shapes (IDs): " + shapes.parallelStream().map(shape -> shape.getId().toString()).collect(Collectors.toList()))).build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.status((int)400).entity((Object)"Could not insert the shape").build();
        }
    }

    @POST
    @Path(value="insertShape")
    @Transactional(rollbackFor={Exception.class})
    public Response insertShape(@FormParam(value="shapeMessengerJSON") String shapeMessengerJSON) throws Exception {
        System.out.println(shapeMessengerJSON);
        try {
            ShapeMessenger sm = (ShapeMessenger)this.mapper.readValue(shapeMessengerJSON, ShapeMessenger.class);
            Shape shape = sm.toShape();
            this.shapeDao.create((Entity)shape);
            return Response.status((int)201).entity((Object)("Created shape with ID: " + shape.getId())).build();
        }
        catch (Exception ex) {
            return Response.status((int)400).entity((Object)"Could not insert the shape").build();
        }
    }

    @POST
    @Path(value="updateShape")
    @Transactional(rollbackFor={Exception.class})
    public Response updateShape(@FormParam(value="shapeMessengerJSON") String shapeMessengerJSON) {
        try {
            ShapeMessenger sm = (ShapeMessenger)this.mapper.readValue(shapeMessengerJSON, ShapeMessenger.class);
            Shape shape = sm.toShape();
            this.shapeDao.update((Entity)shape);
            return Response.status((int)201).entity((Object)("Updated shape with ID: " + shape.getId())).build();
        }
        catch (Exception ex) {
            return Response.status((int)400).entity((Object)"Could not update the shape").build();
        }
    }

    @POST
    @Path(value="searchShapes")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response searchShapes(@FormParam(value="termsListJSON") String termsListJSON) {
        4 mappingType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            List terms = (List)this.mapper.readValue(termsListJSON, (TypeReference)mappingType);
            List smList = Transforming.fromShape((List)this.shapeDao.searchShapes(terms));
            return Response.ok().entity((Object)this.mapper.writeValueAsString((Object)smList)).build();
        }
        catch (IOException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Not a valid json. Could not parse it").build();
        }
    }

    @POST
    @Path(value="searchShapesWithinByAttributes")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response searchShapesWithinByAttributes(@FormParam(value="attrsJSON") String attrsJSON, @FormParam(value="shapeMessengerJSON") String shapeMessengerJSON) {
        5 attrsType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            Map attrs = (Map)this.mapper.readValue(attrsJSON, (TypeReference)attrsType);
            Shape shapeInput = ((ShapeMessenger)this.mapper.readValue(shapeMessengerJSON, ShapeMessenger.class)).toShape();
            List smList = Transforming.fromShape((List)this.shapeDao.searchShapesWithinByAttributes(attrs, shapeInput));
            return Response.ok().entity((Object)this.mapper.writeValueAsString((Object)smList)).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Not valid json parameters. Could not parse them").build();
        }
    }

    @POST
    @Path(value="findContains")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response findContains(@FormParam(value="shapeMessengerJSON") String shapeMessengerJSON) {
        try {
            Shape shape = ((ShapeMessenger)this.mapper.readValue(shapeMessengerJSON, ShapeMessenger.class)).toShape();
            List smList = Transforming.fromShape((List)this.shapeDao.findContains(shape));
            return Response.ok().entity((Object)this.mapper.writeValueAsString((Object)smList)).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Not valid json parameters. Could not parse them").build();
        }
    }

    @POST
    @Path(value="findWithin")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response findWithin(@FormParam(value="shapeMessengerJSON") String shapeMessengerJSON) {
        try {
            Shape shape = ((ShapeMessenger)this.mapper.readValue(shapeMessengerJSON, ShapeMessenger.class)).toShape();
            List smList = Transforming.fromShape((List)this.shapeDao.findWithin(shape));
            return Response.ok().entity((Object)this.mapper.writeValueAsString((Object)smList)).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Not valid json parameters. Could not parse them").build();
        }
    }

    @GET
    @Path(value="shapesOfLayerID/{layerID}")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response shapesOfLayerID(@PathParam(value="layerID") String layerID) throws JsonProcessingException {
        UUID layerUUID = null;
        try {
            layerUUID = UUID.fromString(layerID);
        }
        catch (IllegalArgumentException ex) {
            return Response.status((int)400).entity((Object)("That's not a valid 'layerID'. Used: " + layerID)).build();
        }
        List smList = Transforming.fromShape((List)this.shapeDao.findShapesOfLayer(layerUUID));
        return Response.ok().entity((Object)this.mapper.writeValueAsString((Object)smList)).build();
    }

    @POST
    @Path(value="getAttributeValuesOfShapesByLayer")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response getAttributeValuesOfShapesByLayer(@PathParam(value="layerID") String layerID, @FormParam(value="attributeJSON") String attributeJSON) throws IOException {
        Shape.Attribute attribute = (Shape.Attribute)this.mapper.readValue(attributeJSON, Shape.Attribute.class);
        return Response.status((int)200).entity((Object)this.mapper.writeValueAsString((Object)this.shapeDao.getAttributeValuesOfShapesByLayer(UUID.fromString(layerID), attribute))).build();
    }

    @GET
    @Path(value="existingLayerIDs")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(readOnly=true)
    public Response existingLayerIDs() throws JsonProcessingException {
        return Response.status((int)201).entity((Object)this.mapper.writeValueAsString((Object)this.shapeDao.getAllLayerIDs())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="applyOnView")
    @Produces(value={"application/xml", "application/json"})
    @Transactional(rollbackFor={Exception.class})
    public Response applyOnView(@FormParam(value="statement") String statement) {
        Connection con = null;
        Statement st = null;
        try {
            con = DriverManager.getConnection(this.dataLayerConfig.getDbUrl(), this.dataLayerConfig.getDbUser(), this.dataLayerConfig.getDbPass());
            st = con.createStatement();
            st.executeUpdate(statement);
        }
        catch (SQLException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could NOT create view on gos node " + this.dataStoreConfig.getHost() + ":" + this.dataStoreConfig.getPort())).build();
            return response;
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("Created successfully view on gos node " + this.dataStoreConfig.getHost() + ":" + this.dataStoreConfig.getPort())).build();
    }

    @GET
    @Path(value="ping")
    public Response ping() {
        return Response.status((int)200).entity((Object)"GOS SERIVICE IS UP").build();
    }

    static /* synthetic */ ObjectMapper access$000(ShapeManagementResource x0) {
        return x0.mapper;
    }

    static /* synthetic */ DataCreatorGos access$100(ShapeManagementResource x0) {
        return x0.dataCreatorGos;
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }
}

