/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.geoanalytics.context.GeoServerBridgeConfig;
import gr.cite.geoanalytics.dataaccess.entities.coverage.Coverage;
import gr.cite.geoanalytics.dataaccess.entities.layer.DataSource;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.SystemPresentationConfig;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.GeoServerBridge;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.DataStore;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.GeoserverLayer;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.PublishConfig;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.exception.GeoServerBridgeException;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.geoservermanager.geowebcache.GwcClient;
import gr.cite.gos.environment.EnvironmentInitializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Path(value="/GeoserverManagement")
public class GeoServerManagementResource {
    private EnvironmentInitializer environmentInitializer;
    private GeoServerBridgeConfig configuration;
    private GeoServerBridge geoserverBridge;
    private GwcClient gwcClient;
    private ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(GeoServerManagementResource.class);

    public GeoServerManagementResource(GeoServerBridge geoserverBridge, GeoServerBridgeConfig configuration, GwcClient gwcClient) throws Exception {
        this.geoserverBridge = geoserverBridge;
        this.configuration = configuration;
        this.gwcClient = gwcClient;
    }

    @Inject
    public void setEnvironmentInitializer(EnvironmentInitializer environmentInitializer) {
        this.environmentInitializer = environmentInitializer;
    }

    @POST
    @Path(value="initializeEnvironment")
    public Response initializeEnvironment(@FormParam(value="layerConfigsJSON") String layerConfigsJSON, @FormParam(value="systemPresentationConfigJSON") String systemPresentationConfigJSON, @FormParam(value="stylesJSON") String stylesJSON) {
        try {
            SystemPresentationConfig systemPresentationConfig = (SystemPresentationConfig)this.mapper.readValue(systemPresentationConfigJSON, SystemPresentationConfig.class);
            List layerConfigs = (List)this.mapper.readValue(layerConfigsJSON, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List styles = (List)this.mapper.readValue(stylesJSON, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.environmentInitializer.initializeGeoserverEnvironment(layerConfigs, systemPresentationConfig, styles);
            return Response.status((int)200).entity((Object)"Initialized geoserver successfully").build();
        }
        catch (Exception e) {
            logger.error("Could not initialize geoserver", (Throwable)e);
            return Response.status((int)500).entity((Object)"Could not initialize geoserver").build();
        }
    }

    @DELETE
    @Path(value="deleteGeoserverLayer/{layerName}/{layerId}/{dataSource}")
    @Produces(value={"application/json"})
    public Response deleteLayer(@PathParam(value="layerName") String layerName, @PathParam(value="layerId") String layerId, @PathParam(value="dataSource") DataSource dataSource) throws IOException {
        try {
            this.geoserverBridge.deleteLayer(layerId, layerName, dataSource);
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).entity((Object)("Could not delete layer with ID " + layerId + " from geoserver")).build();
        }
        return Response.status((int)200).entity((Object)("Layer with id " + layerId + " was deleted on this geoserver")).build();
    }

    @POST
    @Path(value="addDataStore")
    public Response addDataStore(@FormParam(value="dataStore") String dataStoreJSON) {
        try {
            DataStore dataStore = (DataStore)this.mapper.readValue(dataStoreJSON, DataStore.class);
            this.geoserverBridge.addDataStore(dataStore);
            return Response.status((int)201).entity((Object)("Created datastore with name: " + dataStore.getDataStoreName())).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).entity((Object)("Could not add to geoserver the datastore: " + dataStoreJSON)).build();
        }
    }

    @POST
    @Path(value="addGeoserverLayerFromConfig")
    public Response addGeoserverLayerFromConfig(@FormParam(value="layerConfigJSON") String layerConfigJSON, @FormParam(value="slds") String sldsJSON, @FormParam(value="crs") String crs, @FormParam(value="style") String style) {
        GeoserverLayer geoserverLayer = new GeoserverLayer();
        FeatureType featureType = new FeatureType();
        try {
            LayerConfig layerConfig = (LayerConfig)this.mapper.readValue(layerConfigJSON, LayerConfig.class);
            Bounds b = new Bounds(layerConfig.getBoundingBox().getMinY(), layerConfig.getBoundingBox().getMinY(), layerConfig.getBoundingBox().getMaxX(), layerConfig.getBoundingBox().getMaxY(), crs);
            featureType.setDatastore(this.configuration.getPostgisDataStoreConfig().getDataStoreName());
            featureType.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
            featureType.setEnabled(true);
            featureType.setName(layerConfig.getLayerId());
            featureType.setTitle(layerConfig.getName());
            featureType.setSrs("EPSG:4326");
            featureType.setNativeCRS("EPSG:4326");
            featureType.setNativeBoundingBox(b);
            featureType.setLatLonBoundingBox(b);
            geoserverLayer.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
            geoserverLayer.setDatastore(this.configuration.getPostgisDataStoreConfig().getDataStoreName());
            geoserverLayer.setEnabled(true);
            geoserverLayer.setDefaultStyle(style);
            geoserverLayer.setId(layerConfig.getLayerId());
            geoserverLayer.setTitle(layerConfig.getName());
            geoserverLayer.setType("VECTOR");
            Integer minScale = layerConfig.getMinScale();
            Integer maxScale = layerConfig.getMaxScale();
            Map slds = (Map)this.mapper.readValue(sldsJSON, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (minScale == null && maxScale == null) {
                this.geoserverBridge.addGeoserverLayer(geoserverLayer, featureType, slds);
            } else {
                this.geoserverBridge.addGeoserverLayer(geoserverLayer, featureType, slds, minScale, maxScale);
            }
            return Response.status((int)201).entity((Object)("Created geoserver layer with id: " + geoserverLayer.getId())).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).entity((Object)("Could not create geoserver layer: " + geoserverLayer)).build();
        }
    }

    @POST
    @Path(value="addGeoserverLayer")
    public Response addGeoserverLayer(@FormParam(value="geoserverLayer") String geoserverLayerJSON, @FormParam(value="ft") String ftJSON, @FormParam(value="slds") String sldsJSON, @FormParam(value="minScale") Integer minScale, @FormParam(value="maxScale") Integer maxScale) {
        try {
            GeoserverLayer geoserverLayer = (GeoserverLayer)this.mapper.readValue(geoserverLayerJSON, GeoserverLayer.class);
            FeatureType ft = (FeatureType)this.mapper.readValue(ftJSON, FeatureType.class);
            ft.setDatastore(this.configuration.getPostgisDataStoreConfig().getDataStoreName());
            ft.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
            geoserverLayer.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
            geoserverLayer.setDatastore(this.configuration.getPostgisDataStoreConfig().getDataStoreName());
            Map slds = (Map)this.mapper.readValue(sldsJSON, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (minScale == null && maxScale == null) {
                this.geoserverBridge.addGeoserverLayer(geoserverLayer, ft, slds);
            } else {
                this.geoserverBridge.addGeoserverLayer(geoserverLayer, ft, slds, minScale, maxScale);
            }
            return Response.status((int)201).entity((Object)("Created geoserver layer with id: " + geoserverLayer.getId())).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).entity((Object)("Could not create geoserver layer: " + geoserverLayerJSON)).build();
        }
    }

    @POST
    @Path(value="addLayerStyle")
    public Response addLayerStyle(@FormParam(value="layerName") String layerName, @FormParam(value="styleName") String styleName, @FormParam(value="sld") String sld, @FormParam(value="minScale") Integer minScale, @FormParam(value="maxScale") Integer maxScale) {
        try {
            if (minScale == null && maxScale == null) {
                this.geoserverBridge.addLayerStyle(layerName, styleName, sld);
            } else {
                this.geoserverBridge.addLayerStyle(layerName, styleName, sld, minScale, maxScale);
            }
            return Response.status((int)201).entity((Object)("Added style " + styleName + " on layer " + layerName)).build();
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).entity((Object)("Could not add style " + styleName + " on layer " + layerName)).build();
        }
    }

    @POST
    @Path(value="addStyle")
    public Response addStyle(@FormParam(value="styleName") String styleName, @FormParam(value="sld") String sld, @FormParam(value="minScale") Integer minScale, @FormParam(value="maxScale") Integer maxScale) {
        try {
            if (minScale == null && maxScale == null) {
                this.geoserverBridge.addStyle(styleName, sld);
            } else {
                this.geoserverBridge.addStyle(styleName, sld, minScale, maxScale);
            }
            return Response.status((int)201).entity((Object)("Added style " + styleName)).build();
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).entity((Object)("Could not add style " + styleName)).build();
        }
    }

    @POST
    @Path(value="addStyleIcons")
    @Consumes(value={"multipart/form-data"})
    public Response addStyleIcons(FormDataMultiPart multiPart) {
        List bodyParts = multiPart.getFields("files");
        FormDataBodyPart name = multiPart.getField("name");
        for (int i = 0; i < bodyParts.size(); ++i) {
            BodyPartEntity bodyPartEntity = (BodyPartEntity)((FormDataBodyPart)bodyParts.get(i)).getEntity();
            String fileName = ((FormDataBodyPart)bodyParts.get(i)).getContentDisposition().getFileName();
            InputStream initialStream = null;
            FileOutputStream outputStream = null;
            try {
                initialStream = bodyPartEntity.getInputStream();
                File targetFile = new File(fileName);
                outputStream = new FileOutputStream(targetFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = initialStream.read(bytes)) != -1) {
                    ((OutputStream)outputStream).write(bytes, 0, read);
                }
                this.geoserverBridge.addStyleIcon(fileName, targetFile);
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Response.status((int)201).entity((Object)("Added style " + name.getValue())).build();
    }

    @POST
    @Path(value="addWorkspace")
    public Response addWorkspace(@FormParam(value="name") String name, @FormParam(value="uri") String uri) {
        try {
            if (uri == null) {
                this.geoserverBridge.addWorkspace(name);
            } else {
                this.geoserverBridge.addWorkspace(name, uri);
            }
            return Response.status((int)201).entity((Object)("Added workspace " + name)).build();
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).entity((Object)("Could not add workspace " + name)).build();
        }
    }

    @POST
    @Path(value="dataStoreExists")
    public Response dataStoreExists(@FormParam(value="workspaceName") String workspaceName, @FormParam(value="dataStoreName") String dataStoreName) {
        try {
            Boolean dataStoreExists = this.geoserverBridge.dataStoreExists(workspaceName, dataStoreName);
            return Response.status((int)200).entity((Object)dataStoreExists).build();
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getDataStore/{dataStoreName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getDataStore(@PathParam(value="dataStoreName") String dataStoreName) {
        try {
            String dataStoreJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.getDataStore(dataStoreName));
            return Response.status((int)200).entity((Object)dataStoreJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getFeatureType/{name}")
    @Produces(value={"application/xml", "application/json"})
    public Response getFeatureType(@PathParam(value="name") String name) {
        try {
            String featureTypeJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.getFeatureType(name));
            return Response.status((int)200).entity((Object)featureTypeJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getLayerType/{name}")
    @Produces(value={"application/xml", "application/json"})
    public Response getLayerType(@PathParam(value="name") String name) {
        try {
            String featureTypeJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.getLayerType(name));
            return Response.status((int)200).entity((Object)featureTypeJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getGeoserverLayer/{name}")
    @Produces(value={"application/xml", "application/json"})
    public Response getGeoserverLayer(@PathParam(value="name") String name) {
        try {
            String geoserverLayerJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.getGeoserverLayer(name));
            return Response.status((int)200).entity((Object)geoserverLayerJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getGeoserverLayers")
    @Produces(value={"application/xml", "application/json"})
    public Response getGeoserverLayers() {
        try {
            String geoserverLayersJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.getGeoserverLayers());
            return Response.status((int)200).entity((Object)geoserverLayersJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getGeoserverLayers/{datastoreName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getGeoserverLayersOfDataStore(@PathParam(value="datastoreName") String datastoreName) {
        try {
            String geoserverLayersOfDataStoreJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.getGeoserverLayersOfDataStore(datastoreName));
            return Response.status((int)200).entity((Object)geoserverLayersOfDataStoreJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getStyle/{name}")
    @Produces(value={"application/xml", "application/json"})
    public Response getStyle(@PathParam(value="name") String name) {
        try {
            String style = this.geoserverBridge.getStyle(name);
            return Response.status((int)200).entity((Object)style).build();
        }
        catch (GeoServerBridgeException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getAllStyles")
    @Produces(value={"application/xml", "application/json"})
    public Response getAllStyles() {
        try {
            List styles = this.geoserverBridge.getAllStyles();
            String listStylesJSON = this.mapper.writeValueAsString((Object)styles);
            System.out.println("THE STYLES:" + listStylesJSON);
            return Response.status((int)200).entity((Object)listStylesJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            System.out.println("THE STYLES FAILED");
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="listDataStores")
    @Produces(value={"application/xml", "application/json"})
    public Response listDataStores() {
        try {
            String listDataStoresJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.listDataStores());
            return Response.status((int)200).entity((Object)listDataStoresJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="listLayers")
    @Produces(value={"application/xml", "application/json"})
    public Response listLayers() {
        try {
            String listLayersJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.listLayers());
            return Response.status((int)200).entity((Object)listLayersJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="listLayersOfDataStore/{name}")
    @Produces(value={"application/xml", "application/json"})
    public Response listLayersOfDataStore(@PathParam(value="name") String name) {
        try {
            String listLayersOfDataStoreJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.listLayersOfDataStore(name));
            return Response.status((int)200).entity((Object)listLayersOfDataStoreJSON).build();
        }
        catch (GeoServerBridgeException | IOException e) {
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="removeLayerStyle")
    public Response removeLayerStyle(@FormParam(value="layerName") String layerName, @FormParam(value="styleName") String styleName, @FormParam(value="minScale") Integer minScale, @FormParam(value="maxScale") Integer maxScale) {
        try {
            if (minScale == null && maxScale == null) {
                this.geoserverBridge.removeLayerStyle(layerName, styleName);
            } else {
                this.geoserverBridge.removeLayerStyle(layerName, styleName, minScale, maxScale);
            }
            return Response.status((int)201).entity((Object)("Removed style " + styleName + " from layer " + layerName)).build();
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).entity((Object)("Could not remove style " + styleName + " from layer " + layerName)).build();
        }
    }

    @POST
    @Path(value="removeStyle")
    public Response removeStyle(@FormParam(value="styleName") String styleName, @FormParam(value="minScale") Integer minScale, @FormParam(value="maxScale") Integer maxScale) {
        try {
            if (minScale == null && maxScale == null) {
                this.geoserverBridge.removeStyle(styleName);
            } else {
                this.geoserverBridge.removeStyle(styleName, minScale, maxScale);
            }
            return Response.status((int)201).entity((Object)("Removed style " + styleName)).build();
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).entity((Object)("Could not remove style " + styleName)).build();
        }
    }

    @POST
    @Path(value="setDefaultLayerStyle")
    public Response setDefaultLayerStyle(@FormParam(value="layerName") String layerName, @FormParam(value="styleName") String styleName, @FormParam(value="sld") String sld, @FormParam(value="minScale") Integer minScale, @FormParam(value="maxScale") Integer maxScale) {
        try {
            if (minScale == null && maxScale == null) {
                this.geoserverBridge.setDefaultLayerStyle(layerName, styleName, sld);
            } else {
                this.geoserverBridge.setDefaultLayerStyle(layerName, styleName, sld, minScale, maxScale);
            }
            return Response.status((int)201).entity((Object)("Successfully set default style " + styleName + " on layer " + layerName)).build();
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).entity((Object)("Could not set default style " + styleName + " on layer " + layerName)).build();
        }
    }

    @POST
    @Path(value="workspaceExists")
    public Response workspaceExists(@FormParam(value="workspaceName") String workspaceName) {
        try {
            Boolean workspaceExists = this.geoserverBridge.workspaceExists(workspaceName);
            return Response.status((int)200).entity((Object)workspaceExists).build();
        }
        catch (GeoServerBridgeException ex) {
            return Response.status((int)500).entity((Object)new Boolean(false)).build();
        }
    }

    @GET
    @Path(value="getGeoTIFFPublishConfig/{layerId}")
    @Produces(value={"application/json"})
    public Response getGeoTIFFPublishConfig(@PathParam(value="layerId") String layerId) {
        String publishConfigJSON = null;
        try {
            publishConfigJSON = this.mapper.writeValueAsString((Object)this.geoserverBridge.getGeoTIFFPublishConfig(layerId));
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
        return Response.status((int)200).entity((Object)publishConfigJSON).build();
    }

    @POST
    @Path(value="publishGeoTIFF")
    @Consumes(value={"multipart/form-data"})
    public Response publishGeoTIFF(@FormDataParam(value="file") InputStream geotiff, @FormDataParam(value="coverage") String fileMetaData, @FormDataParam(value="publishConfig") String publishConfigJson) throws Exception {
        try {
            PublishConfig publishConfig = (PublishConfig)this.mapper.readValue(publishConfigJson, PublishConfig.class);
            Coverage coverage = (Coverage)this.mapper.readValue(fileMetaData, Coverage.class);
            Assert.notNull((Object)publishConfig, (String)"");
            this.geoserverBridge.publishGeoTIFF(publishConfig, coverage, geotiff);
        }
        catch (GeoServerBridgeException e) {
            logger.error(null, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="seedGeoTIFF/{layerName}")
    public Response seedGeoTIFFToGCW(@FormParam(value="seedRequest") String seedRequest, @PathParam(value="layerName") String layerName) throws Exception {
        try {
            Assert.notNull((Object)seedRequest, (String)"");
            logger.debug("Seed request received for layer:" + layerName);
            this.gwcClient.seedGeoTIFF(seedRequest, layerName);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="getCachedLayers")
    public Response getCachedLayers() {
        try {
            logger.debug("Request received for cached layers");
            return this.gwcClient.getCachedLayers();
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

