package gr.cite.geoanalytics.client;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response.Status;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.geotools.geojson.feature.FeatureJSON;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.RequestEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.vividsolutions.jts.geom.Geometry;

import gr.cite.clustermanager.exceptions.NoAvailableGos;
import gr.cite.clustermanager.model.GosDefinition;
import gr.cite.clustermanager.trafficshaping.SimpleTrafficShaper;
import gr.cite.clustermanager.trafficshaping.TrafficShaper;
import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.GeoserverLayer;
import gr.cite.gos.client.ShapeManagement;

public class GeoanalyticsImportManagement extends GeoanalyticsManagement implements Serializable{

	
	public GeoanalyticsImportManagement(){}
	
	public GeoanalyticsImportManagement(String authenticationStr){
		super(authenticationStr);
	}
	
	
//	public static void main (String args[]){
//		GeoanalyticsImportManagement gim = new GeoanalyticsImportManagement("token-value-here");
//		gim.createDummyLayer("http://localhost:8080/geoanalytics");
//		gim.deleteDummyLayer("http://localhost:8080/geoanalytics");
//	}
//	
//	public void createDummyLayer(String geoanalyticsEndpoint){
//		Layer layer = new Layer();
//		layer.setName("dummylayer-"+System.currentTimeMillis());
//		layer.setDescription("dummylayer");
//		String layerID = createLayer(geoanalyticsEndpoint, layer);
//	}
//	
//	public void deleteDummyLayer(String geoanalyticsEndpoint){
//		Layer layer = new Layer();
//		layer.setId(UUID.fromString("cb1a36b6-6b21-4528-9269-7975128618f3"));
//		String resp = deleteLayer(geoanalyticsEndpoint, layer);
//		System.out.println(resp);
//	}
	
	
	
	
	public void importLayerFromRDD(String geoanalyticsEndpoint, String gosEndpoint, String layerName, JavaRDD<List<ShapeMessenger>> featuresRDD, String srid) throws Exception{
		

		JavaSparkContext jsc = new JavaSparkContext(featuresRDD.context());
		
		if(geoanalyticsEndpoint==null || geoanalyticsEndpoint.isEmpty() || gosEndpoint==null || gosEndpoint.isEmpty())
			throw new Exception("No gos or geoanalytics endpoint were correct: geoanalyticsEP="+geoanalyticsEndpoint+" gosEP="+gosEndpoint);
		
		//create Layer on geoanalytics
		Layer layer = new Layer();
		layer.setIsTemplate((short)0);
		layer.setDescription("This layer is generated by geoanalytics functions");
//		GeocodeSystem geosys = new GeocodeSystem();
//		geosys.setName(srid);
//		layer.setGeocodeSystem(geosys);
		layer.setReplicationFactor(1);
		
		String layerID = createLayer(geoanalyticsEndpoint, layer);
		
		if(layerID==null || layerID.isEmpty()) //no layer was created, so it can't proceed.
			return;
		
		layer.setId(UUID.fromString(layerID));
		
		
		Broadcast<String> sridBC = jsc.broadcast(srid);
		Broadcast<String> layerIdBC = jsc.broadcast(layerID);
		Broadcast<String> authStrBC = jsc.broadcast(authenticationStr);
//		Broadcast<String> geoanalyticsEndpointBC = jsc.broadcast(geoanalyticsEndpoint);
		Broadcast<String> gosEndpointBC = jsc.broadcast(gosEndpoint);
		
		
		Set<Boolean> results = featuresRDD
				.map(new Function<List<ShapeMessenger>, Set<Boolean>>() {

					private static final long serialVersionUID = -8923332794337126038L;

					@Override
					public Set<Boolean> call(List<ShapeMessenger> shapeMessengers) throws Exception {
						
						//transform to List<Shape>
						List<Shape> shapes = shapeMessengers.stream()
						.map(shapeMessenger -> {
							try{
								
								Shape shape = shapeMessenger.toShape();
								shape.setLayerID(UUID.fromString(layerIdBC.value())); //this is very important
								
								System.out.println(shape.getId().toString());
								
								
								return (Shape) shape;
							}
							catch(Exception e){
								System.out.println("AN error occured: "+e.getMessage());
								return null;
							}
						})
						.collect(Collectors.toList());
						
						//insert into geoanalytics
						ShapeManagement shapeManagement = new ShapeManagement(authStrBC.getValue());
						boolean status = false;
						try{
							status = shapeManagement.insertShapes(gosEndpointBC.getValue(), shapes);
						}
						catch(Exception ex){ //return false
							return new HashSet<Boolean>(Arrays.asList(new Boolean(false)));
						}
						
						//determine the status (true/false)
						return new HashSet<Boolean>(Arrays.asList(new Boolean(status)));
						
					}
				})
				.reduce((resultsL,resultsR) -> {
						Set<Boolean> merged = new HashSet<Boolean>();
						merged.addAll(resultsL);
						merged.addAll(resultsR);
						return (HashSet<Boolean>) merged;
				});
		
		//if successful, create also the Layer on geoanalytics db, else rollback the shapes on GOS
		if(results.contains(new Boolean(false))){
			//means that there was at least one failed on executors, so rollback
			
			//delete from geoserver layer mappings
			
			//delete layer view
			
			//delete shapes
			ShapeManagement shapeManagement = new ShapeManagement(authenticationStr);
			shapeManagement.deleteShapesOfLayer(gosEndpoint, layerID);
			//delete layer
			deleteLayer(geoanalyticsEndpoint, layer);
		}
		else {
			//means that all were successful, so go on with the remaining layer creation (create views, create geoserver entries, etc)
			//create layer view
			
			//create geoserver layer mapping
			
		}
		
		

		
		
	}
	
	
	public String createLayer(String geoanalyticsEndpoint, Layer layer){
		
		MultiValueMap<String, String> headers = new LinkedMultiValueMap<String, String>();
		headers.add(super.HEADER_AUTHENTICATION_PARAM_NAME, authenticationStr);
		headers.add("Content-Type", "application/json");

		RestTemplate restTemplate = new RestTemplate();
		restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
		HttpEntity<Layer> request = new HttpEntity<Layer>( layer, headers);
		return restTemplate.postForObject(geoanalyticsEndpoint+"/createLayerSpark", request, String.class);
		
	}
	
	
	public String deleteLayer(String geoanalyticsEndpoint, Layer layer) {
		
		MultiValueMap<String, String> headers = new LinkedMultiValueMap<String, String>();
		headers.add(super.HEADER_AUTHENTICATION_PARAM_NAME, authenticationStr);
		headers.add("Content-Type", "application/json");

		RestTemplate restTemplate = new RestTemplate();
		restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
		HttpEntity<Layer> request = new HttpEntity<Layer>( layer, headers);
		return restTemplate.postForObject(geoanalyticsEndpoint+"/deleteLayerSpark", request, String.class);
	}
	
}
