/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.client;

import gr.cite.clustermanager.actuators.functions.ExecutionMonitor;
import gr.cite.clustermanager.actuators.functions.ExecutionNotifier;
import gr.cite.clustermanager.actuators.layers.DataCreatorGeoanalytics;
import gr.cite.clustermanager.model.functions.ExecutionDetails;
import gr.cite.clustermanager.model.functions.ExecutionStatus;
import gr.cite.clustermanager.model.layers.GosDefinition;
import gr.cite.clustermanager.model.layers.ZNodeData;
import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.geoanalytics.client.GeoanalyticsManagement;
import gr.cite.geoanalytics.client.Mapper;
import gr.cite.geoanalytics.client.Reducer;
import gr.cite.geoanalytics.dataaccess.entities.layer.DataSource;
import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import gr.cite.geoanalytics.dataaccess.entities.layer.LayerTenant;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectLayer;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.GeoserverLayer;
import gr.cite.gos.client.GeoserverManagement;
import gr.cite.gos.client.ShapeManagement;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.broadcast.Broadcast;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class GeoanalyticsImportManagement
extends GeoanalyticsManagement
implements Serializable {
    private static final long serialVersionUID = -217872471686069616L;
    @Autowired
    private DataCreatorGeoanalytics dataCreatorGeoanalytics;
    @Autowired
    private ExecutionNotifier executionNotifier;
    @Autowired
    private ExecutionMonitor executionMonitor;

    private GeoanalyticsImportManagement() {
    }

    public GeoanalyticsImportManagement(String authenticationStr) {
        super(authenticationStr);
    }

    public void importLayerFromRDD(String executionID, String geoanalyticsEndpoint, GosDefinition gosDefinition, String layerName, String tenantID, String creatorID, String projectID, JavaRDD<List<ShapeMessenger>> featuresRDD, String srid) throws Exception {
        ExecutionDetails currentExecution = this.executionMonitor.getLatestExecutionDetailsOf(executionID);
        JavaSparkContext jsc = new JavaSparkContext(featuresRDD.context());
        if (geoanalyticsEndpoint == null || geoanalyticsEndpoint.isEmpty() || gosDefinition == null || gosDefinition.getGosEndpoint() == null || gosDefinition.getGosEndpoint().isEmpty()) {
            throw new Exception("No gos or geoanalytics endpoint were correct: geoanalyticsEP=" + geoanalyticsEndpoint + " gosEP=" + gosDefinition.getGosEndpoint());
        }
        Layer layer = new Layer();
        layer.setIsTemplate((short)0);
        layer.setName(layerName);
        layer.setDataSource(DataSource.PostGIS);
        layer.setDescription("This layer is generated by geoanalytics functions");
        layer.setReplicationFactor(Integer.valueOf(1));
        Principal principal = new Principal();
        principal.setId(UUID.fromString(creatorID));
        layer.setCreator(principal);
        HashSet<LayerTenant> layerTenants = new HashSet<LayerTenant>();
        LayerTenant lt = new LayerTenant();
        Tenant t = new Tenant();
        t.setId(UUID.fromString(tenantID));
        lt.setTenant(t);
        layerTenants.add(lt);
        layer.setLayerTenants(layerTenants);
        Project project = new Project();
        project.setId(UUID.fromString(projectID));
        project.setIsTemplate(false);
        HashSet<ProjectLayer> projectLayers = new HashSet<ProjectLayer>();
        ProjectLayer pl = new ProjectLayer();
        pl.setProject(project);
        projectLayers.add(pl);
        layer.setProjectLayers(projectLayers);
        String layerID = this.createLayer(geoanalyticsEndpoint, layer);
        if (layerID == null || layerID.isEmpty()) {
            throw new Exception("Error while creating the layer on Geoanalytics to host the results of the analytics function... Will not proceed with function execution!");
        }
        layer.setId(UUID.fromString(layerID));
        Broadcast sridBC = jsc.broadcast((Object)srid);
        Broadcast layerIdBC = jsc.broadcast((Object)layerID);
        Broadcast creatorIdBC = jsc.broadcast((Object)creatorID);
        Broadcast authStrBC = jsc.broadcast((Object)this.authenticationStr);
        Broadcast gosDefinitionBC = jsc.broadcast((Object)gosDefinition);
        Set results = (Set)featuresRDD.map((Function)new Mapper((String)layerIdBC.getValue(), (String)creatorIdBC.getValue(), (String)authStrBC.getValue(), ((GosDefinition)gosDefinitionBC.getValue()).getGosEndpoint())).reduce((Function2)new Reducer());
        if (results.contains(new Boolean(false))) {
            ShapeManagement sm = new ShapeManagement(this.authenticationStr);
            GeoserverManagement gm = new GeoserverManagement(this.authenticationStr);
            gm.deleteGeoserverLayer(gosDefinition.getGosEndpoint(), layerID, layer.getDataSource());
            sm.applyOnView(gosDefinition.getGosEndpoint(), this.viewDeletion(layerID));
            sm.deleteShapesOfLayer(gosDefinition.getGosEndpoint(), layerID);
            this.deleteLayer(geoanalyticsEndpoint, layer);
            currentExecution.setProgress(Integer.valueOf(100));
            currentExecution.setStopTimestamp(Long.valueOf(System.currentTimeMillis()));
            currentExecution.setStatus(ExecutionStatus.FAILED);
            this.executionNotifier.notifyAbout(currentExecution);
            throw new Exception("Error while doing the computations for the analytics... Performed a rollback!");
        }
        ShapeManagement sm = new ShapeManagement(this.authenticationStr);
        sm.applyOnView(gosDefinition.getGosEndpoint(), this.viewCreation(layerID, "numeric"));
        this.addGeoserverLayer(gosDefinition, layerID, "point");
        this.dataCreatorGeoanalytics.addLayer(layerID, ZNodeData.ZNodeStatus.ACTIVE, gosDefinition.getGosIdentifier());
        currentExecution.setProgress(Integer.valueOf(100));
        currentExecution.setStopTimestamp(Long.valueOf(System.currentTimeMillis()));
        currentExecution.setStatus(ExecutionStatus.SUCCEEDED);
        currentExecution.setLayerID(layerID);
        this.executionNotifier.notifyAbout(currentExecution);
    }

    public String createLayer(String geoanalyticsEndpoint, Layer layer) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        headers.add((Object)"Content-Type", (Object)"application/json");
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        HttpEntity request = new HttpEntity((Object)layer, (MultiValueMap)headers);
        return (String)restTemplate.postForObject(geoanalyticsEndpoint + "/createLayerSpark", (Object)request, String.class, new Object[0]);
    }

    public String deleteLayer(String geoanalyticsEndpoint, Layer layer) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        headers.add((Object)"Content-Type", (Object)"application/json");
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        HttpEntity request = new HttpEntity((Object)layer, (MultiValueMap)headers);
        return (String)restTemplate.postForObject(geoanalyticsEndpoint + "/deleteLayerSpark", (Object)request, String.class, new Object[0]);
    }

    public String viewCreation(String layerID, String valueDatatype) {
        return "CREATE MATERIALIZED VIEW \"" + layerID + "\" AS SELECT s.\"SHP_Geography\"::geometry AS \"SHP_Geography\", s.\"SHP_ID\", (xpath('//extraData/function_result/text()'::text, s.\"SHP_ExtraData\"))[1]::text::" + valueDatatype + " AS value FROM \"Shape\" s  WHERE s.\"SHP_LayerID\" = '" + layerID + "'::uuid WITH DATA";
    }

    public String viewDeletion(String layerID) {
        return "DROP MATERIALIZED VIEW IF EXISTS \"" + layerID + "\"";
    }

    private void addGeoserverLayer(GosDefinition gosDefinition, String layerID, String style) throws IOException {
        Bounds boundingBox = new Bounds();
        boundingBox.setMinx(0.0);
        boundingBox.setMiny(0.0);
        boundingBox.setMaxx(180.0);
        boundingBox.setMaxy(90.0);
        boundingBox.setCrs("EPSG:4326");
        FeatureType featureType = new FeatureType();
        featureType.setDatastore(gosDefinition.getDatastoreName());
        featureType.setWorkspace(gosDefinition.getGeoserverWorkspace());
        featureType.setEnabled(true);
        featureType.setName(layerID);
        featureType.setTitle(layerID);
        featureType.setSrs("EPSG:4326");
        featureType.setNativeCRS("EPSG:4326");
        featureType.setNativeBoundingBox(boundingBox);
        featureType.setLatLonBoundingBox(boundingBox);
        GeoserverLayer geoserverLayer = new GeoserverLayer();
        geoserverLayer.setDatastore(gosDefinition.getDatastoreName());
        geoserverLayer.setWorkspace(gosDefinition.getGeoserverWorkspace());
        geoserverLayer.setEnabled(true);
        geoserverLayer.setDefaultStyle(style);
        geoserverLayer.setId(layerID);
        geoserverLayer.setTitle(layerID);
        geoserverLayer.setType("VECTOR");
        Integer minScale = null;
        Integer maxScale = null;
        HashMap<String, String> layerStyles = new HashMap<String, String>();
        layerStyles.put("point", style);
        GeoserverManagement gm = new GeoserverManagement(this.authenticationStr);
        gm.addGeoserverLayer(gosDefinition.getGosEndpoint(), geoserverLayer, featureType, layerStyles, minScale, maxScale);
    }
}

