/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.client;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import gr.cite.geoanalytics.dataaccess.entities.coverage.Coverage;
import gr.cite.gos.client.GosManagement;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class RasterManagement
extends GosManagement {
    public RasterManagement(String authenticationStr) {
        super(authenticationStr);
    }

    public void createCoverage(String gosEndpoint, Coverage coverage) throws Exception {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"coverage", (Object)this.getMapper().writeValueAsString((Object)coverage));
        ClientResponse response = (ClientResponse)this.getJerseyClient().resource(gosEndpoint).path("/RasterManagement/coverage/create").type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(ClientResponse.class, (Object)formData);
        this.errorHandling(response, Response.Status.CREATED, "Could not insert GeoTIFF image in database. GOS is unavailable");
    }

    public Coverage getGeoTIFFCoverage(String gosEndpoint, String layerId) throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/RasterManagement/coverage/get/" + layerId).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).get(ClientResponse.class);
        this.errorHandling(response, Response.Status.OK, "Could not retrieve GeoTIFF image in database. GOS is unavailable");
        return (Coverage)this.getMapper().readValue((String)response.getEntity(String.class), Coverage.class);
    }

    public void deleteCoverageOfLayer(String gosEndpoint, String layerId) throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/RasterManagement/coverage/delete/" + layerId).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).delete(ClientResponse.class);
        this.errorHandling(response, Response.Status.OK, "Could not delete GeoTIFF image from database. GOS is unavailable");
    }

    private void errorHandling(ClientResponse response, Response.Status status, String errorMessage) throws Exception {
        if (response.getStatus() != status.getStatusCode()) {
            String responseMessage = (String)response.getEntity(String.class);
            if (responseMessage == null || responseMessage.isEmpty()) {
                throw new Exception(errorMessage);
            }
            throw new Exception(responseMessage);
        }
    }
}

