/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.gos.client.GosManagement;
import gr.cite.gos.client.helpers.Transforming;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;

public class ShapeManagement
extends GosManagement {
    public ShapeManagement(String authenticationStr) {
        super(authenticationStr);
    }

    public List<String> getLayers(String gosEndpoint) throws IOException {
        String jsonLayerIds = (String)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/existingLayerIDs").header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).get(String.class);
        TypeReference<List<String>> mappingType = new TypeReference<List<String>>(){};
        return (List)this.getMapper().readValue(jsonLayerIds, (TypeReference)mappingType);
    }

    public Shape getShapeByID(String gosEndpoint, String shapeID) throws Exception {
        String shapeMessengerJSON = (String)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/getShapeByID/" + shapeID).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).get(String.class);
        return shapeMessengerJSON != null && !shapeMessengerJSON.isEmpty() ? ((ShapeMessenger)this.getMapper().readValue(shapeMessengerJSON, ShapeMessenger.class)).toShape() : null;
    }

    public boolean deleteShape(String gosEndpoint, String shapeID) throws Exception {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/deleteShape/" + shapeID).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).delete(ClientResponse.class);
        return resp.getStatus() == 200;
    }

    public boolean deleteShapes(String gosEndpoint, List<String> shapeIDs) throws JsonProcessingException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeIDs", (Object)this.getMapper().writeValueAsString(shapeIDs));
        ClientResponse resp = (ClientResponse)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/deleteShapes").accept(new String[]{"application/json"}).delete(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 200;
    }

    public List<Shape> searchShapes(String gosEndpoint, List<String> terms) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"termsListJSON", (Object)this.getMapper().writeValueAsString(terms));
        ClientResponse resp = (ClientResponse)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/searchShapes").accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)formData);
        TypeReference<ArrayList<ShapeMessenger>> mappingType = new TypeReference<ArrayList<ShapeMessenger>>(){};
        return Transforming.fromShapeMessenger((List)this.getMapper().readValue((String)resp.getEntity(String.class), (TypeReference)mappingType));
    }

    public List<Shape> searchShapesWithinByAttributes(String gosEndpoint, Map<String, Shape.Attribute> attrs, Shape shape) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"attrsJSON", (Object)this.getMapper().writeValueAsString(attrs));
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        ClientResponse resp = (ClientResponse)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/searchShapesWithinByAttributes").accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)formData);
        TypeReference<List<ShapeMessenger>> mappingType = new TypeReference<List<ShapeMessenger>>(){};
        return Transforming.fromShapeMessenger((List)this.getMapper().readValue((String)resp.getEntity(String.class), (TypeReference)mappingType));
    }

    public List<Shape> findContains(String gosEndpoint, Shape shape) throws Exception {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        String shapeMessengersJSON = (String)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/findContains").accept(new String[]{"application/json"}).post(String.class, (Object)formData);
        TypeReference<List<ShapeMessenger>> mappingType = new TypeReference<List<ShapeMessenger>>(){};
        return Transforming.fromShapeMessenger((List)this.getMapper().readValue(shapeMessengersJSON, (TypeReference)mappingType));
    }

    public List<Shape> findWithin(String gosEndpoint, Shape shape) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        String shapeMessengersJSON = (String)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/findWithin").accept(new String[]{"application/json"}).post(String.class, (Object)formData);
        TypeReference<List<Shape>> mappingType = new TypeReference<List<Shape>>(){};
        return (List)this.getMapper().readValue(shapeMessengersJSON, (TypeReference)mappingType);
    }

    public boolean insertShapes(String gosEndpoint, List<Shape> shapes) throws Exception {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerListJSON", (Object)this.getMapper().writeValueAsString(shapes.parallelStream().map(shape -> new ShapeMessenger(shape)).collect(Collectors.toList())));
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/insertShapes").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 201;
    }

    public boolean insertShape(String gosEndpoint, Shape shape) throws Exception {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/insertShape").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 201;
    }

    public boolean updateShape(String gosEndpoint, Shape shape) throws Exception {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/updateShape").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 201;
    }

    public List<Shape> getShapesOfLayerID(String gosEndpoint, String layerID) throws Exception {
        String shapeMessengerListJSON = (String)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/shapesOfLayerID/" + layerID).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).get(String.class);
        TypeReference<ArrayList<ShapeMessenger>> mappingType = new TypeReference<ArrayList<ShapeMessenger>>(){};
        return Transforming.fromShapeMessenger((List)this.getMapper().readValue(shapeMessengerListJSON, (TypeReference)mappingType));
    }

    public Set<String> getAttributeValuesOfShapesByLayer(String gosEndpoint, String layerID, Shape.Attribute attribute) throws Exception {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"attributeJSON", (Object)this.getMapper().writeValueAsString((Object)attribute));
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/getAttributeValuesOfShapesByLayer/" + layerID).accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        TypeReference<Set<String>> mappingType = new TypeReference<Set<String>>(){};
        return (Set)this.getMapper().readValue((String)resp.getEntity(String.class), (TypeReference)mappingType);
    }

    public boolean deleteShapesOfLayer(String gosEndpoint, String layerID) {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/deleteLayer/" + layerID).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).delete(ClientResponse.class);
        return resp.getStatus() == 200;
    }

    public long countShapesOfLayer(String gosEndpoint, String layerID) {
        return (Long)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/countShapesOfLayer/" + layerID).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).get(Long.class);
    }

    public boolean applyOnView(String gosEndpoint, String statement) throws Exception {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"statement", (Object)statement);
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/ShapeManagement/applyOnView").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == ClientResponse.Status.CREATED.getStatusCode();
    }
}

