/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.client;

import gr.cite.geoanalytics.dataaccess.entities.coverage.Coverage;
import gr.cite.gos.client.GosManagement;
import java.io.InputStream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

public class RasterManagement
extends GosManagement {
    public RasterManagement(String authenticationStr) {
        super(authenticationStr);
    }

    public void createCoverage(String gosEndpoint, Coverage coverage) throws Exception {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"coverage", (Object)this.getMapper().writeValueAsString((Object)coverage));
        Response response = this.getJerseyClient().target(gosEndpoint).path("/RasterManagement/coverage/create").request().post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.errorHandling(response, Response.Status.CREATED, "Could not insert GeoTIFF image in database. GOS is unavailable");
    }

    public void createCoverage(String gosEndpoint, InputStream coverageStream) throws Exception {
        Response response = this.getJerseyClient().target(gosEndpoint).path("/RasterManagement/coverage/create/stream").request().post(Entity.entity((Object)coverageStream, (String)"application/octet-stream"));
        this.errorHandling(response, Response.Status.CREATED, "Could not insert GeoTIFF image in database. GOS is unavailable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCoverage(String gosEndpoint, Coverage coverage, InputStream coverageStream) throws Exception {
        FormDataBodyPart bodyPart = null;
        FormDataMultiPart formDataMultiPart = null;
        FormDataMultiPart multipart = null;
        Response response = null;
        try {
            bodyPart = new FormDataBodyPart("file", (Object)coverageStream, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            formDataMultiPart = new FormDataMultiPart();
            multipart = (FormDataMultiPart)formDataMultiPart.field("coverage", this.getMapper().writeValueAsString((Object)coverage)).bodyPart((BodyPart)bodyPart);
            Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/RasterManagement/coverage/create").request();
            response = invocationBuilder.post(Entity.entity((Object)multipart, (String)"multipart/form-data"));
            this.errorHandling(response, Response.Status.CREATED, "Could not insert GeoTIFF image in database. GOS is unavailable");
        }
        finally {
            bodyPart.cleanup();
            formDataMultiPart.close();
            multipart.close();
            response.close();
        }
    }

    public Coverage getGeoTIFFCoverage(String gosEndpoint, String layerId) throws Exception {
        Response response = this.getJerseyClient().target(gosEndpoint).path("/RasterManagement/coverage/get/" + layerId).request().header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        this.errorHandling(response, Response.Status.OK, "Could not retrieve GeoTIFF image in database. GOS is unavailable");
        return (Coverage)this.getMapper().readValue((String)response.readEntity(String.class), Coverage.class);
    }

    public InputStream getGeoTIFFCoverageStream(String gosEndpoint, String layerId) throws Exception {
        Response response = this.getJerseyClient().target(gosEndpoint).path("/RasterManagement/coverage/get/" + layerId).request(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED_TYPE}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        this.errorHandling(response, Response.Status.OK, "Could not retrieve GeoTIFF image in database. GOS is unavailable");
        return (InputStream)response.getEntity();
    }

    public void deleteCoverageOfLayer(String gosEndpoint, String layerId) throws Exception {
        Response response = this.getJerseyClient().target(gosEndpoint).path("/RasterManagement/coverage/delete/" + layerId).request().header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).delete();
        this.errorHandling(response, Response.Status.OK, "Could not delete GeoTIFF image from database. GOS is unavailable");
    }

    private void errorHandling(Response response, Response.Status status, String errorMessage) throws Exception {
        if (response.getStatus() != status.getStatusCode()) {
            String responseMessage = (String)response.readEntity(String.class);
            if (responseMessage == null || responseMessage.isEmpty()) {
                throw new Exception(errorMessage);
            }
            throw new Exception(responseMessage);
        }
    }
}

