/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.client;

import com.fasterxml.jackson.core.type.TypeReference;
import gr.cite.gaap.datatransferobjects.LayerBean;
import gr.cite.gaap.datatransferobjects.LayerGwcAtomXML;
import gr.cite.gaap.datatransferobjects.StyleMessenger;
import gr.cite.geoanalytics.dataaccess.entities.coverage.Coverage;
import gr.cite.geoanalytics.dataaccess.entities.layer.DataSource;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.SystemPresentationConfig;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.DataStore;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.GeoserverLayer;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.LayerType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.NetCDFPublishConfig;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.PublishConfig;
import gr.cite.gos.client.GosManagement;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class GeoserverManagement
extends GosManagement {
    private static final Logger logger = LoggerFactory.getLogger(GeoserverManagement.class);

    public GeoserverManagement(String authenticationStr) {
        super(authenticationStr);
    }

    public boolean initializeEnvironment(String gosEndpoint, List<LayerConfig> layerConfigs, SystemPresentationConfig systemPresentationConfig, List<StyleMessenger> styles) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerConfigsJSON", (Object)this.getMapper().writeValueAsString(layerConfigs));
        formData.add((Object)"systemPresentationConfigJSON", (Object)this.getMapper().writeValueAsString((Object)systemPresentationConfig));
        formData.add((Object)"stylesJSON", (Object)this.getMapper().writeValueAsString(styles));
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/initializeEnvironment").request(new String[]{"application/json"});
        Response resp = invocationBuilder.post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        logger.info("Response status: " + resp.getStatus());
        return resp.getStatus() == 200;
    }

    public List<GeoserverLayer> getGeoserverLayers(String gosEndpoint) throws IOException {
        String geoserverLayersJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getGeoserverLayers").request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(String.class);
        TypeReference<List<GeoserverLayer>> mappingType = new TypeReference<List<GeoserverLayer>>(){};
        return (List)this.getMapper().readValue(geoserverLayersJSON, (TypeReference)mappingType);
    }

    public boolean deleteGeoserverLayer(String gosEndpoint, String layerName, String layerId, DataSource dataSource) throws IOException {
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/deleteGeoserverLayer/" + layerName + "/" + layerId + "/" + dataSource).request(new String[]{"application/json"});
        Response resp = invocationBuilder.header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).delete();
        return resp.getStatus() == 200;
    }

    public boolean deleteGeoserverCoverageStoreByCoverageId(String gosEndpoint, String coverageId) {
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/coverage/" + coverageId + "/coveragestore/delete/").request(new String[]{"application/json"});
        Response resp = invocationBuilder.header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).delete();
        return resp.getStatus() == 200;
    }

    public boolean geoserverCoverageStoreOfCoverageExists(String gosEndpoint, String coveragestoreId) {
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/coverage/" + coveragestoreId + "/coeveragestore/exists").request(new String[]{"application/json"});
        Response resp = invocationBuilder.header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        return resp.getStatus() == 200;
    }

    public boolean addDataStore(String gosEndpoint, DataStore datastore) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"dataStoreJSON", (Object)this.getMapper().writeValueAsString((Object)datastore));
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/addDataStore").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return resp.getStatus() == 201;
    }

    public boolean addGeoserverLayer(String gosEndpoint, LayerConfig layerConfig, Map<String, String> slds, String crs, String style) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerConfigJSON", (Object)this.getMapper().writeValueAsString((Object)layerConfig));
        formData.add((Object)"slds", (Object)this.getMapper().writeValueAsString(slds));
        formData.add((Object)"crs", (Object)crs);
        formData.add((Object)"style", (Object)style);
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/addGeoserverLayerFromConfig").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return resp.getStatus() == 201;
    }

    public boolean addGeoserverLayer(String gosEndpoint, GeoserverLayer geoserverLayer, FeatureType ft, Map<String, String> slds, Integer minScale, Integer maxScale) throws IOException {
        Response resp;
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"geoserverLayer", (Object)this.getMapper().writeValueAsString((Object)geoserverLayer));
        formData.add((Object)"ft", (Object)this.getMapper().writeValueAsString((Object)ft));
        formData.add((Object)"slds", (Object)this.getMapper().writeValueAsString(slds));
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)String.valueOf(minScale));
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)String.valueOf(maxScale));
        }
        return (resp = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/addGeoserverLayer").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE))).getStatus() == 201;
    }

    public boolean addGeoserverLayer(String gosEndpoint, GeoserverLayer geoserverLayer, FeatureType ft, Map<String, String> slds) throws IOException {
        return this.addGeoserverLayer(gosEndpoint, geoserverLayer, ft, slds, null, null);
    }

    public boolean addLayerStyle(String gosEndpoint, String layerName, String styleName, String sld, Integer minScale, Integer maxScale) throws IOException {
        Invocation.Builder invocationBuilder;
        Response resp;
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerName", (Object)layerName);
        formData.add((Object)"styleName", (Object)styleName);
        formData.add((Object)"sld", (Object)sld);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)String.valueOf(minScale));
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)String.valueOf(maxScale));
        }
        return (resp = (invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/addLayerStyle").request(new String[]{"application/json"})).post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE))).getStatus() == 201;
    }

    public boolean addLayerStyle(String gosEndpoint, String layerName, String styleName, String sld) throws IOException {
        return this.addLayerStyle(gosEndpoint, layerName, styleName, sld, null, null);
    }

    public boolean addStyle(String gosEndpoint, String styleName, String sld, Integer minScale, Integer maxScale) throws IOException {
        Invocation.Builder invocationBuilder;
        Response resp;
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"styleName", (Object)styleName);
        formData.add((Object)"sld", (Object)sld);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)String.valueOf(minScale));
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)String.valueOf(maxScale));
        }
        return (resp = (invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/addStyle").request(new String[]{"application/json"})).post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE))).getStatus() == 201;
    }

    public boolean addStyleIcons(String gosEndpoint, String styleName, List<MultipartFile> icons) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set(this.HEADER_AUTHENTICATION_PARAM_NAME, this.authenticationStr);
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        try {
            for (MultipartFile file : icons) {
                File temp = new File(file.getOriginalFilename());
                file.transferTo(temp);
                formData.add((Object)"files", (Object)new FileSystemResource(temp));
            }
        }
        catch (IOException e) {
            logger.error("Error in conversion file icon");
            e.printStackTrace();
        }
        formData.add((Object)"name", (Object)styleName);
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpEntity request = new HttpEntity((Object)formData, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.postForEntity(gosEndpoint + "/GeoserverManagement/addStyleIcons", (Object)request, String.class, new Object[0]);
            return response.getStatusCode().equals((Object)HttpStatus.CREATED);
        }
        catch (Exception e) {
            logger.error("Error sending icons to Gos");
            e.printStackTrace();
            return false;
        }
    }

    public boolean addStyle(String gosEndpoint, String styleName, String sld) throws IOException {
        return this.addStyle(gosEndpoint, styleName, sld, null, null);
    }

    public boolean addWorkspace(String gosEndpoint, String name, String uri) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"styleName", (Object)name);
        formData.add((Object)"sld", (Object)uri);
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/addWorkspace").request(new String[]{"application/json"});
        Response resp = invocationBuilder.post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return resp.getStatus() == 201;
    }

    public boolean dataStoreExists(String gosEndpoint, String workspaceName, String dataStoreName) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"workspaceName", (Object)workspaceName);
        formData.add((Object)"dataStoreName", (Object)dataStoreName);
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/dataStoreExists").request(new String[]{"application/json"});
        Response resp = invocationBuilder.post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return resp.getStatus() == 200;
    }

    public DataStore getDataStore(String gosEndpoint, String dataStoreName) throws IOException {
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getDataStore/" + dataStoreName).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        return (DataStore)this.getMapper().readValue((String)resp.readEntity(String.class), DataStore.class);
    }

    public FeatureType getFeatureType(String gosEndpoint, String name) throws IOException {
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getFeatureType/" + name).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        return (FeatureType)this.getMapper().readValue((String)resp.readEntity(String.class), FeatureType.class);
    }

    public LayerType getLayerType(String gosEndpoint, String name) throws IOException {
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getLayerType/" + name).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        return (LayerType)this.getMapper().readValue((String)resp.readEntity(String.class), LayerType.class);
    }

    public GeoserverLayer getGeoserverLayer(String gosEndpoint, String name) throws IOException {
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getGeoserverLayer/" + name).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        return (GeoserverLayer)this.getMapper().readValue((String)resp.readEntity(String.class), GeoserverLayer.class);
    }

    public List<GeoserverLayer> getGeoserverLayers(String gosEndpoint, String datastoreName) throws IOException {
        String geoserverLayersJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getGeoserverLayers/" + datastoreName).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(String.class);
        TypeReference<List<GeoserverLayer>> mappingType = new TypeReference<List<GeoserverLayer>>(){};
        return (List)this.getMapper().readValue(geoserverLayersJSON, (TypeReference)mappingType);
    }

    public String getStyle(String gosEndpoint, String name) throws IOException {
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getStyle/" + name).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        return (String)resp.readEntity(String.class);
    }

    public List<String> getAllStyles(String gosEndpoint) throws IOException {
        String stylesJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getAllStyles").request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(String.class);
        TypeReference<List<String>> mappingType = new TypeReference<List<String>>(){};
        return (List)this.getMapper().readValue(stylesJSON, (TypeReference)mappingType);
    }

    public List<String> listDataStores(String gosEndpoint) throws IOException {
        String datastoresJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/listDataStores").request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(String.class);
        TypeReference<List<String>> mappingType = new TypeReference<List<String>>(){};
        return (List)this.getMapper().readValue(datastoresJSON, (TypeReference)mappingType);
    }

    public List<GeoserverLayer> listLayersOfDataStore(String gosEndpoint, String datastoreName) throws IOException {
        String geoserverLayersJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/listLayersOfDataStore/" + datastoreName).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(String.class);
        TypeReference<List<GeoserverLayer>> mappingType = new TypeReference<List<GeoserverLayer>>(){};
        return (List)this.getMapper().readValue(geoserverLayersJSON, (TypeReference)mappingType);
    }

    public boolean removeLayerStyle(String gosEndpoint, String layerName, String styleName, Integer minScale, Integer maxScale) throws IOException {
        Invocation.Builder invocationBuilder;
        Response resp;
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerName", (Object)layerName);
        formData.add((Object)"styleName", (Object)styleName);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)String.valueOf(minScale));
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)String.valueOf(maxScale));
        }
        return (resp = (invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/removeLayerStyle").request(new String[]{"application/json"})).post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE))).getStatus() == 201;
    }

    public boolean removeStyle(String gosEndpoint, String styleName, Integer minScale, Integer maxScale) throws IOException {
        Invocation.Builder invocationBuilder;
        Response resp;
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"styleName", (Object)styleName);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)String.valueOf(minScale));
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)String.valueOf(maxScale));
        }
        return (resp = (invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/removeStyle").request(new String[]{"application/json"})).post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE))).getStatus() == 201;
    }

    public boolean removeStyle(String gosEndpoint, String styleName) throws IOException {
        return this.removeStyle(gosEndpoint, styleName, null, null);
    }

    public boolean setDefaultLayerStyle(String gosEndpoint, String layerName, String styleName, String sld, Integer minScale, Integer maxScale) throws IOException {
        Invocation.Builder invocationBuilder;
        Response resp;
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerName", (Object)layerName);
        formData.add((Object)"styleName", (Object)styleName);
        formData.add((Object)"sld", (Object)sld);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)String.valueOf(minScale));
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)String.valueOf(maxScale));
        }
        return (resp = (invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/setDefaultLayerStyle").request(new String[]{"application/json"})).post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE))).getStatus() == 201;
    }

    public boolean workspaceExists(String gosEndpoint, String workspaceName) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"workspaceName", (Object)workspaceName);
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/workspaceExists").request(new String[]{"application/json"});
        Response resp = invocationBuilder.post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return (Boolean)resp.readEntity(Boolean.class);
    }

    public PublishConfig getGeoTIFFPublishConfig(String gosEndpoint, String layerId) throws Exception {
        ClientResponse resp = (ClientResponse)this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getGeoTIFFPublishConfig/" + layerId).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(ClientResponse.class);
        return (PublishConfig)this.getMapper().readValue((String)resp.readEntity(String.class), PublishConfig.class);
    }

    public void publishGeoTIFF(String gosEndpoint, PublishConfig publishConfig, Coverage coverage) throws Exception {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"publishConfig", (Object)this.getMapper().writeValueAsString((Object)publishConfig));
        formData.add((Object)"geotiff", (Object)this.getMapper().writeValueAsString((Object)coverage));
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/publishGeoTIFF").request(new String[]{"application/json"});
        Response response = invocationBuilder.post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            throw new Exception();
        }
    }

    public void publishGeoTIFF(String gosEndpoint, PublishConfig publishConfig, Coverage coverage, InputStream geotiff) throws Exception {
        FormDataBodyPart filePart = new FormDataBodyPart("file", (Object)geotiff, javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE);
        FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
        FormDataMultiPart formData = (FormDataMultiPart)formDataMultiPart.field("publishConfig", this.getMapper().writeValueAsString((Object)publishConfig)).field("coverage", this.getMapper().writeValueAsString((Object)coverage)).bodyPart((BodyPart)filePart);
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/publishGeoTIFF").request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        Response response = invocationBuilder.post(Entity.entity((Object)formData, (String)"multipart/form-data"));
        formDataMultiPart.close();
        formData.close();
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            throw new Exception();
        }
    }

    public void publishGeoTIFFStream(String gosEndpoint, PublishConfig publishConfig, InputStream inputStream) throws Exception {
        String sContentDisposition = "attachment; config=\"" + this.getMapper().writeValueAsString((Object)publishConfig) + "\"";
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/publishGeoTIFF/stream").request().header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        Response response = invocationBuilder.post(Entity.entity((Object)inputStream, (String)"application/octet-stream"));
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            throw new Exception();
        }
    }

    public void publishNetCDF(String gosEndpoint, NetCDFPublishConfig publishConfig, Coverage coverage, InputStream netCDF) throws Exception {
        FormDataBodyPart filePart = new FormDataBodyPart("file", (Object)netCDF, javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE);
        FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
        FormDataMultiPart formData = (FormDataMultiPart)formDataMultiPart.field("publishConfig", this.getMapper().writeValueAsString((Object)publishConfig)).field("coverage", this.getMapper().writeValueAsString((Object)coverage)).bodyPart((BodyPart)filePart);
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/publishNetCDF").request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        Response response = invocationBuilder.post(Entity.entity((Object)formData, (String)"multipart/form-data"));
        formDataMultiPart.close();
        formData.close();
        formData.getBodyParts().forEach(bp -> bp.cleanup());
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            throw new Exception();
        }
    }

    public void publishNetCDFStream(String gosEndpoint, PublishConfig publishConfig, InputStream inputStream) throws Exception {
        String sContentDisposition = "attachment; config=\"" + this.getMapper().writeValueAsString((Object)publishConfig) + "\"";
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/publishNetCDF/stream").request().header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        Response response = invocationBuilder.post(Entity.entity((Object)inputStream, (String)"application/octet-stream"));
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            throw new Exception();
        }
    }

    public void seedGeoTIFFLayerGeoWebCache(String gosEndpoint, String seedRequest, String layerName) {
        logger.debug("Sending seed request to gos");
        MultivaluedHashMap multipart = new MultivaluedHashMap();
        multipart.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        multipart.add((Object)"seedRequest", (Object)seedRequest);
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/seedGeoTIFF/" + layerName).request().header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        Response response = invocationBuilder.post(Entity.entity((Object)multipart, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getCachedLayers(String gosEndpoint) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        Response response = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getCachedLayers").request(new String[]{"application/xml"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get();
        TypeReference<List<String>> mappingType = new TypeReference<List<String>>(){};
        String responseString = (String)response.readEntity(String.class);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LayerGwcAtomXML.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            LayerGwcAtomXML layers = (LayerGwcAtomXML)jaxbUnmarshaller.unmarshal((Reader)new StringReader(responseString));
            List<String> res = layers.getLayers().stream().map(LayerBean::getName).collect(Collectors.toList());
            return res;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FeatureType getLayerAttributesByLayerID(UUID layerID, String gosEndpoint) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerID", (Object)this.getMapper().writeValueAsString((Object)layerID.toString()));
        Invocation.Builder invocationBuilder = this.getJerseyClient().target(gosEndpoint).path("/GeoserverManagement/getLayerAttributesByLayerID/").request();
        Response resp = invocationBuilder.post(Entity.entity((Object)formData, (javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return (FeatureType)this.getMapper().readValue((String)resp.readEntity(String.class), FeatureType.class);
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        return sb.toString();
    }
}

