/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.gos.client.GosManagement;
import gr.cite.gos.client.helpers.Transforming;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientResponse;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class ShapeManagement
extends GosManagement {
    public ShapeManagement(String authenticationStr) {
        super(authenticationStr);
    }

    public List<String> getLayers(String gosEndpoint) throws IOException {
        String jsonLayerIds = (String)this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/existingLayerIDs").request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(String.class);
        TypeReference<List<String>> mappingType = new TypeReference<List<String>>(){};
        return (List)this.getMapper().readValue(jsonLayerIds, (TypeReference)mappingType);
    }

    public Shape getShapeByID(String gosEndpoint, String shapeID) throws Exception {
        String shapeMessengerJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/getShapeByID/" + shapeID).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(String.class);
        return shapeMessengerJSON != null && !shapeMessengerJSON.isEmpty() ? ((ShapeMessenger)this.getMapper().readValue(shapeMessengerJSON, ShapeMessenger.class)).toShape() : null;
    }

    public boolean deleteShape(String gosEndpoint, String shapeID) throws Exception {
        ClientResponse resp = (ClientResponse)this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/deleteShape/" + shapeID).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).delete(ClientResponse.class);
        return resp.getStatus() == 200;
    }

    public boolean deleteShapes(String gosEndpoint, List<String> shapeIDs) throws JsonProcessingException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeIDs", (Object)this.getMapper().writeValueAsString(shapeIDs));
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/deleteShapes").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (String)"multipart/form-data"));
        return resp.getStatus() == 200;
    }

    public List<Shape> searchShapes(String gosEndpoint, List<String> terms) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"termsListJSON", (Object)this.getMapper().writeValueAsString(terms));
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/searchShapes").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (String)"multipart/form-data"));
        TypeReference<ArrayList<ShapeMessenger>> mappingType = new TypeReference<ArrayList<ShapeMessenger>>(){};
        return Transforming.fromShapeMessenger((List)this.getMapper().readValue((String)resp.readEntity(String.class), (TypeReference)mappingType));
    }

    public List<Shape> searchShapesWithinByAttributes(String gosEndpoint, Map<String, Shape.Attribute> attrs, Shape shape) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"attrsJSON", (Object)this.getMapper().writeValueAsString(attrs));
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/searchShapesWithinByAttributes").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (String)"multipart/form-data"));
        TypeReference<List<ShapeMessenger>> mappingType = new TypeReference<List<ShapeMessenger>>(){};
        return Transforming.fromShapeMessenger((List)this.getMapper().readValue((String)resp.readEntity(String.class), (TypeReference)mappingType));
    }

    public List<Shape> findContains(String gosEndpoint, Shape shape) throws Exception {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        String shapeMessengersJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/findContains").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (String)"multipart/form-data")).readEntity(String.class);
        TypeReference<List<ShapeMessenger>> mappingType = new TypeReference<List<ShapeMessenger>>(){};
        return Transforming.fromShapeMessenger((List)this.getMapper().readValue(shapeMessengersJSON, (TypeReference)mappingType));
    }

    public List<Shape> findWithin(String gosEndpoint, Shape shape) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        String shapeMessengersJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/findWithin").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (String)"multipart/form-data")).readEntity(String.class);
        TypeReference<List<Shape>> mappingType = new TypeReference<List<Shape>>(){};
        return (List)this.getMapper().readValue(shapeMessengersJSON, (TypeReference)mappingType);
    }

    public boolean insertShapes(String gosEndpoint, Collection<Shape> shapes) throws Exception {
        int chunkSize = 5000;
        String layerID = null;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.isEmpty()) {
            tempDir = "/tmp";
        }
        Iterator<Shape> iter = shapes.iterator();
        long iterIdx = 0L;
        DB filelistDB = DBMaker.tempFileDB().closeOnJvmShutdown().fileMmapEnableIfSupported().fileDeleteAfterClose().make();
        List shapesSublist = (List)filelistDB.indexTreeList("shapesSublist:" + UUID.randomUUID()).create();
        while (iter.hasNext()) {
            Shape sh = iter.next();
            if (sh != null) {
                layerID = sh.getLayerID().toString();
            }
            shapesSublist.add(sh);
            if (iterIdx % (long)chunkSize == 0L && !shapesSublist.isEmpty()) {
                block27: {
                    try {
                        MultivaluedHashMap formData = new MultivaluedHashMap();
                        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
                        formData.add((Object)"shapeMessengerListJSON", (Object)this.getMapper().writeValueAsString(shapesSublist.parallelStream().map(shape -> new ShapeMessenger((Shape)shape)).collect(Collectors.toList())));
                        Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/insertShapes").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                        if (resp.getStatus() == 201) break block27;
                        if (layerID != null) {
                            try {
                                new File(tempDir + "/" + layerID).delete();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (!filelistDB.isClosed()) {
                            filelistDB.close();
                        }
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (layerID != null) {
                            try {
                                new File(tempDir + "/" + layerID).delete();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (!filelistDB.isClosed()) {
                            filelistDB.close();
                        }
                        return false;
                    }
                }
                shapesSublist.clear();
            }
            ++iterIdx;
        }
        if (!shapesSublist.isEmpty()) {
            block28: {
                try {
                    MultivaluedHashMap formData = new MultivaluedHashMap();
                    formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
                    formData.add((Object)"shapeMessengerListJSON", (Object)this.getMapper().writeValueAsString(shapesSublist.parallelStream().map(shape -> new ShapeMessenger((Shape)shape)).collect(Collectors.toList())));
                    Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/insertShapes").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                    if (resp.getStatus() == 201) break block28;
                    if (layerID != null) {
                        try {
                            new File(tempDir + "/" + layerID).delete();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (!filelistDB.isClosed()) {
                        filelistDB.close();
                    }
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (layerID != null) {
                        try {
                            new File(tempDir + "/" + layerID).delete();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (!filelistDB.isClosed()) {
                        filelistDB.close();
                    }
                    return false;
                }
            }
            shapesSublist.clear();
        }
        try {
            new File(tempDir + "/" + layerID).delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public boolean insertShape(String gosEndpoint, Shape shape) throws Exception {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/insertShape").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return resp.getStatus() == 201;
    }

    public boolean updateShape(String gosEndpoint, Shape shape) throws Exception {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"shapeMessengerJSON", (Object)this.getMapper().writeValueAsString((Object)new ShapeMessenger(shape)));
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/updateShape").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return resp.getStatus() == 201;
    }

    public List<Shape> getShapesOfLayerID(String gosEndpoint, String layerID) throws Exception {
        String shapeMessengerListJSON = (String)this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/shapesOfLayerID/" + layerID).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(String.class);
        TypeReference<ArrayList<ShapeMessenger>> mappingType = new TypeReference<ArrayList<ShapeMessenger>>(){};
        return Transforming.fromShapeMessenger((List)this.getMapper().readValue(shapeMessengerListJSON, (TypeReference)mappingType));
    }

    public Set<String> getAttributeValuesOfShapesByLayer(String gosEndpoint, String layerID, Shape.Attribute attribute) throws Exception {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"attributeJSON", (Object)this.getMapper().writeValueAsString((Object)attribute));
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/getAttributeValuesOfShapesByLayer/" + layerID).request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        TypeReference<Set<String>> mappingType = new TypeReference<Set<String>>(){};
        return (Set)this.getMapper().readValue((String)resp.readEntity(String.class), (TypeReference)mappingType);
    }

    public boolean deleteShapesOfLayer(String gosEndpoint, String layerID) {
        Response resp = (Response)this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/deleteShapesOfLayer/" + layerID).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).delete(Response.class);
        return resp.getStatus() == 200;
    }

    public long countShapesOfLayer(String gosEndpoint, String layerID) {
        return (Long)this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/countShapesOfLayer/" + layerID).request(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).get(Long.class);
    }

    public boolean applyOnView(String gosEndpoint, String statement) throws Exception {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"statement", (Object)statement);
        Response resp = this.getJerseyClient().target(gosEndpoint).path("/ShapeManagement/applyOnView").request(new String[]{"application/json"}).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        return resp.getStatus() == Response.Status.CREATED.getStatusCode();
    }
}

