package gr.cite.regional.data.collection.addin.authentication.application.controllers;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@RestController
@CrossOrigin
@RequestMapping("/" + AuthenticationController.AUTHENTICATION_ENDPOINT)
public class AuthenticationController extends BaseController {
	static final String AUTHENTICATION_ENDPOINT = "authentications";
	private static final Logger logger = LogManager.getLogger(AuthenticationController.class);
	
	private String redirectUri;
	private String clientId;
	private String clientSecret;
	
	private WebTarget target;

	@Autowired
	public AuthenticationController(String hostname, String redirectUri, String clientId, String clientSecret) {
		this.redirectUri = redirectUri;
		this.clientId = clientId;
		this.clientSecret = clientSecret;
		
		this.target = ClientBuilder.newClient().target(hostname);
	}
	
	@RequestMapping(value = "", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
	public ResponseEntity<Object> authenticate(@RequestParam(value = "code", required = true) String code) {
		
		MultivaluedMap<String, String> formData = new MultivaluedHashMap<>();
		formData.add("grant_type", "authorization_code");
		formData.add("code", code);
		formData.add("redirect_uri", this.redirectUri);
		formData.add("client_id", this.clientId);
		formData.add("client_secret", this.clientSecret);
		
		Response response = this.target.request().header("gcube-token", this.clientSecret).post(Entity.form(formData));
		
		logger.info("Authentication service responded with status: " + response.getStatus() + " - code: [" + code + "]");
		if (response.getStatus() < 200 && response.getStatus() >= 300) {
			logger.error("Error message is: " + response.readEntity(String.class));
		}
		
		return ResponseEntity.status(response.getStatus()).body(response.readEntity(String.class));
	}
}