/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.dataaccess.entities;

import gr.cite.regional.data.collection.dataaccess.entities.DataModel;
import gr.cite.regional.data.collection.dataaccess.entities.DataSubmission;
import gr.cite.regional.data.collection.dataaccess.entities.Domain;
import gr.cite.regional.data.collection.dataaccess.entities.Entity;
import gr.cite.regional.data.collection.dataaccess.types.XMLType;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

@javax.persistence.Entity
@Table(name="\"DataCollection\"")
@TypeDef(name="XMLType", typeClass=XMLType.class)
public class DataCollection
implements Entity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="datacollection_generator")
    @SequenceGenerator(name="datacollection_generator", sequenceName="datacollection_id_seq", allocationSize=1)
    @Column(name="\"ID\"", updatable=false, nullable=false)
    private Integer id;
    @Column(name="\"Label\"", nullable=true, length=100)
    private String label;
    @Column(name="\"Status\"", nullable=false)
    private Integer status;
    @Temporal(value=TemporalType.DATE)
    @Column(name="\"StartDate\"", nullable=true)
    private Date startDate;
    @Temporal(value=TemporalType.DATE)
    @Column(name="\"EndDate\"", nullable=true)
    private Date endDate;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="\"Domain\"", nullable=false)
    private Domain domain;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="\"DataModel\"", nullable=false)
    private DataModel dataModel;
    @Type(type="XMLType")
    @Column(name="\"Attributes\"", columnDefinition="xml")
    private String attributes;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dataCollection", cascade={CascadeType.ALL})
    private Set<DataSubmission> dataSubmissions = new HashSet<DataSubmission>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public Set<DataSubmission> getDataSubmissions() {
        return this.dataSubmissions;
    }

    public void setDataSubmissions(Set<DataSubmission> dataSubmissions) {
        this.dataSubmissions = dataSubmissions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataCollection other = (DataCollection)obj;
        return this.id == other.id;
    }
}

