package gr.cite.regional.data.collection.dataaccess.entities;

public enum SubmissionStatus {
	COMPLETED(0),
	PENDING(1);

	private final Integer submissionStatusCode;

	SubmissionStatus(Integer submissionStatus) {
		this.submissionStatusCode = submissionStatus;
	}
	
	public Integer getSubmissionStatusCode() {
		return this.submissionStatusCode;
	}

	public static SubmissionStatus fromSubmissionStatusCode(Integer submissionStatus) {
		switch (submissionStatus) {
			case 0:
				return SubmissionStatus.COMPLETED;
			case 1:
				return SubmissionStatus.PENDING;
			default:
				throw new IllegalStateException("Unexpected value: " + submissionStatus);
		}
	}
}
