package gr.cite.regional.data.collection.dataaccess.entities.convertes;

import gr.cite.regional.data.collection.dataaccess.entities.SubmissionStatus;

import javax.persistence.AttributeConverter;

public class SubmissionStatusConverter implements AttributeConverter<SubmissionStatus, Integer> {
	public Integer convertToDatabaseColumn(SubmissionStatus value) {
		if ( value == null ) {
			return null;
		}

		return value.getSubmissionStatusCode();
	}

	public SubmissionStatus convertToEntityAttribute(Integer value) {
		if ( value == null ) {
			return null;
		}

		return SubmissionStatus.fromSubmissionStatusCode(value);
	}
}
