/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.dataaccess.daos;

import gr.cite.regional.data.collection.dataaccess.daos.CdtDao;
import gr.cite.regional.data.collection.dataaccess.dsd.ColumnAndType;
import gr.cite.regional.data.collection.dataaccess.entities.Cdt;
import gr.cite.regional.data.collection.dataaccess.entities.DataSubmission;
import gr.cite.regional.data.collection.dataaccess.entities.Status;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public class CdtDaoImpl
implements CdtDao {
    private static final String TABLE_NAME_PREFIX = "CDT_";
    private static final String COLUMN_NAME_PREFIX = "DM_";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void createTable(String tableNameSuffix, List<ColumnAndType> dmColumnsAndTypes) {
        this.entityManager.createNativeQuery("CREATE TABLE \"" + this.getTableName(tableNameSuffix) + "\" (\"ID\" uuid PRIMARY KEY,\"Ordinal\" INTEGER NOT NULL,\"Status\" INTEGER NOT NULL,\"DataSubmission\" INTEGER NOT NULL," + this.getColumnsAndTypesOrdered(dmColumnsAndTypes) + ")").executeUpdate();
    }

    @Override
    public void deleteTable(String tableNameSuffix) {
        this.entityManager.createNativeQuery("DROP TABLE \"" + this.getTableName(tableNameSuffix) + "\"").executeUpdate();
    }

    private String getColumnsAndTypesOrdered(List<ColumnAndType> dmColumnsAndTypes) {
        return dmColumnsAndTypes.stream().map(columnAndType -> "\"" + this.getColumnName(columnAndType.getName()) + "\" " + this.mapDatatypeToSqlDatatype(columnAndType.getDatatype())).collect(Collectors.joining(","));
    }

    private String mapDatatypeToSqlDatatype(String datatype) {
        switch (datatype) {
            case "string": {
                return "VARCHAR(250)";
            }
            case "integer": {
                return "INTEGER";
            }
        }
        return "VARCHAR(250)";
    }

    @Override
    public Cdt create(Cdt cdt, List<ColumnAndType> dmColumnsAndTypes, String tableNameSuffix) {
        if (cdt.getId() == null) {
            cdt.setId(UUID.randomUUID());
        }
        this.entityManager.createNativeQuery("INSERT INTO \"" + this.getTableName(tableNameSuffix) + "\" VALUES " + this.buildCdtValue(cdt, dmColumnsAndTypes)).executeUpdate();
        return cdt;
    }

    @Override
    public List<Cdt> create(List<Cdt> cdts, List<ColumnAndType> dmColumnsAndTypes, String tableNameSuffix) {
        cdts.stream().filter(cdt -> cdt != null && cdt.getId() == null).forEach(cdt -> cdt.setId(UUID.randomUUID()));
        this.entityManager.createNativeQuery("INSERT INTO \"" + this.getTableName(tableNameSuffix) + "\" (" + this.getColumnNames(dmColumnsAndTypes) + ") VALUES " + cdts.stream().map(cdt -> this.buildCdtValue((Cdt)cdt, dmColumnsAndTypes)).collect(Collectors.joining(","))).executeUpdate();
        return cdts;
    }

    private String getColumnNames(List<ColumnAndType> dmColumnsAndTypes) {
        return "\"ID\", \"Ordinal\", \"Status\", \"DataSubmission\", " + dmColumnsAndTypes.stream().map(col -> "\"" + this.getColumnName(col.getName()) + "\"").collect(Collectors.joining(", "));
    }

    private String buildCdtValue(Cdt cdt, List<ColumnAndType> dmColumnsAndTypes) {
        return "('" + cdt.getId() + "'," + cdt.getOrdinal() + "," + cdt.getStatus() + "," + cdt.getDataSubmission().getId() + "," + this.stringifyValuesOrdered(cdt, dmColumnsAndTypes) + ")";
    }

    private String stringifyValuesOrdered(Cdt cdt, List<ColumnAndType> dmColumnsAndTypes) {
        return dmColumnsAndTypes.stream().map(columnAndType -> this.mapValueToSqlValue(cdt.getData().get(columnAndType.getName()), columnAndType.getDatatype())).collect(Collectors.joining(","));
    }

    @Override
    public Cdt update(Cdt cdt, List<ColumnAndType> dmColumnsAndTypes, String tableNameSuffix) {
        this.entityManager.createNativeQuery("UPDATE \"" + this.getTableName(tableNameSuffix) + "\" SET \"Ordinal\"=" + cdt.getOrdinal() + ", \"Status\"=" + cdt.getStatus() + ", \"DataSubmission\"=" + cdt.getDataSubmission().getId() + ", " + this.stringifyColumnEqualsValue(cdt, dmColumnsAndTypes) + " WHERE \"ID\"='" + cdt.getId() + "'").executeUpdate();
        return cdt;
    }

    private String stringifyColumnEqualsValue(Cdt cdt, List<ColumnAndType> dmColumnsAndTypes) {
        return dmColumnsAndTypes.stream().map(columnAndType -> "\"" + this.getColumnName(columnAndType.getName()) + "\"=" + this.mapValueToSqlValue(cdt.getData().get(columnAndType.getName()), columnAndType.getDatatype())).collect(Collectors.joining(","));
    }

    private String mapValueToSqlValue(Object value, String datatype) {
        switch (datatype) {
            case "string": {
                return value != null ? "'" + value + "'" : null;
            }
            case "integer": {
                return value != null ? value.toString() : null;
            }
        }
        return value != null ? "'" + value + "'" : null;
    }

    @Override
    public Cdt read(UUID id, String tableNameSuffix) {
        return (Cdt)this.entityManager.createNativeQuery("SELECT * FROM \"" + this.getTableName(tableNameSuffix) + "\" WHERE \"ID\"='" + id + "'", Cdt.class).getSingleResult();
    }

    @Override
    public List<Cdt> getByDataSubmissionId(Integer dataSubmissionId, String tableNameSuffix, List<String> dmColumnNames) {
        List rows = this.entityManager.createNativeQuery("SELECT CAST(\"ID\" AS VARCHAR), \"Ordinal\",  \"Status\", \"DataSubmission\", " + dmColumnNames.stream().map(field -> "\"DM_" + field + "\"").collect(Collectors.joining(", ")) + " FROM \"" + this.getTableName(tableNameSuffix) + "\" WHERE \"DataSubmission\"='" + dataSubmissionId + "' AND \"Status\"=" + Status.ACTIVE.getStatusCode()).getResultList();
        return rows.stream().map(row -> this.transformRowToCdt((Object[])row, dmColumnNames)).collect(Collectors.toList());
    }

    @Override
    public void deactivateByDataSubmissionId(Integer dataSubmissionId, String tableNameSuffix) {
        this.entityManager.createNativeQuery("UPDATE \"" + this.getTableName(tableNameSuffix) + "\" SET \"Status\"=" + Status.INACTIVE.getStatusCode() + " WHERE \"DataSubmission\"='" + dataSubmissionId + "' AND \"Status\"=" + Status.ACTIVE.getStatusCode()).executeUpdate();
    }

    private Cdt transformRowToCdt(Object[] row, List<String> dmColumnNames) {
        Cdt cdtEntity = new Cdt();
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < row.length; ++i) {
            this.mapColumnToCdtField(row[i], i, dmColumnNames, cdtEntity, data);
        }
        cdtEntity.setData(data);
        return cdtEntity;
    }

    private void mapColumnToCdtField(Object column, int columnIndex, List<String> dmColumnNames, Cdt cdtEntity, Map<String, Object> data) {
        switch (columnIndex) {
            case 0: {
                cdtEntity.setId(UUID.fromString(column.toString()));
                break;
            }
            case 1: {
                cdtEntity.setOrdinal(Integer.parseInt(column.toString()));
                break;
            }
            case 2: {
                cdtEntity.setStatus(Integer.parseInt(column.toString()));
                break;
            }
            case 3: {
                DataSubmission dataSubmission = new DataSubmission();
                dataSubmission.setId(Integer.parseInt(column.toString()));
                cdtEntity.setDataSubmission(dataSubmission);
                break;
            }
            default: {
                data.put(dmColumnNames.get(columnIndex - 4), column);
            }
        }
    }

    private String getTableName(String tableNameSuffix) {
        return TABLE_NAME_PREFIX + tableNameSuffix;
    }

    private String getColumnName(String columnNameSuffix) {
        return COLUMN_NAME_PREFIX + columnNameSuffix;
    }
}

